/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import vectorwing.farmersdelight.data.Advancements;
import vectorwing.farmersdelight.data.BlockStates;
import vectorwing.farmersdelight.data.BlockTags;
import vectorwing.farmersdelight.data.DamageTypeTags;
import vectorwing.farmersdelight.data.DataMaps;
import vectorwing.farmersdelight.data.EnchantmentTags;
import vectorwing.farmersdelight.data.EntityTags;
import vectorwing.farmersdelight.data.ItemModels;
import vectorwing.farmersdelight.data.ItemTags;
import vectorwing.farmersdelight.data.ModEnchantments;
import vectorwing.farmersdelight.data.Recipes;
import vectorwing.farmersdelight.data.loot.FDBlockLoot;
import vectorwing.farmersdelight.data.tools.StructureUpdater;

@EventBusSubscriber(modid="farmersdelight", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistrySetBuilder registrySetBuilder = new RegistrySetBuilder().add(Registries.ENCHANTMENT, ModEnchantments::bootstrap);
        BlockTags blockTags = new BlockTags(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(output, lookupProvider, blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTags(output, lookupProvider, "farmersdelight", helper));
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(output, lookupProvider, registrySetBuilder, Set.of("farmersdelight"));
        CompletableFuture builtinLookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new EnchantmentTags(output, builtinLookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMaps(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new Advancements(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(FDBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureUpdater("structures/village/houses", "farmersdelight", helper, output));
        BlockStates blockStates = new BlockStates(output, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, blockStates.models().existingFileHelper));
    }
}

