/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.texelsaurus.minecraft.chameleon.config.ConfigSpec;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoforgeConfig
implements ChameleonConfig {
    private final ConfigSpec localSpec;
    private final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public ModConfigSpec neoSpec;

    public NeoforgeConfig() {
        this.localSpec = null;
    }

    private NeoforgeConfig(ConfigSpec spec) {
        this.localSpec = spec;
    }

    @Override
    public void init(String modId, ChameleonConfig.Type type) {
        this.localSpec.init();
        this.neoSpec = this.BUILDER.build();
    }

    @Override
    public <T extends ChameleonConfig> T create(ConfigSpec spec) {
        return (T)new NeoforgeConfig(spec);
    }

    @Override
    public <T> ChameleonConfig.ConfigEntry<T> define(String name, T defaultValue) {
        return new ForgeConfigEntry(this, this.BUILDER).name(name).defaultValue(defaultValue);
    }

    @Override
    public <T extends Comparable<? super T>> ChameleonConfig.ConfigEntry<T> defineInRange(String name, T defaultValue, T min, T max, Class<T> clazz) {
        return new ForgeConfigEntryRange<T>(this, this.BUILDER, clazz).name(name).defaultValue(defaultValue).range(min, max);
    }

    @Override
    public <T extends Enum<T>> ChameleonConfig.ConfigEntry<T> defineEnum(String name, T defaultValue) {
        return new ForgeConfigEntryEnum(this, this.BUILDER).name(name).defaultValue(defaultValue);
    }

    @Override
    public <T> ChameleonConfig.ConfigEntry<List<? extends T>> defineList(String name, List<? extends T> defaultList, Predicate<Object> elementValidator) {
        return new ForgeConfigEntryList(this, this.BUILDER).validator(elementValidator).name(name).defaultValue(defaultList);
    }

    @Override
    public void pushGroup(String name) {
        this.BUILDER.push(name);
    }

    @Override
    public void popGroup() {
        this.BUILDER.pop();
    }

    @Override
    public void comment(String comment) {
        this.BUILDER.comment(" " + comment);
    }

    @Override
    public void comment(String ... comment) {
        this.BUILDER.comment((String[])Arrays.stream(comment).map(s -> " " + s).toArray(String[]::new));
    }

    public class ForgeConfigEntry<T>
    extends ChameleonConfig.ConfigEntry<T> {
        ModConfigSpec.Builder builder;
        ModConfigSpec.ConfigValue<T> value;

        public ForgeConfigEntry(NeoforgeConfig this$0, ModConfigSpec.Builder builder) {
            this.builder = builder;
        }

        @Override
        public ChameleonConfig.ConfigEntry<T> build() {
            if (this.comment != null) {
                this.builder.comment((String[])Arrays.stream(this.comment).map(s -> " " + s).toArray(String[]::new));
            }
            this.value = this.define();
            return this;
        }

        @Override
        public T get() {
            if (this.value == null) {
                return (T)this.defaultValue;
            }
            return (T)this.value.get();
        }

        @Override
        public void set(T t) {
            if (this.value != null) {
                this.value.set(t);
            }
        }

        protected ModConfigSpec.ConfigValue<T> define() {
            return this.builder.define(this.name, this.defaultValue);
        }
    }

    public class ForgeConfigEntryRange<T extends Comparable<? super T>>
    extends ForgeConfigEntry<T> {
        Class<T> clazz;

        public ForgeConfigEntryRange(NeoforgeConfig this$0, ModConfigSpec.Builder builder, Class<T> clazz) {
            super(this$0, builder);
            this.clazz = clazz;
        }

        @Override
        protected ModConfigSpec.ConfigValue<T> define() {
            return this.builder.defineInRange(this.name, (Comparable)this.defaultValue, (Comparable)this.rangeMin, (Comparable)this.rangeMax, this.clazz);
        }
    }

    public class ForgeConfigEntryEnum<T extends Enum<T>>
    extends ForgeConfigEntry<T> {
        public ForgeConfigEntryEnum(NeoforgeConfig this$0, ModConfigSpec.Builder builder) {
            super(this$0, builder);
        }

        @Override
        protected ModConfigSpec.ConfigValue<T> define() {
            return this.builder.defineEnum(this.name, (Enum)this.defaultValue);
        }
    }

    public class ForgeConfigEntryList<T>
    extends ForgeConfigEntry<List<? extends T>> {
        Predicate<Object> validator = x -> true;

        public ForgeConfigEntryList(NeoforgeConfig this$0, ModConfigSpec.Builder builder) {
            super(this$0, builder);
        }

        public ForgeConfigEntryList<T> validator(Predicate<Object> validtor) {
            if (validtor != null) {
                this.validator = validtor;
            }
            return this;
        }

        @Override
        protected ModConfigSpec.ConfigValue<List<? extends T>> define() {
            return this.builder.defineList(this.name, (List)this.defaultValue, this.validator);
        }
    }
}

