/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class CompTierRegistry {
    public static final CompTierRegistry INSTANCE = new CompTierRegistry();
    private final List<Record> records = new ArrayList<Record>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.compacting.enableExtraCompactingRules.get()).booleanValue()) {
            this.register(new ItemStack((ItemLike)Blocks.CLAY), new ItemStack((ItemLike)Items.CLAY_BALL), 4);
            this.register(new ItemStack((ItemLike)Blocks.SNOW_BLOCK), new ItemStack((ItemLike)Items.SNOWBALL), 4);
            this.register(new ItemStack((ItemLike)Blocks.GLOWSTONE), new ItemStack((ItemLike)Items.GLOWSTONE_DUST), 4);
            this.register(new ItemStack((ItemLike)Blocks.BRICKS), new ItemStack((ItemLike)Items.BRICK), 4);
            this.register(new ItemStack((ItemLike)Blocks.NETHER_BRICKS), new ItemStack((ItemLike)Items.NETHER_BRICK), 4);
            this.register(new ItemStack((ItemLike)Blocks.NETHER_WART_BLOCK), new ItemStack((ItemLike)Items.NETHER_WART), 9);
            this.register(new ItemStack((ItemLike)Blocks.QUARTZ_BLOCK), new ItemStack((ItemLike)Items.QUARTZ), 4);
            this.register(new ItemStack((ItemLike)Blocks.MELON), new ItemStack((ItemLike)Items.MELON_SLICE), 9);
            this.register(new ItemStack((ItemLike)Blocks.BAMBOO_BLOCK), new ItemStack((ItemLike)Items.BAMBOO), 9);
        }
        ModCommonConfig.INSTANCE.onLoad(() -> ((List)ModCommonConfig.INSTANCE.DRAWERS.compacting.compRules.get()).forEach(this::register));
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    public boolean register(@NotNull ItemStack upper, @NotNull ItemStack lower, int convRate) {
        if (upper.isEmpty() || lower.isEmpty()) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record(upper.copy(), lower.copy(), convRate);
        r.upper.setCount(1);
        r.lower.setCount(1);
        this.records.add(r);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New compacting rule " + convRate + " " + String.valueOf(lower.getItem()) + " = 1 " + String.valueOf(upper.getItem()));
        }
        return true;
    }

    public static boolean validateRuleSyntax(String rule) {
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = ResourceLocation.tryParse((String)parts[0]);
        ResourceLocation lowerResource = ResourceLocation.tryParse((String)parts[1]);
        if (upperResource == null || lowerResource == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return conv >= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void register(List<String> rules) {
        rules.forEach(this::register);
    }

    public boolean register(String rule) {
        if (!this.initialized) {
            this.pendingRules.add(rule);
            return true;
        }
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = ResourceLocation.parse((String)parts[0]);
        Item upperItem = (Item)BuiltInRegistries.ITEM.get(upperResource);
        ResourceLocation lowerResource = ResourceLocation.parse((String)parts[1]);
        Item lowerItem = (Item)BuiltInRegistries.ITEM.get(lowerResource);
        try {
            int conv = Integer.parseInt(parts[2]);
            return this.register(new ItemStack((ItemLike)upperItem), new ItemStack((ItemLike)lowerItem), conv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean unregisterUpperTarget(@NotNull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.matches((ItemStack)stack, (ItemStack)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(@NotNull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.matches((ItemStack)stack, (ItemStack)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (Record r : this.records) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (Record r : this.records) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r.upper)) continue;
            return r;
        }
        return null;
    }

    public static class Record {
        @NotNull
        public final ItemStack upper;
        @NotNull
        public final ItemStack lower;
        public final int convRate;

        public Record(@NotNull ItemStack upper, @NotNull ItemStack lower, int convRate) {
            this.upper = upper;
            this.lower = lower;
            this.convRate = convRate;
        }
    }
}

