/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.multimeter;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndesires.content.blocks.kinetics.multimeter.GaugeObservedPacket;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MultiMeterBE
extends GaugeBlockEntity {
    static BlockPos lastSent;
    float stressTarget;

    public MultiMeterBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STRESSOMETER, AllAdvancements.STRESSOMETER_MAXED});
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? this.mergeTarget(0.0f) : (this.isOverStressed() ? this.mergeTarget(1.125f) : (maxStress == 0.0f ? this.mergeTarget(0.0f) : this.mergeTarget(currentStress / maxStress)));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? this.mergeColor(Color.mixColors((int)65280, (int)0xFFFF00, (float)(this.dialTarget * 2.0f))) : (this.dialTarget < 1.0f ? this.mergeColor(Color.mixColors((int)0xFFFF00, (int)0xFF0000, (float)(this.dialTarget * 2.0f - 1.0f))) : this.mergeColor(0xFF0000));
        }
        this.sendData();
        this.setChanged();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Double)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).floatValue();
        float target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.lerp((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.lerp((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.lerp((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }

    public float mergeTarget(float stress) {
        this.stressTarget = stress;
        float currSpeed = this.getSpeed();
        float target = MultiMeterBE.getDialTarget(Math.abs(currSpeed));
        if (currSpeed == 0.0f) {
            target = 0.0f;
        }
        return stress > 0.0f ? Mth.clamp((float)this.mergeFloat(stress, target), (float)0.0f, (float)(this.isOverStressed() ? 1.125f : 1.0f)) : target;
    }

    public int mergeColor(int color) {
        return Color.mixColors((int)Color.mixColors((int)IRotate.SpeedLevel.of((float)Math.abs(this.getSpeed())).getColor(), (int)0xFFFFFF, (float)0.25f), (int)color, (float)0.5f);
    }

    public float mergeFloat(float a, float b) {
        return a + (b - a) * 0.5f;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() != 0.0f) {
            this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
        } else {
            this.setChanged();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        CreateLang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)this.isOverStressed()).forGoggles(tooltip);
        float capacity = this.getNetworkCapacity();
        float stressFraction = this.getNetworkStress() / (capacity == 0.0f ? 1.0f : capacity);
        CreateLang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.getTheoreticalSpeed() == 0.0f) {
            CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            CreateLang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float remainingCapacity = capacity - this.getNetworkStress();
            LangBuilder su = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = CreateLang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        if (!this.worldPosition.equals((Object)lastSent)) {
            lastSent = this.worldPosition;
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new GaugeObservedPacket(lastSent));
        }
        return true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket && this.worldPosition.equals((Object)lastSent)) {
            lastSent = null;
        }
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }

    public void onObserved() {
        this.award(AllAdvancements.STRESSOMETER);
        if (Mth.equal((float)this.stressTarget, (float)1.0f)) {
            this.award(AllAdvancements.STRESSOMETER_MAXED);
        }
    }
}

