/*
 * Decompiled with CFR 0.152.
 */
package com.jetpacker06.CreateBrokenBad.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class MatchItem
extends Item {
    public MatchItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Player player = pContext.getPlayer();
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (!(CampfireBlock.canLight((BlockState)blockstate) || CandleBlock.canLight((BlockState)blockstate) || CandleCakeBlock.canLight((BlockState)blockstate))) {
            BlockPos blockpos1 = blockpos.relative(pContext.getClickedFace());
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockpos1, (Direction)pContext.getHorizontalDirection())) {
                level.playSound(player, blockpos1, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState blockstate1 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockpos1);
                level.setBlock(blockpos1, blockstate1, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                ItemStack itemstack = pContext.getItemInHand();
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1, itemstack);
                    itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                    itemstack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return InteractionResult.FAIL;
        }
        level.playSound(player, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
        if (player != null) {
            pContext.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack pStack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext context, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"match_tooltip"));
    }
}

