/*
 * Decompiled with CFR 0.152.
 */
package com.jetpacker06.CreateBrokenBad.block;

import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TrayBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape shape = Stream.of(Block.box((double)0.0, (double)1.0, (double)2.0, (double)16.0, (double)2.0, (double)3.0), Block.box((double)0.0, (double)1.0, (double)3.0, (double)1.0, (double)2.0, (double)13.0), Block.box((double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)2.0, (double)14.0), Block.box((double)15.0, (double)1.0, (double)3.0, (double)16.0, (double)2.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.5, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape rotatedShape = Stream.of(Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.5, (double)15.0), Block.box((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)2.0, (double)1.0), Block.box((double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0, (double)16.0), Block.box((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0), Block.box((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)2.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public TrayBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? shape : rotatedShape;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return super.rotate(state, world, pos, direction);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? shape : rotatedShape;
    }

    public static class Blue
    extends TrayBlock {
        public Blue(BlockBehaviour.Properties p_49795_) {
            super(p_49795_);
        }
    }

    public static class Empty
    extends TrayBlock {
        public Empty(BlockBehaviour.Properties p_49795_) {
            super(p_49795_);
        }
    }

    public static class White
    extends TrayBlock {
        public White(BlockBehaviour.Properties p_49795_) {
            super(p_49795_);
        }
    }
}

