/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.common.utils.TooltipUtil;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.WidgetBuilder;

public class ConfigBuilder {
    private final CommentedConfig config;
    private final ConfigSpec spec;
    private final Deque<String> stack = new ArrayDeque<String>();
    private final List<ConfigValue> configValues = new ArrayList<ConfigValue>();

    public ConfigBuilder(CommentedConfig config, ConfigSpec spec) {
        this.config = config;
        this.spec = spec;
    }

    public ConfigBuilder push(String subPath) {
        this.stack.add(subPath);
        this.comment(false);
        return this;
    }

    public ConfigBuilder push(String subPath, boolean addAllComment) {
        this.stack.add(subPath);
        this.comment(addAllComment);
        return this;
    }

    public ConfigBuilder pop() {
        this.stack.removeLast();
        return this;
    }

    public ConfigBuilder comment(boolean addAllComment) {
        return this.comment(TooltipUtil.getServerConfigTooltip(String.join((CharSequence)".", this.stack.stream().toList()), addAllComment));
    }

    public ConfigBuilder comment(String comment) {
        this.config.setComment(this.stack.stream().toList(), comment);
        return this;
    }

    private void addDefaultValueComment(List<String> path, int defaultValue, int min, int max) {
        String oldComment = this.config.getComment(path);
        this.config.setComment(path, (String)(oldComment == null ? "" : oldComment + "\n ") + "default: %d, min: %d, max: %d".formatted(defaultValue, min, max));
    }

    private void addDefaultValueComment(List<String> path, double defaultValue, double min, double max) {
        String oldComment = this.config.getComment(path);
        this.config.setComment(path, (String)(oldComment == null ? "" : oldComment + "\n ") + String.valueOf(new Formatter(Locale.US).format("default: %.2f, min: %.2f, max: %.2f", defaultValue, min, max)));
    }

    public void correct(ConfigSpec.CorrectionListener listener) {
        this.spec.correct((Config)this.config, listener);
    }

    public List<ConfigValue> getConfigValues() {
        return this.configValues;
    }

    public <T> ConfigValue<T> define(T defaultValue) {
        List<String> path = this.stack.stream().toList();
        this.spec.define(path, defaultValue);
        this.stack.removeLast();
        ConfigValue<T> value = new ConfigValue<T>(this.config, path, defaultValue);
        this.configValues.add(value);
        return value;
    }

    public <T extends Comparable<? super T>> ConfigValue<T> defineInRange(T defaultValue, T min, T max) {
        List<String> path = this.stack.stream().toList();
        this.spec.defineInRange(path, defaultValue, min, max);
        this.stack.removeLast();
        ConfigValue<T> value = new ConfigValue<T>(this.config, path, defaultValue);
        this.configValues.add(value);
        return value;
    }

    public <T> ListValue<T> defineList(List<T> defaultValue, Predicate<Object> validator) {
        List<String> path = this.stack.stream().toList();
        this.spec.defineList(path, defaultValue, validator);
        this.stack.removeLast();
        ListValue<T> value = new ListValue<T>(this.config, path, defaultValue);
        this.configValues.add(value);
        return value;
    }

    public <T> InListValue<T> defineInList(T defaultValue, Collection<T> validValues) {
        List<String> path = this.stack.stream().toList();
        this.spec.defineInList(path, defaultValue, validValues);
        this.stack.removeLast();
        InListValue<T> value = new InListValue<T>(this.config, path, defaultValue, validValues);
        this.configValues.add(value);
        return value;
    }

    public <T extends Enum<T>> EnumValue<T> defineEnum(T defaultValue, Class<T> enumClass) {
        List<String> path = this.stack.stream().toList();
        EnumValue<T> value = new EnumValue<T>(this.config, path, defaultValue, enumClass);
        this.spec.defineInList(path, defaultValue, value.getValidValues());
        this.stack.removeLast();
        this.configValues.add(value);
        return value;
    }

    public BooleanValue define(boolean defaultValue) {
        List<String> path = this.stack.stream().toList();
        this.spec.define(path, (Object)defaultValue);
        this.stack.removeLast();
        BooleanValue value = new BooleanValue(this.config, path, defaultValue);
        this.configValues.add(value);
        return value;
    }

    public StringValue define(String defaultValue) {
        List<String> path = this.stack.stream().toList();
        this.spec.define(path, (Object)defaultValue);
        this.stack.removeLast();
        StringValue value = new StringValue(this.config, path, defaultValue);
        this.configValues.add(value);
        return value;
    }

    public DoubleValue defineInRange(double defaultValue, double min, double max) {
        List<String> path = this.stack.stream().toList();
        this.spec.defineInRange(path, (Comparable)Double.valueOf(defaultValue), (Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
        this.stack.removeLast();
        this.addDefaultValueComment(path, defaultValue, min, max);
        DoubleValue value = new DoubleValue(this.config, path, defaultValue, min, max);
        this.configValues.add(value);
        return value;
    }

    public IntValue defineInRange(int defaultValue, int min, int max) {
        List<String> path = this.stack.stream().toList();
        this.spec.defineInRange(path, (Comparable)Integer.valueOf(defaultValue), (Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max));
        this.stack.removeLast();
        this.addDefaultValueComment(path, defaultValue, min, max);
        IntValue value = new IntValue(this.config, path, defaultValue, min, max);
        this.configValues.add(value);
        return value;
    }

    public static class ConfigValue<T> {
        private final CommentedConfig config;
        private final List<String> path;
        private final T defaultValue;
        private T cachedValue = null;
        private Function<ServerVivePlayer, VivecraftPayloadS2C> packetFunction = null;
        private Consumer<MinecraftServer> updateConsumer = null;

        public ConfigValue(CommentedConfig config, List<String> path, T defaultValue) {
            this.config = config;
            this.path = path;
            this.defaultValue = defaultValue;
        }

        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.config.get(this.path);
            }
            return this.cachedValue;
        }

        public void set(T newValue) {
            this.cachedValue = newValue;
            this.config.set(this.path, newValue);
        }

        public T reset() {
            this.set(this.defaultValue);
            return this.defaultValue;
        }

        protected T getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDefault() {
            return Objects.equals(this.get(), this.getDefaultValue());
        }

        public String getComment() {
            String comment = this.config.getComment(this.path);
            return comment != null ? comment : "";
        }

        public String getPath() {
            return String.join((CharSequence)".", this.path);
        }

        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getBaseWidget(this, width, height);
        }

        public <V extends ConfigValue<T>> V setOnUpdate(Consumer<MinecraftServer> consumer) {
            this.updateConsumer = consumer;
            return (V)this;
        }

        public void onUpdate(MinecraftServer server) {
            if (this.updateConsumer != null) {
                this.updateConsumer.accept(server);
            }
        }

        public <V extends ConfigValue<T>> V setPacketFunction(Function<ServerVivePlayer, VivecraftPayloadS2C> supplier) {
            this.packetFunction = supplier;
            return (V)this;
        }

        @Nullable
        public Function<ServerVivePlayer, VivecraftPayloadS2C> getPacketFunction() {
            return this.packetFunction;
        }
    }

    public static class ListValue<T>
    extends ConfigValue<List<T>> {
        public ListValue(CommentedConfig config, List<String> path, List<T> defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getEditListWidget(this, width, height);
        }
    }

    public static class InListValue<T>
    extends ConfigValue<T> {
        private final Collection<T> validValues;

        public InListValue(CommentedConfig config, List<String> path, T defaultValue, Collection<T> validValues) {
            super(config, path, defaultValue);
            this.validValues = validValues;
        }

        public Collection<T> getValidValues() {
            return this.validValues;
        }

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getCycleWidget(this, this.getValidValues(), width, height);
        }
    }

    public static class EnumValue<T extends Enum<T>>
    extends ConfigValue<T> {
        private final Class<T> enumClass;

        public EnumValue(CommentedConfig config, List<String> path, T defaultValue, Class<T> enumClass) {
            super(config, path, defaultValue);
            this.enumClass = enumClass;
        }

        public T getEnumValue(Object value) {
            try {
                return (T)EnumGetMethod.NAME_IGNORECASE.get(value, this.enumClass);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Collection<T> getValidValues() {
            return EnumSet.allOf(this.enumClass);
        }

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getCycleWidget(this, this.getValidValues(), width, height);
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        public BooleanValue(CommentedConfig config, List<String> path, boolean defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getOnOffWidget(this, width, height);
        }
    }

    public static class StringValue
    extends ConfigValue<String> {
        public StringValue(CommentedConfig config, List<String> path, String defaultValue) {
            super(config, path, defaultValue);
        }

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getEditBoxWidget(this, width, height);
        }
    }

    public static class DoubleValue
    extends NumberValue<Double> {
        public DoubleValue(CommentedConfig config, List<String> path, double defaultValue, double min, double max) {
            super(config, path, defaultValue, min, max);
        }

        @Override
        public void fromNormalized(double value) {
            double newValue = (Double)this.getMin() + ((Double)this.getMax() - (Double)this.getMin()) * value;
            this.set((double)Math.round(newValue * 10.0) / 10.0);
        }
    }

    public static class IntValue
    extends NumberValue<Integer> {
        public IntValue(CommentedConfig config, List<String> path, int defaultValue, int min, int max) {
            super(config, path, defaultValue, min, max);
        }

        @Override
        public void fromNormalized(double value) {
            double newValue = (double)((Integer)this.getMin()).intValue() + (double)((Integer)this.getMax() - (Integer)this.getMin()) * value;
            this.set(Mth.floor((double)(newValue + 0.5)));
        }
    }

    public static abstract class NumberValue<E extends Number>
    extends ConfigValue<E> {
        private final E min;
        private final E max;

        public NumberValue(CommentedConfig config, List<String> path, E defaultValue, E min, E max) {
            super(config, path, defaultValue);
            this.min = min;
            this.max = max;
        }

        public E getMin() {
            return this.min;
        }

        public E getMax() {
            return this.max;
        }

        public double normalize() {
            return Mth.clamp((double)((((Number)this.get()).doubleValue() - ((Number)this.min).doubleValue()) / (((Number)this.max).doubleValue() - ((Number)this.min).doubleValue())), (double)0.0, (double)1.0);
        }

        public abstract void fromNormalized(double var1);

        @Override
        public Supplier<AbstractWidget> getWidget(int width, int height) {
            return WidgetBuilder.getSliderWidget(this, width, height);
        }
    }
}

