/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.replaymod;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.settings.VRSettings;

public class ReplayModHelper {
    private static boolean INITIALIZED = false;
    private static boolean INIT_FAILED = false;
    private static Method RecordingEventSender_getRecordingEventHandler;
    private static Method RecordingEventHandler_onPacket;

    public static boolean isLoaded() {
        return Xloader.isModLoaded("replaymod") || Xloader.isModLoaded("reforgedplaymod");
    }

    public static void storePacket(Packet<?> packet) {
        if (ReplayModHelper.init()) {
            try {
                Object recorder = RecordingEventSender_getRecordingEventHandler.invoke((Object)Minecraft.getInstance().levelRenderer, new Object[0]);
                if (recorder != null) {
                    RecordingEventHandler_onPacket.invoke(recorder, packet);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Failed to store replaymod player data", (Throwable)e);
            }
        }
    }

    private static boolean init() {
        if (INITIALIZED) {
            return !INIT_FAILED;
        }
        try {
            Class<?> RecordingEventSender = Class.forName("com.replaymod.recording.handler.RecordingEventHandler$RecordingEventSender");
            RecordingEventSender_getRecordingEventHandler = RecordingEventSender.getMethod("getRecordingEventHandler", new Class[0]);
            Class<?> RecordingEventHandler = Class.forName("com.replaymod.recording.handler.RecordingEventHandler");
            RecordingEventHandler_onPacket = RecordingEventHandler.getMethod("onPacket", Packet.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            INIT_FAILED = true;
        }
        INITIALIZED = true;
        return !INIT_FAILED;
    }
}

