/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public NonNullList<ItemStack> offhand;

    @ModifyReturnValue(method={"getSelected"}, at={@At(value="RETURN")})
    private ItemStack vivecraft$dualHandingItem(ItemStack original) {
        return this.vivecraft$activeItem(original);
    }

    @WrapOperation(method={"getDestroySpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F")})
    private float vivecraft$dualHandingDestroySpeed(ItemStack instance, BlockState state, Operation<Float> original) {
        return ((Float)original.call(new Object[]{this.vivecraft$activeItem(instance), state})).floatValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Unique
    private ItemStack vivecraft$activeItem(ItemStack original) {
        VRBodyPart bodyPart;
        block7: {
            block6: {
                bodyPart = null;
                Player player = this.player;
                if (!(player instanceof ServerPlayer)) break block6;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue()) break block6;
                if (ServerVRPlayers.isVRPlayer(serverPlayer)) {
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    if (NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) {
                        bodyPart = vivePlayer.activeBodyPart;
                    }
                }
                break block7;
            }
            if (this.player.isLocalPlayer() && VRState.VR_RUNNING && ClientNetworking.SERVER_ALLOWS_DUAL_WIELDING) {
                bodyPart = ClientNetworking.getActiveBodyPart();
            }
        }
        if (bodyPart != null) {
            if (bodyPart == VRBodyPart.OFF_HAND) {
                return (ItemStack)this.offhand.get(0);
            }
            if (bodyPart != VRBodyPart.MAIN_HAND && bodyPart != VRBodyPart.HEAD) {
                return ItemStack.EMPTY;
            }
        }
        return original;
    }
}

