/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.gui;

import com.llamalad7.mixinextras.sugar.Local;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.api.client.data.OpenKeyboardContext;
import org.vivecraft.client.gui.settings.GuiKeyboardLayoutEditor;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;

@Mixin(value={EditBox.class})
public abstract class EditBoxVRMixin
extends AbstractWidget {
    @Shadow
    @Nullable
    private Component hint;
    @Shadow
    @Final
    private Font font;
    @Shadow
    private int textColorUneditable;
    @Shadow
    private String suggestion;

    @Shadow
    public abstract int getInnerWidth();

    public EditBoxVRMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Inject(method={"renderWidget"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I")})
    private void vivecraft$renderKeyboardHint(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci, @Local String content, @Local(ordinal=4) int xPos, @Local(ordinal=5) int yPos) {
        if (VRState.VR_RUNNING && !ClientDataHolderVR.getInstance().vrSettings.seated && !KeyboardHandler.SHOWING && content.isEmpty() && !(Minecraft.getInstance().screen instanceof GuiKeyboardLayoutEditor) && (this.hint == null && (this.suggestion == null || this.suggestion.isEmpty()) || this.isFocused())) {
            String cutString;
            String fullString = I18n.get((String)"vivecraft.message.openKeyboard", (Object[])new Object[0]);
            guiGraphics.drawString(this.font, (String)(fullString.equals(cutString = this.font.plainSubstrByWidth(fullString, this.getInnerWidth())) ? cutString : cutString + "..."), xPos, yPos, this.textColorUneditable);
        }
    }

    @Inject(method={"setFocused"}, at={@At(value="HEAD")})
    private void vivecraft$autoOpenKeyboard(boolean focused, CallbackInfo ci) {
        if (VRState.VR_RUNNING && focused && !(Minecraft.getInstance().screen instanceof InBedChatScreen)) {
            KeyboardHandler.showOverlay(Minecraft.getInstance().screen instanceof ChatScreen ? OpenKeyboardContext.FOCUS_CHAT : OpenKeyboardContext.FOCUS);
        }
    }

    @Inject(method={"onClick"}, at={@At(value="HEAD")})
    private void vivecraft$openKeyboard(CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            KeyboardHandler.showOverlay(OpenKeyboardContext.FORCE);
        }
    }
}

