/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.utils.external;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import org.vivecraft.client_vr.settings.VRSettings;

public class jkatvr
implements Library {
    public static final String KATVR_LIBRARY_NAME = "WalkerBase.dll";
    public static final NativeLibrary KATVR_NATIVE_LIB = NativeLibrary.getInstance((String)"WalkerBase.dll");
    private static final float MAG = 0.15f;
    private static final float B_MAG = 0.1f;
    private static final float MAX_POWER = 3000.0f;
    private static float YAW;
    private static float YAW_OFFSET;
    private static double POWER;
    private static int DIRECTION;
    private static int IS_MOVING;
    private static final IntByReference Y;
    private static final IntByReference M;
    private static final IntByReference IS;
    private static final DoubleByReference POW;
    private static final FloatByReference FL;

    public static native void Init(int var0);

    public static native int Launch();

    public static native boolean CheckForLaunch();

    public static native void Halt();

    public static native boolean GetWalkerData(int var0, IntByReference var1, DoubleByReference var2, IntByReference var3, IntByReference var4, FloatByReference var5);

    public static void query() {
        try {
            boolean flag = jkatvr.GetWalkerData(0, Y, POW, M, IS, FL);
            YAW = Y.getValue();
            POWER = POW.getValue();
            DIRECTION = -M.getValue();
            IS_MOVING = IS.getValue();
            YAW = YAW / 1024.0f * 360.0f;
        }
        catch (Exception exception) {
            VRSettings.LOGGER.error("Vivecraft: KATVR Error:", (Throwable)exception);
        }
    }

    public static float getYaw() {
        return YAW - YAW_OFFSET;
    }

    public static boolean isMoving() {
        return IS_MOVING == 1;
    }

    public static void resetYaw(float offsetDegrees) {
        YAW_OFFSET = offsetDegrees + YAW;
    }

    public static float walkDirection() {
        return DIRECTION;
    }

    public static float getSpeed() {
        return (float)(POWER / 3000.0 * (double)(jkatvr.walkDirection() == 1.0f ? 0.15f : 0.1f));
    }

    static {
        Y = new IntByReference();
        M = new IntByReference();
        IS = new IntByReference();
        POW = new DoubleByReference();
        FL = new FloatByReference();
        Native.register(jkatvr.class, (NativeLibrary)KATVR_NATIVE_LIB);
    }
}

