/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.provider.ControllerType;

public class VRArmRenderer
extends PlayerRenderer {
    public VRArmRenderer(EntityRendererProvider.Context context, boolean useSlimModel) {
        super(context, useSlimModel);
    }

    public void renderRightHand(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player) {
        this.renderHand(ControllerType.RIGHT, poseStack, buffer, combinedLight, player, ((PlayerModel)this.model).rightArm, ((PlayerModel)this.model).rightSleeve);
    }

    public void renderLeftHand(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player) {
        this.renderHand(ControllerType.LEFT, poseStack, buffer, combinedLight, player, ((PlayerModel)this.model).leftArm, ((PlayerModel)this.model).leftSleeve);
    }

    private void renderHand(ControllerType side, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, ModelPart rendererArm, ModelPart rendererArmwear) {
        PlayerModel playerModel = (PlayerModel)this.getModel();
        this.setModelProperties(player);
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        rendererArm.setPos(side == ControllerType.LEFT ? 5.0f : -5.0f, 2.0f, 0.0f);
        rendererArm.setRotation(0.0f, 0.0f, 0.0f);
        rendererArm.zScale = 1.0f;
        rendererArm.yScale = 1.0f;
        rendererArm.xScale = 1.0f;
        rendererArmwear.copyFrom(rendererArm);
        float alpha = SwingTracker.getItemFade((LocalPlayer)player, ItemStack.EMPTY);
        ResourceLocation playerSkin = this.getTextureLocation(player);
        rendererArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)playerSkin)), combinedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f));
        rendererArmwear.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)playerSkin)), combinedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f));
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

