/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.render.HMDLayer;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.render.armor.VRArmorLayer;
import org.vivecraft.client.render.armor.VRArmorModel_WithArms;
import org.vivecraft.client.render.armor.VRArmorModel_WithArmsLegs;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerRenderer
extends PlayerRenderer {
    private static final LayerDefinition VR_LAYER_DEF = LayerDefinition.create((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
    private static final LayerDefinition VR_LAYER_DEF_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
    private static LayerDefinition VR_LAYER_DEF_ARMS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_SLIM;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS_SLIM;

    public static void createLayers() {
        VR_LAYER_DEF_ARMS = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.NONE, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS_SLIM = LayerDefinition.create((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.NONE, true), (int)64, (int)64);
    }

    public VRPlayerRenderer(EntityRendererProvider.Context context, boolean slim, ModelType type) {
        super(context, slim);
        this.model = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new VRPlayerModel(slim ? VR_LAYER_DEF_SLIM.bakeRoot() : VR_LAYER_DEF.bakeRoot(), slim);
            case 1 -> new VRPlayerModel_WithArms(slim ? VR_LAYER_DEF_ARMS_SLIM.bakeRoot() : VR_LAYER_DEF_ARMS.bakeRoot(), slim);
            case 2 -> new VRPlayerModel_WithArmsLegs(slim ? VR_LAYER_DEF_ARMS_LEGS_SLIM.bakeRoot() : VR_LAYER_DEF_ARMS_LEGS.bakeRoot(), slim);
        };
        this.addLayer(new HMDLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
        VRArmorLayer.createLayers();
        if (type != ModelType.VANILLA) {
            this.layers.stream().filter(layer -> layer.getClass() == HumanoidArmorLayer.class).findFirst().ifPresent(this.layers::remove);
            if (type == ModelType.SPLIT_ARMS) {
                this.addLayer((RenderLayer)new VRArmorLayer(this, new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_INNER.bakeRoot()), new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_OUTER.bakeRoot()), context.getModelManager()));
            } else {
                this.addLayer((RenderLayer)new VRArmorLayer(this, new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_INNER.bakeRoot()), new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_OUTER.bakeRoot()), context.getModelManager()));
            }
        }
    }

    public boolean hasLayerType(RenderLayer<?, ?> renderLayer) {
        return this.layers.stream().anyMatch(layer -> {
            if (renderLayer.getClass() == HumanoidArmorLayer.class) {
                return layer.getClass() == renderLayer.getClass() || layer.getClass() == VRArmorLayer.class;
            }
            return layer.getClass() == renderLayer.getClass();
        });
    }

    public void render(AbstractClientPlayer player, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.getUUID());
        if (rotInfo != null) {
            float scale = rotInfo.heightScale;
            if (VRState.VR_RUNNING && player == Minecraft.getInstance().player || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale) {
                scale *= rotInfo.worldScale / ScaleHelper.getEntityEyeHeightScale((LivingEntity)player, partialTick);
            }
            if (player.isAutoSpinAttack()) {
                float offset = player.getViewXRot(partialTick) / 90.0f * 0.2f;
                poseStack.translate(0.0f, rotInfo.headPos.y() + offset, 0.0f);
            }
            poseStack.scale(scale, scale, scale);
        }
        super.render(player, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    public Vec3 getRenderOffset(AbstractClientPlayer player, float partialTick) {
        if (VREffectsHelper.isFirstPersonPlayer((Entity)player)) {
            return player.isVisuallySwimming() ? new Vec3(0.0, (double)(-0.125f * ClientDataHolderVR.getInstance().vrPlayer.worldScale), 0.0) : Vec3.ZERO;
        }
        return player.isVisuallySwimming() ? new Vec3(0.0, -0.125, 0.0) : Vec3.ZERO;
    }

    public void setModelProperties(AbstractClientPlayer player) {
        super.setModelProperties(player);
        ((PlayerModel)this.getModel()).crouching = ((PlayerModel)this.getModel()).crouching & !player.isVisuallySwimming();
        if (VREffectsHelper.isFirstPersonPlayer((Entity)player)) {
            if (ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA && ClientDataHolderVR.getInstance().cameraTracker.isQuickMode() && ClientDataHolderVR.getInstance().grabScreenShot) {
                this.hideHand(HumanoidArm.LEFT, true);
                this.hideHand(HumanoidArm.RIGHT, true);
            }
            if (VREffectsHelper.isFirstPersonEntityPass()) {
                ((PlayerModel)this.getModel()).head.visible = false;
                ((PlayerModel)this.getModel()).hat.visible = false;
                if (ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE) {
                    this.hideHand(HumanoidArm.LEFT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                    this.hideHand(HumanoidArm.RIGHT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                } else {
                    boolean leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
                    if (ClientDataHolderVR.getInstance().menuHandOff) {
                        this.hideHand(leftHanded ? HumanoidArm.RIGHT : HumanoidArm.LEFT, false);
                    }
                    if (ClientDataHolderVR.getInstance().menuHandMain) {
                        this.hideHand(leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT, false);
                    }
                }
            }
        }
    }

    private void hideHand(HumanoidArm arm, boolean completeArm) {
        EntityModel entityModel = this.getModel();
        if (entityModel instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)entityModel;
            if (arm == HumanoidArm.LEFT) {
                vrModel.hideLeftArm(completeArm);
            } else {
                vrModel.hideRightArm(completeArm);
            }
        } else if (arm == HumanoidArm.LEFT) {
            ((PlayerModel)this.getModel()).leftArm.visible = false;
            ((PlayerModel)this.getModel()).leftSleeve.visible = false;
        } else {
            ((PlayerModel)this.getModel()).rightArm.visible = false;
            ((PlayerModel)this.getModel()).rightSleeve.visible = false;
        }
    }

    protected void setupRotations(AbstractClientPlayer player, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        if (ClientDataHolderVR.getInstance().currentPass != RenderPass.GUI && ClientVRPlayers.getInstance().isVRPlayer((Entity)player)) {
            if (player == Minecraft.getInstance().player) {
                rotationYaw = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYaw();
            } else {
                ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.getUUID());
                rotationYaw = 57.295776f * rotInfo.getBodyYawRad();
            }
        }
        super.setupRotations(player, poseStack, ageInTicks, rotationYaw, partialTick, scale);
    }

    static {
        VRPlayerRenderer.createLayers();
    }

    public static enum ModelType {
        VANILLA,
        SPLIT_ARMS,
        SPLIT_ARMS_LEGS;

    }
}

