/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.network;

import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import org.vivecraft.Xplat;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.AimDirOverridePayloadC2S;
import org.vivecraft.common.network.packet.c2s.AimOverrideResetPayloadC2S;
import org.vivecraft.common.network.packet.c2s.AimPosOverridePayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.common.network.packet.s2c.AttackWhileBlockingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DamageDirectionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.HapticPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ServerVrChangesS2CPacket;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UnknownPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.ReplayHelper;

public class ClientNetworking {
    public static boolean DISPLAYED_CHAT_MESSAGE = false;
    public static boolean DISPLAYED_CHAT_WARNING = false;
    public static boolean DISPLAYED_HEAD_AIM_WARNING = false;
    public static boolean DISPLAYED_VR_CHANGES = false;
    public static boolean ABLE_TO_DISPLAY_CHAT_WARNINGS = false;
    public static boolean SHOW_NO_TELEPORT_MESSAGE = false;
    public static int CHAT_WARNING_TIMER = -1;
    public static boolean TELEPORT_WARNING = false;
    public static boolean VR_SWITCHING_WARNING = false;
    public static boolean HEAD_AIM_WARNING = false;
    public static boolean REQUESTED_DAMAGE_DIRECTION = false;
    public static boolean SERVER_HAS_VIVECRAFT = false;
    public static boolean SERVER_WANTS_DATA = false;
    public static boolean SERVER_SUPPORTS_DIRECT_TELEPORT = false;
    public static boolean SERVER_ALLOWS_DIRECT_TELEPORT = true;
    public static boolean SERVER_ALLOWS_CLIMBEY = false;
    public static boolean SERVER_ALLOWS_CRAWLING = false;
    public static boolean SERVER_ALLOWS_VR_SWITCHING = false;
    public static boolean SERVER_ALLOWS_DUAL_WIELDING = false;
    public static boolean SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING = false;
    public static Map<String, String> SERVER_VR_CHANGES_LIST;
    public static NetworkVersion USED_NETWORK_VERSION;
    private static float WORLDSCALE_LAST;
    private static float HEIGHT_LAST;
    public static Vector3fc AIM_DIR_OVERRIDE;
    public static Vec3 AIM_POS_OVERRIDE;
    private static VRBodyPart LAST_SENT_BODY_PART;
    public static VRBodyPart BODY_PART_CLIENT_OVERRIDE;
    public static boolean IS_LAST_BODY_PART_AIM;
    public static boolean NEEDS_RESET;

    public static void resetServerSettings() {
        WORLDSCALE_LAST = 0.0f;
        HEIGHT_LAST = 0.0f;
        SERVER_HAS_VIVECRAFT = false;
        SERVER_WANTS_DATA = false;
        SERVER_SUPPORTS_DIRECT_TELEPORT = false;
        SERVER_ALLOWS_DIRECT_TELEPORT = true;
        SERVER_ALLOWS_CLIMBEY = false;
        SERVER_ALLOWS_CRAWLING = false;
        SERVER_ALLOWS_VR_SWITCHING = false;
        SERVER_ALLOWS_DUAL_WIELDING = false;
        SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING = false;
        USED_NETWORK_VERSION = NetworkVersion.LEGACY;
        LAST_SENT_BODY_PART = VRBodyPart.MAIN_HAND;
        BODY_PART_CLIENT_OVERRIDE = null;
        IS_LAST_BODY_PART_AIM = false;
        ClientVRPlayers.clear();
        VRServerPerms.INSTANCE.setTeleportSupported(false);
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.setTeleportOverride(false);
        }
        ClientDataHolderVR.getInstance().vrSettings.overrides.resetAll();
    }

    public static void resetOnceServerSettings() {
        DISPLAYED_CHAT_MESSAGE = false;
        DISPLAYED_CHAT_WARNING = false;
        DISPLAYED_HEAD_AIM_WARNING = false;
        DISPLAYED_VR_CHANGES = false;
        SERVER_VR_CHANGES_LIST = null;
        SHOW_NO_TELEPORT_MESSAGE = false;
    }

    public static void sendVersionInfo() {
        if (!ClientDataHolderVR.getInstance().completelyDisabled && Xplat.serverAcceptsPacket(Minecraft.getInstance().getConnection(), CommonNetworkHelper.CHANNEL)) {
            Minecraft.getInstance().getConnection().send(ClientNetworking.createServerPacket(new VersionPayloadC2S(CommonDataHolder.getInstance().versionIdentifier, VRState.VR_RUNNING, CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL, CommonNetworkHelper.MIN_SUPPORTED_NETWORK_PROTOCOL)));
        }
    }

    public static void sendVRPlayerPositions(VRPlayer vrPlayer) {
        float userHeight;
        if (Minecraft.getInstance().getConnection() == null || Minecraft.getInstance().getCameraEntity() != Minecraft.getInstance().player) {
            return;
        }
        if (ReplayHelper.isLoaded()) {
            ReplayHelper.storePlayerData(vrPlayer);
        }
        if (!SERVER_WANTS_DATA) {
            return;
        }
        float worldScale = ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_post.worldScale;
        if (worldScale != WORLDSCALE_LAST) {
            ClientNetworking.sendServerPacket(new WorldScalePayloadC2S(worldScale));
            WORLDSCALE_LAST = worldScale;
        }
        if ((userHeight = AutoCalibration.getPlayerHeight()) != HEIGHT_LAST) {
            ClientNetworking.sendServerPacket(new HeightPayloadC2S(userHeight / 1.52f));
            HEIGHT_LAST = userHeight;
        }
        VrPlayerState vrPlayerState = VrPlayerState.create(vrPlayer);
        if (USED_NETWORK_VERSION != NetworkVersion.LEGACY) {
            ClientNetworking.sendServerPacket(new VRPlayerStatePayloadC2S(vrPlayerState));
        } else {
            ClientNetworking.sendLegacyPackets(vrPlayerState);
        }
        if (ClientDataHolderVR.getInstance().vrSettings.mainPlayerDataSource != VRSettings.DataSource.SERVER) {
            ClientVRPlayers.getInstance().update(Minecraft.getInstance().player.getGameProfile().getId(), vrPlayerState, worldScale, userHeight / 1.52f, true);
        }
    }

    public static void sendServerPacket(VivecraftPayloadC2S payload) {
        if (Minecraft.getInstance().getConnection() != null && SERVER_HAS_VIVECRAFT) {
            Minecraft.getInstance().getConnection().send(ClientNetworking.createServerPacket(payload));
        }
    }

    public static Packet<?> createServerPacket(VivecraftPayloadC2S payload) {
        return Xplat.getC2SPacket(payload);
    }

    public static void sendLegacyPackets(VrPlayerState vrPlayerState) {
        ClientNetworking.sendServerPacket(new LegacyController0DataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.reverseHands, vrPlayerState.mainHand()));
        ClientNetworking.sendServerPacket(new LegacyController1DataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.reverseHands, vrPlayerState.offHand()));
        ClientNetworking.sendServerPacket(new LegacyHeadDataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.seated, vrPlayerState.hmd()));
    }

    public static boolean isThirdPersonItems() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS).getBoolean();
    }

    public static boolean isThirdPersonItemsCustom() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS_CUSTOM).getBoolean();
    }

    public static boolean isLimitedSurvivalTeleport() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.LIMIT_TELEPORT).getBoolean();
    }

    public static boolean supportsReversedBow() {
        return NetworkVersion.DUAL_WIELDING.accepts(USED_NETWORK_VERSION) || !SERVER_HAS_VIVECRAFT;
    }

    public static int getTeleportUpLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_UP_LIMIT).getInt();
    }

    public static int getTeleportDownLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_DOWN_LIMIT).getInt();
    }

    public static int getTeleportHorizLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_HORIZ_LIMIT).getInt();
    }

    public static void resetAim(int ticks) {
        if (!SERVER_WANTS_DATA) {
            ClientNetworking.restoreLook();
        } else if (NetworkVersion.AIM_OVERRIDE.accepts(USED_NETWORK_VERSION)) {
            ClientNetworking.sendServerPacket(new AimOverrideResetPayloadC2S(ticks));
            if (ticks == 0) {
                AIM_DIR_OVERRIDE = null;
                AIM_POS_OVERRIDE = null;
            }
        }
    }

    public static void overrideAimDir(Vector3fc dirOverride) {
        if (!SERVER_WANTS_DATA) {
            ClientNetworking.overrideLook((Player)Minecraft.getInstance().player, () -> dirOverride);
        } else if (NetworkVersion.AIM_OVERRIDE.accepts(USED_NETWORK_VERSION)) {
            ClientNetworking.sendServerPacket(new AimDirOverridePayloadC2S(dirOverride));
            AIM_DIR_OVERRIDE = dirOverride;
        }
    }

    public static Vector3fc getActiveAimDir() {
        if (AIM_DIR_OVERRIDE != null) {
            return AIM_DIR_OVERRIDE;
        }
        VRBodyPart bp = IS_LAST_BODY_PART_AIM ? ClientNetworking.getActiveBodyPart() : (ClientDataHolderVR.getInstance().vrSettings.aimDevice == VRSettings.AimDevice.HMD ? VRBodyPart.HEAD : VRBodyPart.MAIN_HAND);
        return ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyPart(bp).getDirection();
    }

    public static void overrideAimPos(Vec3 posOverride) {
        if (SERVER_WANTS_DATA && NetworkVersion.AIM_OVERRIDE.accepts(USED_NETWORK_VERSION)) {
            ClientNetworking.sendServerPacket(new AimPosOverridePayloadC2S((Vector3fc)MathUtils.subtractToVector3f(posOverride, Minecraft.getInstance().player.position())));
            AIM_POS_OVERRIDE = posOverride;
        }
    }

    @Nullable
    public static Vec3 getActiveAimPos() {
        if (!SERVER_WANTS_DATA) {
            return null;
        }
        if (AIM_POS_OVERRIDE != null) {
            return AIM_POS_OVERRIDE;
        }
        VRBodyPart bp = IS_LAST_BODY_PART_AIM ? ClientNetworking.getActiveBodyPart() : (ClientDataHolderVR.getInstance().vrSettings.aimDevice == VRSettings.AimDevice.HMD ? VRBodyPart.HEAD : VRBodyPart.MAIN_HAND);
        return ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyPart(bp).getPosition();
    }

    public static void resetActiveBodyPart() {
        ClientNetworking.sendActiveBodyPart(VRBodyPart.MAIN_HAND, false);
    }

    public static void sendActiveHand(InteractionHand hand, boolean useForAim) {
        if (!useForAim && ClientDataHolderVR.getInstance().vrSettings.aimDevice == VRSettings.AimDevice.HMD) {
            ClientNetworking.sendActiveBodyPart(VRBodyPart.HEAD, true);
        } else {
            ClientNetworking.sendActiveBodyPart(VRBodyPart.fromInteractionHand(hand), useForAim);
        }
    }

    public static void sendActiveBodyPart(VRBodyPart bodyPart, boolean useForAim) {
        if (SERVER_WANTS_DATA) {
            if (!NetworkVersion.HEAD_AIM.accepts(USED_NETWORK_VERSION) && bodyPart == VRBodyPart.HEAD || !NetworkVersion.DUAL_WIELDING.accepts(USED_NETWORK_VERSION) && !bodyPart.availableInMode(FBTMode.ARMS_ONLY)) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            if (bodyPart != LAST_SENT_BODY_PART) {
                ClientNetworking.sendServerPacket(new ActiveBodyPartPayloadC2S(bodyPart, useForAim));
            }
        }
        LAST_SENT_BODY_PART = bodyPart;
        IS_LAST_BODY_PART_AIM = useForAim;
    }

    public static VRBodyPart getActiveBodyPart() {
        return BODY_PART_CLIENT_OVERRIDE != null ? BODY_PART_CLIENT_OVERRIDE : LAST_SENT_BODY_PART;
    }

    public static void overridePose(LocalPlayer player) {
        if (ClientDataHolderVR.getInstance().crawlTracker.crawling) {
            player.setPose(Pose.SWIMMING);
        }
    }

    public static void overrideLook(Player player, Supplier<Vector3fc> viewSupplier) {
        if (SERVER_WANTS_DATA) {
            return;
        }
        Vector3fc view = viewSupplier.get();
        float pitch = (float)Math.toDegrees(Math.asin(-view.y() / view.length()));
        float yaw = (float)Math.toDegrees(Math.atan2(-view.x(), view.z()));
        ((LocalPlayer)player).connection.send((Packet)new ServerboundMovePlayerPacket.Rot(yaw, pitch, player.onGround()));
        AIM_DIR_OVERRIDE = view;
    }

    public static void restoreLook() {
        AIM_DIR_OVERRIDE = null;
        AIM_POS_OVERRIDE = null;
    }

    public static void handlePacket(VivecraftPayloadS2C s2cPayload) {
        if (s2cPayload instanceof UnknownPayloadS2C) {
            return;
        }
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        switch (s2cPayload.payloadId()) {
            case VERSION: {
                SERVER_HAS_VIVECRAFT = true;
                VRServerPerms.INSTANCE.setTeleportSupported(true);
                TELEPORT_WARNING = false;
                VR_SWITCHING_WARNING = true;
                HEAD_AIM_WARNING = true;
                if (!DISPLAYED_CHAT_MESSAGE && dataholder.vrSettings.showServerPluginMessage.getAsBoolean()) {
                    DISPLAYED_CHAT_MESSAGE = true;
                    ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.serverplugin", (Object[])new Object[]{((VersionPayloadS2C)s2cPayload).version()}));
                }
                if (!VRState.VR_INITIALIZED || dataholder.vrSettings.manualCalibration != -1.0f || dataholder.vrSettings.seated) break;
                ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.calibrateheight"));
                break;
            }
            case IS_VR_ACTIVE: {
                VRActivePayloadS2C packet = (VRActivePayloadS2C)s2cPayload;
                if (packet.vr()) break;
                ClientVRPlayers.getInstance().disableVR(packet.playerID());
                break;
            }
            case REQUESTDATA: {
                SERVER_WANTS_DATA = true;
                break;
            }
            case CLIMBING: {
                ClimbingPayloadS2C packet = (ClimbingPayloadS2C)s2cPayload;
                SERVER_ALLOWS_CLIMBEY = packet.allowed();
                dataholder.climbTracker.serverBlockmode = packet.blockmode();
                dataholder.climbTracker.blocklist.clear();
                if (packet.blocks() == null) break;
                for (String blockId : packet.blocks()) {
                    Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockId));
                    if (block == Blocks.AIR) continue;
                    dataholder.climbTracker.blocklist.add(block);
                }
                break;
            }
            case TELEPORT: {
                SERVER_SUPPORTS_DIRECT_TELEPORT = true;
                SERVER_ALLOWS_DIRECT_TELEPORT = ((TeleportPayloadS2C)s2cPayload).allowed();
                if (SERVER_ALLOWS_DIRECT_TELEPORT || !VRState.VR_INITIALIZED) break;
                dataholder.vrPlayer.setTeleportOverride(false);
                SHOW_NO_TELEPORT_MESSAGE = true;
                break;
            }
            case UBERPACKET: {
                UberPacketPayloadS2C packet = (UberPacketPayloadS2C)s2cPayload;
                ClientVRPlayers.getInstance().update(packet.playerID(), packet.state(), packet.worldScale(), packet.heightScale());
                break;
            }
            case SETTING_OVERRIDE: {
                SettingOverridePayloadS2C overridePayload = (SettingOverridePayloadS2C)s2cPayload;
                for (Map.Entry<String, String> override : overridePayload.overrides().entrySet()) {
                    String[] split = override.getKey().split("\\.", 2);
                    if (!dataholder.vrSettings.overrides.hasSetting(split[0])) continue;
                    VRSettings.ServerOverrides.Setting setting = dataholder.vrSettings.overrides.getSetting(split[0]);
                    if (overridePayload.clear()) {
                        setting.resetValue();
                        if (setting.isFloat()) {
                            setting.resetValueMin();
                            setting.resetValueMax();
                        }
                        VRSettings.LOGGER.info("Vivecraft: Server setting override cleared: {}", (Object)override.getKey());
                        continue;
                    }
                    try {
                        if (split.length > 1) {
                            switch (split[1]) {
                                case "min": {
                                    setting.setValueMin(Float.parseFloat(override.getValue()));
                                    break;
                                }
                                case "max": {
                                    setting.setValueMax(Float.parseFloat(override.getValue()));
                                }
                            }
                        } else {
                            Object origValue = setting.getOriginalValue();
                            if (origValue instanceof Boolean) {
                                setting.setValue(override.getValue().equals("true"));
                            } else if (origValue instanceof Integer || origValue instanceof Byte || origValue instanceof Short) {
                                setting.setValue(Integer.parseInt(override.getValue()));
                            } else if (origValue instanceof Float || origValue instanceof Double) {
                                setting.setValue(Float.valueOf(Float.parseFloat(override.getValue())));
                            } else {
                                setting.setValue(override.getValue());
                            }
                        }
                        VRSettings.LOGGER.info("Vivecraft: Server setting override: {}={}", (Object)override.getKey(), (Object)override.getValue());
                    }
                    catch (Exception exception) {
                        VRSettings.LOGGER.error("Vivecraft: error parsing server setting override: ", (Throwable)exception);
                    }
                }
                if (Minecraft.getInstance().screen == null) break;
                Minecraft.getInstance().screen.init(Minecraft.getInstance(), Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
                break;
            }
            case CRAWL: {
                SERVER_ALLOWS_CRAWLING = ((CrawlPayloadS2C)s2cPayload).allowed();
                break;
            }
            case NETWORK_VERSION: {
                USED_NETWORK_VERSION = ((NetworkVersionPayloadS2C)s2cPayload).version();
                if (!NetworkVersion.HEAD_AIM.accepts(USED_NETWORK_VERSION)) break;
                HEAD_AIM_WARNING = false;
                break;
            }
            case VR_SWITCHING: {
                SERVER_ALLOWS_VR_SWITCHING = ((VRSwitchingPayloadS2C)s2cPayload).allowed();
                if (!SERVER_ALLOWS_VR_SWITCHING) {
                    ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.novrhotswitching"));
                }
                VR_SWITCHING_WARNING = false;
                break;
            }
            case DUAL_WIELDING: {
                SERVER_ALLOWS_DUAL_WIELDING = ((DualWieldingPayloadS2C)s2cPayload).allowed();
                break;
            }
            case SERVER_VR_CHANGES: {
                SERVER_VR_CHANGES_LIST = ((ServerVrChangesS2CPacket)s2cPayload).changes();
                break;
            }
            case HAPTIC: {
                if (!VRState.VR_RUNNING) break;
                HapticPayloadS2C haptic = (HapticPayloadS2C)s2cPayload;
                ClientDataHolderVR.getInstance().vr.triggerHapticPulse(haptic.bodyPart(), haptic.duration(), haptic.frequency(), haptic.amplitude(), haptic.delay());
                break;
            }
            case DAMAGE_DIRECTION: {
                dataholder.hapticTracker.setLastHitDirection(((DamageDirectionPayloadS2C)s2cPayload).damageDir());
                break;
            }
            case ATTACK_WHILE_BLOCKING: {
                SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING = ((AttackWhileBlockingPayloadS2C)s2cPayload).allowed();
            }
        }
    }

    static {
        USED_NETWORK_VERSION = NetworkVersion.LEGACY;
        WORLDSCALE_LAST = 0.0f;
        HEIGHT_LAST = 0.0f;
        AIM_DIR_OVERRIDE = null;
        AIM_POS_OVERRIDE = null;
        LAST_SENT_BODY_PART = VRBodyPart.MAIN_HAND;
        BODY_PART_CLIENT_OVERRIDE = null;
        IS_LAST_BODY_PART_AIM = false;
        NEEDS_RESET = true;
    }
}

