/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.google.common.base.Objects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStatePoseProvider;
import com.vicmatskiv.pointblank.client.controller.GlowAnimationController;
import com.vicmatskiv.pointblank.client.controller.RotationAnimationController;
import com.vicmatskiv.pointblank.client.effect.EffectRenderContext;
import com.vicmatskiv.pointblank.client.effect.MuzzleFlashEffect;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.model.GunGeoModel;
import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderApprover;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderPassGeoRenderer;
import com.vicmatskiv.pointblank.client.render.RenderPassProvider;
import com.vicmatskiv.pointblank.client.render.RenderTypeKey;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.client.render.layer.AttachmentLayer;
import com.vicmatskiv.pointblank.client.render.layer.GlowingItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.GunHandsItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.MuzzleFlashItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.PipItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.ReticleItemLayer;
import com.vicmatskiv.pointblank.client.render.layer.SeeThroughItemLayer;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import com.vicmatskiv.pointblank.feature.ActiveMuzzleFeature;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.feature.PartVisibilityFeature;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.feature.SkinFeature;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.registry.EffectRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class GunItemRenderer
extends GeoItemRenderer<GunItem>
implements RenderPassGeoRenderer<GunItem>,
RenderApprover {
    public static final String BONE_SCOPE = "scope";
    public static final String BONE_RETICLE = "reticle";
    public static final String BONE_SCOPE_PIP = "scopepip";
    public static final String BONE_RIGHTARM = "rightarm";
    public static final String BONE_LEFTARM = "leftarm";
    public static final String BONE_MUZZLE = "muzzle";
    public static final String BONE_MUZZLE2 = "muzzle2";
    public static final String BONE_MUZZLE3 = "muzzle3";
    public static final String BONE_MUZZLEFLASH = "muzzleflash";
    public static final String BONE_MUZZLEFLASH2 = "muzzleflash2";
    public static final String BONE_MUZZLEFLASH3 = "muzzleflash3";
    public static final String BONE_CAMERA = "_camera_";
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET = Mth.cos((float)0.08726646f);
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED = Mth.cos((float)((float)Math.PI / 90));
    private GunClientState gunClientState;
    private boolean hasScopeOverlay;
    private ItemTransforms transforms;
    private ResourceLocation leftHandModelResource = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"geo/item/left_arm.geo.json");
    private ResourceLocation rightHandModelResource = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"geo/item/right_arm.geo.json");
    private ResourceLocation reticleModelResource = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"geo/item/reticle.geo.json");
    private boolean useCustomGlowingTexture;
    private Set<Direction> glowDirections;
    private Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier;
    private float glowingProgress;

    public GunItemRenderer(ResourceLocation modelResource, List<ResourceLocation> fallbackAnimations, List<GlowAnimationController.Builder> glowEffectBuilders) {
        super((GeoModel)new GunGeoModel(modelResource, fallbackAnimations));
        this.addRenderLayer(new AttachmentLayer<GunItem>(this));
        for (GlowAnimationController.Builder glowEffectBuilder : glowEffectBuilders) {
            ResourceLocation glowTexture = glowEffectBuilder.getTexture();
            if (glowTexture == null) {
                glowTexture = this.getGeoModel().getTextureResource((GeoAnimatable)((GunItem)this.animatable));
            }
            this.addRenderLayer(new GlowingItemLayer(this, glowEffectBuilder.getEffectId(), glowTexture));
        }
        this.addRenderLayer(new GunHandsItemLayer<GunItem>(this));
        this.addRenderLayer(new PipItemLayer(this));
        this.addRenderLayer(new SeeThroughItemLayer(this));
        this.addRenderLayer(new ReticleItemLayer(this));
        this.addRenderLayer(new MuzzleFlashItemLayer(this));
    }

    public ResourceLocation getTextureLocation(GunItem animatable) {
        ResourceLocation texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            ItemStack itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((Item)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<GunItem> getRenderer() {
        return this;
    }

    public GunClientState getGunClientState() {
        return this.gunClientState;
    }

    private BakedGeoModel getLeftHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.leftHandModelResource);
    }

    private BakedGeoModel getRightHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.rightHandModelResource);
    }

    private BakedGeoModel getReticleModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.reticleModelResource);
    }

    private Player getPlayer(ItemDisplayContext itemDisplayContext) {
        if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || itemDisplayContext == ItemDisplayContext.GROUND) {
            return ClientUtil.getClientPlayer();
        }
        LivingEntity renderedEntity = ClientEventHandler.getCurrentEntityLiving();
        if (renderedEntity instanceof Player) {
            return (Player)renderedEntity;
        }
        return null;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSourceOrig, int packedLight, int packedOverlay) {
        if (IrisCompat.getInstance().isRenderingShadows()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof AttachmentManagerScreen && itemDisplayContext != ItemDisplayContext.GROUND) {
            return;
        }
        Player player = this.getPlayer(itemDisplayContext);
        if (player == null) {
            return;
        }
        MultiBufferSource wrappedBufferSource = RenderTypeProvider.getInstance().wrapBufferSource(bufferSourceOrig);
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(stack, itemDisplayContext);){
            this.renderPass(() -> {
                boolean isOffhand;
                int slotIndex;
                GunClientState state;
                PipFeature pipFeature = PipFeature.getSelected(HierarchicalRenderContext.getRootItemStack());
                if (pipFeature != null) {
                    hrc.setAttribute("isPipFallbackEnabled", pipFeature.isFallbackRequired());
                }
                if ((state = GunClientState.getState(player, stack, slotIndex = player.getInventory().findSlotMatchingItem(stack), isOffhand = player != null && player.getOffhandItem() == stack)) != null) {
                    GunStatePoseProvider.getInstance().clear(state.getId());
                }
                boolean isFirstPerson = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                poseStack.pushPose();
                GunItem gunItem = (GunItem)stack.getItem();
                this.hasScopeOverlay = gunItem.getScopeOverlay() != null;
                GeoModel geoModel = this.getGeoModel();
                if (isFirstPerson) {
                    GeoBone scopeBone = geoModel.getBone(BONE_SCOPE).orElse(null);
                    this.initTransforms(player, stack, itemDisplayContext);
                    this.adjustFirstPersonPose(stack, gunItem, state, poseStack, (GeoModel<GunItem>)geoModel, scopeBone);
                }
                this.gunClientState = state;
                super.renderByItem(stack, itemDisplayContext, poseStack, wrappedBufferSource, packedLight, packedOverlay);
                poseStack.popPose();
            });
        }
    }

    @Override
    public void renderPass(Runnable runnablePass) {
        RenderPass.push(this.getRenderPass());
        try {
            runnablePass.run();
        }
        finally {
            RenderPass.pop();
        }
    }

    private void adjustFirstPersonPose(ItemStack itemStack, GunItem gunItem, GunClientState state, PoseStack poseStack, GeoModel<GunItem> geoModel, GeoBone scopeBone) {
        if (this.transforms == null) {
            return;
        }
        ItemTransform fprt = this.transforms.firstPersonRightHand;
        if (fprt == null) {
            return;
        }
        float aimingProgress = 0.0f;
        if (state != null) {
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)state.getAnimationController("aiming");
            aimingProgress = (float)aimingController.getValue();
        }
        float v = 1.0f - aimingProgress;
        float rescale = gunItem.getModelScale();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(new Quaternionf().rotationXYZ(-fprt.rotation.x * ((float)Math.PI / 180), -fprt.rotation.y * ((float)Math.PI / 180), -fprt.rotation.z * ((float)Math.PI / 180)));
        poseStack.translate(-fprt.translation.x, -fprt.translation.y, -fprt.translation.z);
        poseStack.translate(fprt.translation.x * rescale, fprt.translation.y * rescale, fprt.translation.z * rescale);
        poseStack.mulPose(new Quaternionf().rotationXYZ(v * fprt.rotation.x * ((float)Math.PI / 180), v * fprt.rotation.y * ((float)Math.PI / 180), v * fprt.rotation.z * ((float)Math.PI / 180)));
        poseStack.translate(aimingProgress * -fprt.translation.x * rescale, aimingProgress * -fprt.translation.y * rescale, aimingProgress * -fprt.translation.z * rescale);
        AimingFeature.applyAimingPosition(itemStack, poseStack, rescale, aimingProgress);
        poseStack.scale(rescale, rescale, rescale);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        float curve = Mth.sin((float)((float)Math.PI * aimingProgress));
        double aimingCurveX = gunItem.getAimingCurveX();
        double aimingCurveY = gunItem.getAimingCurveY();
        double aimingCurveZ = gunItem.getAimingCurveZ();
        double aimingCurvePitch = gunItem.getAimingCurvePitch();
        double aimingCurveYaw = gunItem.getAimingCurveYaw();
        double aimingCurveRoll = gunItem.getAimingCurveRoll();
        poseStack.translate((double)curve * aimingCurveX, (double)curve * aimingCurveY, (double)curve * aimingCurveZ);
        poseStack.mulPose(new Quaternionf((double)curve * aimingCurvePitch * 0.01745329238474369, (double)curve * aimingCurveYaw * 0.01745329238474369, (double)curve * aimingCurveRoll * 0.01745329238474369, 1.0));
        poseStack.translate(0.48f * v, -1.12f * v, -0.72f * v);
        poseStack.translate(-0.006f, 0.6f, 0.0f);
    }

    private void initTransforms(Player player, ItemStack stack, ItemDisplayContext itemDisplayContext) {
        if (this.transforms == null) {
            this.transforms = Platform.getInstance().getItemTransforms(player, stack).apply(itemDisplayContext);
        }
    }

    public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        float[][] texUV;
        if (RenderPass.current() == RenderPass.RETICLE && quad.direction() != Direction.SOUTH) {
            return;
        }
        GeoVertex[] vertices = quad.vertices();
        if (this.glowingSpriteUVProviderSupplier != null) {
            SpriteUVProvider spriteUVProvider = this.glowingSpriteUVProviderSupplier.get();
            float[] uv = spriteUVProvider.getSpriteUV(this.glowingProgress);
            float minU = uv[0];
            float minV = uv[1];
            float maxU = uv[2];
            float maxV = uv[3];
            texUV = new float[][]{{minU, minV}, {maxU, minV}, {maxU, maxV}, {minU, maxV}};
        } else {
            texUV = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
        }
        for (int i = 0; i < vertices.length; ++i) {
            float texV;
            float texU;
            GeoVertex vertex = vertices[i];
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            RenderPass renderPass = RenderPass.current();
            if (renderPass == RenderPass.GLOW && this.useCustomGlowingTexture) {
                texU = texUV[i][0];
                texV = texUV[i][1];
            } else {
                texU = vertex.texU();
                texV = vertex.texV();
            }
            buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), color, texU, texV, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    private boolean shouldRenderBone(String boneName) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = true;
        for (GeoRenderLayer layer : this.getRenderLayers()) {
            RenderPass renderPass;
            RenderPass renderPass2;
            if (!(layer instanceof RenderApprover)) continue;
            RenderApprover renderApprover = (RenderApprover)layer;
            if (layer instanceof RenderPassProvider) {
                RenderPassProvider rp = (RenderPassProvider)layer;
                renderPass2 = rp.getRenderPass();
            } else {
                renderPass2 = null;
            }
            if (renderApprover.approveRendering(renderPass = renderPass2, boneName, rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext())) continue;
            shouldRender = false;
            break;
        }
        return shouldRender;
    }

    public void renderRecursively(PoseStack poseStack, GunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = this.approveRendering(this.getRenderPass(), bone.getName(), rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext());
        if (shouldRender) {
            boolean isGlowEnabled;
            GlowAnimationController glowEffect = this.gunClientState != null ? (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + String.valueOf(RenderPass.getEffectId())) : null;
            Runnable r = () -> {
                RotationAnimationController spinner;
                RotationAnimationController rotationAnimationController = spinner = this.gunClientState != null ? (RotationAnimationController)this.gunClientState.getAnimationController("rotation" + bone.getName()) : null;
                if (spinner != null) {
                    spinner.renderRecursively(this, poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
                } else {
                    super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
                }
            };
            boolean bl = isGlowEnabled = glowEffect != null && glowEffect.getGlowingPartNames().contains(bone.getName());
            if (isGlowEnabled) {
                try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push(current.getItemStack(), current.getItemDisplayContext());){
                    GlowingItemLayer.setGlowEnabled(isGlowEnabled);
                    r.run();
                }
            } else {
                r.run();
            }
        }
    }

    public void renderRecursivelySuper(PoseStack poseStack, GunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void renderCubesOfBone(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        RenderPass renderPass = RenderPass.current();
        if (!this.shouldRenderBone(bone.getName())) {
            return;
        }
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        ItemDisplayContext itemDisplayContext = hrc.getItemDisplayContext();
        boolean isFirstPerson = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        double aimingProgress = 0.0;
        if (this.gunClientState != null) {
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)this.gunClientState.getAnimationController("aiming");
            aimingProgress = aimingController.getValue();
            if ((!MiscUtil.isGreaterThanZero(this.gunClientState.getGunItem().getPipScopeZoom()) || !Config.pipScopesEnabled) && this.hasScopeOverlay && !this.gunClientState.isReloading() && isFirstPerson && aimingProgress > 0.4) {
                return;
            }
        }
        switch (renderPass) {
            case GLOW: {
                this.renderGlow(poseStack, bone, buffer, packedLight, packedOverlay, color);
                break;
            }
            case HANDS: {
                if (bone.getName().equals(BONE_RIGHTARM)) {
                    this.renderRightArm(poseStack, bone, buffer, packedLight, packedOverlay, color);
                    break;
                }
                if (!bone.getName().equals(BONE_LEFTARM)) break;
                this.renderLeftArm(poseStack, bone, buffer, packedLight, packedOverlay, color);
                break;
            }
            case PIP: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderPip(poseStack, bone, buffer, packedLight, color, aimingProgress);
                break;
            }
            case PIP_OVERLAY: {
                if (!bone.getName().equals(BONE_SCOPE_PIP) || !(aimingProgress > 0.0)) break;
                this.renderPipOverlay(poseStack, bone, buffer, packedLight, color, aimingProgress, PipItemLayer.isParallaxEnabled());
                break;
            }
            case PIP_MASK: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderPipMask(poseStack, bone, buffer, packedLight, color, aimingProgress);
                break;
            }
            case SEE_THROUGH_MASK: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderSeeThroughMask(poseStack, bone, buffer, packedLight, color, aimingProgress);
                break;
            }
            case SEE_THROUGH_MASK_FRONT: {
                if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                this.renderSeeThroughMaskFront(poseStack, bone, buffer, packedLight, color, aimingProgress);
                break;
            }
            case SEE_THROUGH_OVERLAY: {
                if (!bone.getName().equals(BONE_SCOPE_PIP) || !(aimingProgress > 0.0)) break;
                this.renderSeeThroughOverlay(poseStack, bone, buffer, packedLight, color, aimingProgress, PipItemLayer.isParallaxEnabled());
                break;
            }
            case RETICLE: {
                boolean isParallaxEnabled = ReticleItemLayer.isParallaxEnabled();
                if (isParallaxEnabled && bone.getName().equals(BONE_RETICLE)) {
                    this.renderReticleWithParallax(poseStack, bone, buffer, packedLight, color, aimingProgress, hrc.getAttribute("max_angular_offset_cos", Float.valueOf(DEFAULT_MAX_ANGULAR_RETICLE_OFFSET)).floatValue());
                    break;
                }
                if (isParallaxEnabled || !bone.getName().equals(BONE_SCOPE)) break;
                this.renderReticle(poseStack, bone, buffer, packedLight, packedOverlay, color, aimingProgress);
                break;
            }
            case MUZZLE_FLASH: {
                if (!bone.getName().equals(BONE_MUZZLEFLASH) && !bone.getName().equals(BONE_MUZZLEFLASH2) && !bone.getName().equals(BONE_MUZZLEFLASH3)) break;
                this.renderMuzzleFlash(poseStack, bone, buffer, packedLight);
                break;
            }
            case MAIN_ITEM: 
            case ATTACHMENTS: {
                if (bone.getName().equals(BONE_MUZZLEFLASH) || bone.getName().equals(BONE_MUZZLEFLASH2) || bone.getName().equals(BONE_MUZZLEFLASH3) || bone.getName().equals(BONE_MUZZLE) || bone.getName().equals(BONE_MUZZLE2) || bone.getName().equals(BONE_MUZZLE3)) {
                    if (!ActiveMuzzleFeature.isActiveMuzzle(HierarchicalRenderContext.getRootItemStack(), hrc.getItemStack(), itemDisplayContext, bone.getName())) break;
                    this.captureMuzzlePose(bone, poseStack, itemDisplayContext);
                    break;
                }
                if (!this.canRenderPart(bone.getName())) break;
                super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, color);
            }
        }
    }

    private void renderGlow(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        GlowAnimationController glowEffect;
        if (this.gunClientState == null) {
            return;
        }
        if (GlowingItemLayer.isGlowEnabled() && (glowEffect = (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + String.valueOf(RenderPass.getEffectId()))) != null) {
            glowEffect.renderCubesOfBone(this, poseStack, bone, buffer, packedLight, packedOverlay, color);
        }
    }

    private void renderMuzzleFlash(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight) {
        if (this.gunClientState == null || this.gunClientState.isReloading() || this.gunClientState.isInspecting()) {
            return;
        }
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad quad1 = cube.quads()[0];
            Vector3f v1Position = quad1.vertices()[0].position();
            GeoQuad quad2 = cube.quads()[2];
            Vector3f v3Position = quad2.vertices()[2].position();
            Vector3f position = new Vector3f();
            position = v3Position.sub((Vector3fc)v1Position, position);
            position = position.mul(0.5f);
            position = position.add((Vector3fc)v1Position);
            EffectRenderContext context = new EffectRenderContext().withPoseStack(poseStack).withPosition(new Vec3((double)position.x, (double)position.y, (double)position.z)).withVertexBuffer(buffer).withLightColor(packedLight);
            for (MuzzleFlashEffect effect : this.gunClientState.getMuzzleFlashEffects()) {
                UUID effectId = EffectRegistry.getEffectId(effect.getName());
                if (!Objects.equal((Object)effectId, (Object)RenderPass.getEffectId())) continue;
                effect.render(context);
            }
        }
    }

    private void renderReticleWithParallax(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress, float maxAngularOffsetCos) {
        if (bone == null) {
            return;
        }
        if (this.gunClientState == null) {
            return;
        }
        if (aimingProgress < 0.8) {
            return;
        }
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            float threshold;
            Vector4f n;
            Vector4f p0;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            Matrix4f modelMatrix = this.captureCubeMatrix(poseStack, cube, 3);
            Pair<Vector4f, Float> intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix, p0 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
            Vector4f intersectionPoint = (Vector4f)intersection.getFirst();
            if (intersectionPoint == null) {
                return;
            }
            float angularOffsetCos = ((Float)intersection.getSecond()).floatValue();
            float f = threshold = aimingProgress < 1.0 || this.gunClientState.isReloading() || this.gunClientState.isInspecting() ? DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED : maxAngularOffsetCos;
            if (angularOffsetCos > threshold) {
                poseStack.pushPose();
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.translate(Mth.clamp((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
                float alpha = (float)aimingProgress;
                RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, color);
                poseStack.popPose();
            }
        }
    }

    private void renderReticle(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color, double aimingProgress) {
        if (this.gunClientState == null || this.gunClientState.isReloading() || this.gunClientState.isInspecting()) {
            return;
        }
        BakedGeoModel reticleBakedGeoModel = this.getReticleModel();
        GeoBone reticleBone = (GeoBone)reticleBakedGeoModel.getBone(BONE_SCOPE).get();
        if (reticleBone != null) {
            poseStack.pushPose();
            if (aimingProgress > 0.9 && !this.gunClientState.isReloading()) {
                this.applyRefTransforms(poseStack, bone, reticleBone);
                double yaw = ClientEventHandler.reticleInertiaController.getYaw();
                double pitch = ClientEventHandler.reticleInertiaController.getPitch();
                Quaternionf q = new Quaternionf(pitch, yaw, 0.0, 1.0);
                poseStack.translate(-yaw * 25.0, pitch * 25.0, -8.0);
                poseStack.mulPose(q);
                super.renderCubesOfBone(poseStack, reticleBone, buffer, packedLight, packedOverlay, color);
            }
            poseStack.popPose();
        }
    }

    private void renderPip(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress) {
        List cubes;
        poseStack.pushPose();
        if (aimingProgress > 0.9 && this.gunClientState != null && !this.gunClientState.isReloading() && (cubes = bone.getCubes()) != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            ClientSystem.getInstance().getAuxLevelRenderer().renderToBuffer(poseStack, northQuad, buffer, packedLight);
        }
        poseStack.popPose();
    }

    private void renderPipOverlay(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress, boolean isParallaxEnabled) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            Vector4f n;
            Vector4f p0;
            Matrix4f modelMatrix;
            Pair<Vector4f, Float> intersection;
            Vector4f intersectionPoint;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            if (isParallaxEnabled && (intersectionPoint = (Vector4f)(intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix = this.captureCubeMatrix(poseStack, cube, 3), p0 = new Vector4f(0.0f, 0.0f, 0.01f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f))).getFirst()) != null) {
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.translate(Mth.clamp((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
            }
            float alpha = (float)aimingProgress;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.001f);
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, color);
            poseStack.popPose();
        }
    }

    private void renderSeeThroughOverlay(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress, boolean isParallaxEnabled) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            Vector4f n;
            Vector4f p0;
            Matrix4f modelMatrix;
            Pair<Vector4f, Float> intersection;
            Vector4f intersectionPoint;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            if (isParallaxEnabled && (intersectionPoint = (Vector4f)(intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix = this.captureCubeMatrix(poseStack, cube, 3), p0 = new Vector4f(0.0f, 0.0f, 0.01f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f))).getFirst()) != null) {
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.translate(Mth.clamp((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.clamp((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
            }
            float alpha = (float)aimingProgress;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.001f);
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, color);
            poseStack.popPose();
        }
    }

    private void renderSeeThroughMask(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            float alpha = (float)aimingProgress;
            poseStack.pushPose();
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, color);
            poseStack.popPose();
        }
    }

    private void renderSeeThroughMaskFront(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            GeoQuad resizedQuad = RenderUtil.resizeQuad(northQuad, 4.6f * (float)aimingProgress);
            float alpha = (float)aimingProgress;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, -2.0f);
            RenderUtil.renderQuad(poseStack, resizedQuad, buffer, 0.0f, 0.0f, color);
            poseStack.popPose();
        }
    }

    private void renderPipMask(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int color, double aimingProgress) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            float alpha = (float)aimingProgress;
            poseStack.pushPose();
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, color);
            poseStack.popPose();
        }
    }

    private void renderLeftArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        BakedGeoModel handsBakedGeoModel = this.getLeftHandModel();
        GeoBone leftArmBone = handsBakedGeoModel.getBone(BONE_LEFTARM).orElse(null);
        if (leftArmBone != null) {
            poseStack.pushPose();
            this.applyArmRefTransforms(poseStack, bone, leftArmBone);
            super.renderCubesOfBone(poseStack, leftArmBone, buffer, packedLight, packedOverlay, color);
            poseStack.popPose();
        }
    }

    private void renderRightArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        BakedGeoModel handsBakedGeoModel = this.getRightHandModel();
        GeoBone rightArmBone = handsBakedGeoModel.getBone(BONE_RIGHTARM).orElse(null);
        if (rightArmBone != null) {
            poseStack.pushPose();
            this.applyArmRefTransforms(poseStack, bone, rightArmBone);
            super.renderCubesOfBone(poseStack, rightArmBone, buffer, packedLight, packedOverlay, color);
            poseStack.popPose();
        }
    }

    private void captureMuzzlePose(GeoBone refBone, PoseStack poseStack, ItemDisplayContext itemDisplayContext) {
        if (this.gunClientState == null) {
            return;
        }
        poseStack.pushPose();
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        software.bernie.geckolib.util.RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)refCube);
        software.bernie.geckolib.util.RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)refCube);
        software.bernie.geckolib.util.RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)refCube);
        poseStack.translate(refBone.getPivotX() / 16.0f, refBone.getPivotY() / 16.0f, refBone.getPivotZ() / 16.0f);
        GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
        if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            GunStatePoseProvider.PoseContext poseContext = null;
            if (refBone.getName().equals(BONE_MUZZLE) || refBone.getName().equals(BONE_MUZZLE2)) {
                poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE;
            } else if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH;
            }
            if (poseContext != null) {
                Minecraft mc = Minecraft.getInstance();
                Camera camera = mc.gameRenderer.getMainCamera();
                if (IrisCompat.getInstance().isShaderPackEnabled()) {
                    PoseStack poseStack1 = new PoseStack();
                    poseStack1.mulPose(new Matrix4f().rotate((Quaternionfc)camera.rotation()));
                    poseStack1.mulPose(poseStack.last().pose());
                    gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack1.last().copy());
                } else {
                    gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.last().copy());
                }
                this.setCurrentMuzzlePosition(poseStack, poseContext, itemDisplayContext);
            }
        } else if (itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            GunStatePoseProvider.PoseContext poseContext = null;
            if (refBone.getName().equals(BONE_MUZZLE) || refBone.getName().equals(BONE_MUZZLE2)) {
                poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE;
            } else if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH;
            }
            if (poseContext != null) {
                gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.last().copy());
                this.setCurrentMuzzlePosition(poseStack, poseContext, itemDisplayContext);
            }
        }
        poseStack.popPose();
    }

    private void setCurrentMuzzlePosition(PoseStack poseStack, GunStatePoseProvider.PoseContext poseContext, ItemDisplayContext itemDisplayContext) {
        Matrix4f transform;
        poseStack.pushPose();
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Matrix4f currentProjectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f poseStackMatrix = poseStack.last().pose();
        double fov = ((Integer)mc.options.fov().get()).doubleValue();
        Matrix4f fovProjectionMatrix = mc.gameRenderer.getProjectionMatrix(fov);
        if (IrisCompat.getInstance().isShaderPackEnabled()) {
            transform = new Matrix4f();
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                transform = transform.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)camera.rotation()));
            }
            transform = transform.mul((Matrix4fc)poseStackMatrix);
        } else {
            Quaternionf inverseCameraRotation = camera.rotation().conjugate(new Quaternionf());
            Matrix4f inverseViewRotationMatrix = new Matrix4f().rotation((Quaternionfc)inverseCameraRotation);
            transform = new Matrix4f().mul((Matrix4fc)new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()).invert()).mul((Matrix4fc)fovProjectionMatrix.invert(new Matrix4f())).mul((Matrix4fc)currentProjectionMatrix).mul((Matrix4fc)new Matrix4f((Matrix4fc)inverseViewRotationMatrix)).mul((Matrix4fc)poseStackMatrix);
        }
        Vector4f relPos = transform.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f pos = new Vector4f((Vector4fc)relPos);
        pos.add((float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z, 1.0f);
        Vector4f direction = transform.transform(new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
        direction.sub((Vector4fc)relPos);
        direction.normalize();
        GunStatePoseProvider.getInstance().setPositionAndDirection(this.gunClientState, poseContext, new Vec3((double)pos.x, (double)pos.y, (double)pos.z), new Vec3((double)direction.x, (double)direction.y, (double)direction.z));
        poseStack.popPose();
    }

    public void renderCubesOfBoneParent(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, color);
    }

    public void renderCubesOfBoneParent(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int color, boolean useCustomGlowingTexture, Set<Direction> directions, Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier, float glowingProgress) {
        boolean hadCustomGlowingTexture = this.useCustomGlowingTexture;
        this.useCustomGlowingTexture = useCustomGlowingTexture;
        this.glowDirections = directions;
        this.glowingSpriteUVProviderSupplier = glowingSpriteUVProviderSupplier;
        this.glowingProgress = glowingProgress;
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, color);
        this.glowDirections = null;
        this.useCustomGlowingTexture = hadCustomGlowingTexture;
    }

    public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        software.bernie.geckolib.util.RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        software.bernie.geckolib.util.RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
        software.bernie.geckolib.util.RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = poseStack.last().pose();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null || this.glowDirections != null && !this.glowDirections.contains(quad.direction())) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            software.bernie.geckolib.util.RenderUtil.fixInvertedFlatCube((GeoCube)cube, (Vector3f)normal);
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, color);
        }
    }

    private void applyArmRefTransforms(PoseStack poseStack, GeoBone refBone, GeoBone leftArmBone) {
        GeoCube leftArmBoneCube = (GeoCube)leftArmBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex leftArmBoneVertex = leftArmBoneCube.quads()[0].vertices()[0];
        GeoVertex refVertex = refCube.quads()[0].vertices()[0];
        float dx = refVertex.position().x() - leftArmBoneVertex.position().x();
        float dy = refVertex.position().y() - leftArmBoneVertex.position().y();
        float dz = refVertex.position().z() - leftArmBoneVertex.position().z();
        poseStack.translate(dx, dy, dz);
    }

    private void applyRefTransforms(PoseStack poseStack, GeoBone refBone, GeoBone actualBone) {
        GeoCube actualArmBoneCube = (GeoCube)actualBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex refQ0v0 = refCube.quads()[2].vertices()[0];
        GeoVertex refQ0v2 = refCube.quads()[2].vertices()[2];
        GeoVertex actualQ0v0 = actualArmBoneCube.quads()[2].vertices()[0];
        GeoVertex actualQ0v2 = actualArmBoneCube.quads()[2].vertices()[2];
        float refSizeX = Math.abs(refQ0v0.position().x - refQ0v2.position().x);
        float actualSizeX = Math.abs(actualQ0v0.position().x - actualQ0v2.position().x);
        float refSizeY = Math.abs(refQ0v0.position().y - refQ0v2.position().y);
        float actualSizeY = Math.abs(actualQ0v0.position().y - actualQ0v2.position().y);
        float refXLeft = refQ0v0.position().x;
        float refZLeft = refQ0v2.position().z;
        float actualXLeft = actualQ0v0.position().x;
        float actualYTop = actualQ0v0.position().y;
        float refYTop = refQ0v0.position().y;
        float actualZLeft = actualQ0v0.position().z;
        float dx = -(actualXLeft + (refXLeft - (refSizeX - actualSizeX) / 2.0f));
        float dy = refYTop + (actualSizeY - refSizeY) / 2.0f - actualYTop;
        float dz = refZLeft - actualZLeft;
        poseStack.translate(dx, dy, dz);
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String boneName, ItemStack rootStack, ItemStack currentStack, String path, ItemDisplayContext itemDisplayContext) {
        List<Features.EnabledFeature> enabledVisibilityFeatures = Features.getEnabledFeatures(rootStack, PartVisibilityFeature.class);
        ConditionContext conditionContext = new ConditionContext(null, rootStack, currentStack, this.gunClientState, itemDisplayContext);
        for (Features.EnabledFeature enabledVisibilityFeature : enabledVisibilityFeatures) {
            PartVisibilityFeature visibilityFeature = (PartVisibilityFeature)enabledVisibilityFeature.feature();
            if (visibilityFeature.isPartVisible((ItemLike)currentStack.getItem(), boneName, conditionContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Nullable
    public RenderType getRenderType(GunItem animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        HierarchicalRenderContext rootContext = HierarchicalRenderContext.getRoot();
        Object isPipFallbackEnabled = rootContext.getAttribute("isPipFallbackEnabled");
        if (isPipFallbackEnabled != null && ((Boolean)isPipFallbackEnabled).booleanValue()) {
            return RenderTypeProvider.getInstance().getDefaultItemRenderType(new RenderTypeKey(texture, true, 517, 7680, 2));
        }
        return RenderTypeProvider.getInstance().getDefaultItemRenderType(new RenderTypeKey(texture, false, 0, 0, 0));
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext context) {
        return true;
    }

    @Override
    public boolean canRenderPart(String boneName) {
        return !boneName.equals(BONE_LEFTARM) && !boneName.equals(BONE_RIGHTARM) && !boneName.equals(BONE_RETICLE) && !boneName.equals(BONE_SCOPE) && !boneName.equals(BONE_SCOPE_PIP);
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return null;
    }

    private static Pair<Vector4f, Float> getPlayerViewIntersection(Matrix4f modelMatrix, Vector4f p0, Vector4f n) {
        Matrix4f transform3;
        Minecraft mc = Minecraft.getInstance();
        Player player = ClientUtil.getClientPlayer();
        float partialTicks = mc.getTimer().getGameTimeDeltaPartialTick(true);
        Vec3 playerEyePositionRelativeToCamera = new Vec3(0.0, 0.0, 0.0);
        Vec3 playerViewVector = player.getViewVector(partialTicks);
        if (IrisCompat.getInstance().isShaderPackEnabled()) {
            Camera camera = mc.gameRenderer.getMainCamera();
            Quaternionf cameraRotation = camera.rotation().conjugate(new Quaternionf());
            transform3 = new Matrix4f((Matrix4fc)new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()).invert()).mul((Matrix4fc)new Matrix4f((Matrix4fc)modelMatrix).invert()).mul((Matrix4fc)new Matrix4f().rotate((Quaternionfc)cameraRotation));
        } else {
            transform3 = new Matrix4f((Matrix4fc)modelMatrix).invert();
        }
        double farDistance = 5.0;
        Vec3 farPointWorld = playerEyePositionRelativeToCamera.add(playerViewVector.scale(farDistance));
        Vector4f eyePositionModel = new Vector4f();
        transform3.transform((float)playerEyePositionRelativeToCamera.x, (float)playerEyePositionRelativeToCamera.y, (float)playerEyePositionRelativeToCamera.z, 1.0f, eyePositionModel);
        Vector4f farPointModel = new Vector4f();
        transform3.transform((float)farPointWorld.x, (float)farPointWorld.y, (float)farPointWorld.z, 1.0f, farPointModel);
        Vector4f l = new Vector4f((Vector4fc)farPointModel).sub((Vector4fc)eyePositionModel).normalize();
        Vector4f l0 = eyePositionModel;
        Vector4f p0MinusL0 = new Vector4f(p0.x, p0.y, p0.z, 1.0f).sub((Vector4fc)l0);
        float numerator = p0MinusL0.dot(n.x, n.y, n.z, 1.0f);
        float denominator = l.dot(n.x, n.y, n.z, 1.0f);
        Vector4f intersectionPoint = null;
        if (denominator > 0.0f) {
            float d = numerator / denominator;
            intersectionPoint = new Vector4f((Vector4fc)l).mul(d).add((Vector4fc)l0);
        }
        return Pair.of(intersectionPoint, (Object)Float.valueOf(denominator));
    }

    public Matrix4f captureCubeMatrix(PoseStack poseStack, GeoCube cube, int side) {
        GeoQuad quad = cube.quads()[side];
        poseStack.pushPose();
        software.bernie.geckolib.util.RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        software.bernie.geckolib.util.RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
        software.bernie.geckolib.util.RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        Vector3f v0Pos = quad.vertices()[0].position();
        Vector3f v2Pos = quad.vertices()[2].position();
        poseStack.translate((v0Pos.x + v2Pos.x) * 0.5f, (v0Pos.y + v2Pos.y) * 0.5f, (v0Pos.z + v2Pos.z) * 0.5f);
        Matrix4f cubeMatrix = poseStack.last().pose();
        poseStack.popPose();
        return cubeMatrix;
    }

    public void preRender(PoseStack poseStack, GunItem animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        RenderPass renderPass = RenderPass.current();
        if (renderPass == RenderPass.PIP_MASK || renderPass == RenderPass.SEE_THROUGH_MASK || renderPass == RenderPass.SEE_THROUGH_MASK_FRONT) {
            this.updateAnimatedTextureFrame(animatable);
            for (GeoBone group : model.topLevelBones()) {
                this.renderRecursively(poseStack, animatable, group, (RenderType)null, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
            }
        }
    }
}

