/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.gui;

import com.vicmatskiv.pointblank.Config;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SettingsScreen
extends Screen {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private Button pipScopesButton;

    public SettingsScreen() {
        super((Component)Component.translatable((String)"screen.pointblank.settings.title"));
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.pipScopesButton = Button.builder((Component)this.getPipScopesButtonText(), this::onPipScopesToggle).bounds(centerX - 100, centerY - 10 - 10, 200, 20).build();
        this.pipScopesButton.active = !Config.pipFallbackModDetected;
        this.addRenderableWidget((GuiEventListener)this.pipScopesButton);
        Button doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).bounds(centerX - 100, centerY + 10 + 10, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
    }

    private Component getPipScopesButtonText() {
        boolean forcedOff = Config.pipFallbackModDetected;
        boolean enabled = Config.pipScopesEnabled && !forcedOff;
        String statusKey = enabled ? "options.on" : "options.off";
        MutableComponent message = Component.translatable((String)"screen.pointblank.settings.pip_scopes").append(": ").append((Component)Component.translatable((String)statusKey));
        if (forcedOff) {
            message.append(" ").append((Component)Component.translatable((String)"screen.pointblank.settings.lock"));
        }
        return message;
    }

    private void onPipScopesToggle(Button button) {
        Config.setPipScopesEnabled(!Config.pipScopesEnabled);
        button.setMessage(this.getPipScopesButtonText());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        if (this.pipScopesButton != null) {
            this.pipScopesButton.active = !Config.pipFallbackModDetected;
            this.pipScopesButton.setMessage(this.getPipScopesButtonText());
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 2 - 50, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

