/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.AttachmentModelInfo;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.FirstPersonWalkingAnimationHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateTicker;
import com.vicmatskiv.pointblank.client.LockableTarget;
import com.vicmatskiv.pointblank.client.RealtimeLinearEaser;
import com.vicmatskiv.pointblank.client.ThrowableClientState;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunJumpAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRandomizingAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRecoilAnimationController;
import com.vicmatskiv.pointblank.client.controller.InertiaController;
import com.vicmatskiv.pointblank.client.controller.PostPassEffectController;
import com.vicmatskiv.pointblank.client.controller.PryAnimationController;
import com.vicmatskiv.pointblank.client.controller.TimerController;
import com.vicmatskiv.pointblank.client.controller.ViewShakeAnimationController2;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.gui.GunItemOverlay;
import com.vicmatskiv.pointblank.client.gui.SettingsScreen;
import com.vicmatskiv.pointblank.client.render.CrosshairRenderer;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimatorCompat;
import com.vicmatskiv.pointblank.event.InputEvent;
import com.vicmatskiv.pointblank.event.LevelEvent;
import com.vicmatskiv.pointblank.event.LivingEvent;
import com.vicmatskiv.pointblank.event.RenderGuiEventPost;
import com.vicmatskiv.pointblank.event.RenderGuiOverlayEvent;
import com.vicmatskiv.pointblank.event.RenderHandEvent;
import com.vicmatskiv.pointblank.event.RenderHandsEvent;
import com.vicmatskiv.pointblank.event.RenderLevelEvent;
import com.vicmatskiv.pointblank.event.RenderLivingEvent;
import com.vicmatskiv.pointblank.event.RenderTooltipEvent;
import com.vicmatskiv.pointblank.event.SubscribeEvent2;
import com.vicmatskiv.pointblank.event.TickEvent;
import com.vicmatskiv.pointblank.event.ViewportEvent;
import com.vicmatskiv.pointblank.explosion.ExplosionEvent;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.input.KeyModifierType;
import com.vicmatskiv.pointblank.item.ExplosionDescriptor;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.ItemExtra;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import com.vicmatskiv.pointblank.network.AimingChangeRequestPacket;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.LazyOptional;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.UpDownCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Vector2ic;
import org.lwjgl.glfw.GLFW;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;

public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static ClientEventHandler instance;
    public static final Supplier<KeyMapping> RELOAD_KEY;
    public static final Supplier<KeyMapping> FIRE_MODE_KEY;
    public static final Supplier<KeyMapping> INSPECT_KEY;
    public static final Supplier<KeyMapping> ATTACHMENT_KEY;
    public static final Supplier<KeyMapping> SCOPE_SWITCH_KEY;
    public static final Supplier<KeyMapping> SETTINGS_KEY;
    public static final KeyModifierType SETTINGS_KEY_MODIFIER;
    private static ReentrantLock mainLoopLock;
    private InertiaController scopeInertiaController = new InertiaController(0.06, 0.2, 0.1);
    private InertiaController inertiaController = new InertiaController(0.01, 0.1, 1.2217304706573486);
    public static InertiaController reticleInertiaController;
    private GunJumpAnimationController jumpController = new GunJumpAnimationController(0.3, 0.8, 1.3, 0.05, 2000L);
    private ViewShakeAnimationController2 sharedViewShakeController = new ViewShakeAnimationController2(0.15, 0.3, 1.0, 0.01, 500L);
    private int currentInventorySlot;
    private int previousInventorySlot;
    private boolean inventorySlotChanged;
    private boolean currentSlotHasGun;
    private boolean currentSlotHasGunChanged;
    private boolean leftMouseButtonDown = false;
    private boolean rightMouseButtonDown = false;
    private boolean settingsKeyPressed = false;
    private float previousPlayerXRot;
    private float previousPlayerYRot;
    private float playerDeltaXRot;
    private float playerDeltaYRot;
    private double previousPlayerPosX;
    private double previousPlayerPosY;
    private double previousPlayerPosZ;
    private double playerDeltaX;
    private double playerDeltaY;
    private double playerDeltaZ;
    private static LivingEntity currentEntityLiving;
    private RealtimeLinearEaser bobbingValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser bobbingYawValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser zoomValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser crossHairExp = new RealtimeLinearEaser(100L);
    private static boolean isPipFallbackZoomActive;
    private LockableTarget lockableTarget = new LockableTarget();
    private static PostPassEffectController postPassEffectController;
    private static final ResourceLocation crossHairOverlay;
    private final FirstPersonWalkingAnimationHandler firstPersonWalkingAnimationHandler;

    public static ClientEventHandler getInstance() {
        return instance;
    }

    public ClientEventHandler() {
        instance = this;
        this.firstPersonWalkingAnimationHandler = new FirstPersonWalkingAnimationHandler();
        this.startGunTicker();
    }

    private void startGunTicker() {
        GunStateTicker gunStateTicker = new GunStateTicker(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> gunStateTicker.shutdown()));
        gunStateTicker.start();
    }

    @SubscribeEvent2
    public void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            this.currentInventorySlot = -1;
        }
    }

    @SubscribeEvent2
    public void onExplosion(ExplosionEvent event) {
        double distanceToPlayer = event.getLocation().distanceTo(ClientUtil.getClientPlayer().position());
        ExplosionDescriptor descriptor = event.getExplosionDescriptor();
        distanceToPlayer = Mth.clamp((double)distanceToPlayer, (double)1.0, (double)Double.MAX_VALUE);
        double lambda = 0.2;
        double adjustedPower = (double)descriptor.power() * Math.exp(-lambda * distanceToPlayer);
        this.sharedViewShakeController.reset(adjustedPower, 0.5, 1.5, 0.01);
    }

    @SubscribeEvent2
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Player player = ClientUtil.getClientPlayer();
        if (event.getPhase() == TickEvent.Phase.START) {
            GunClientState state;
            mainLoopLock.lock();
            if (player != null && (state = GunClientState.getMainHeldState()) != null) {
                ItemStack gunStack = GunItem.getMainHeldGunItemStack((LivingEntity)player);
                Minecraft mc = Minecraft.getInstance();
                float renderTickTime = MiscUtil.getRenderTickTime(event.getTimer());
                state.renderTick((LivingEntity)player, gunStack, renderTickTime);
                if (!mc.options.getCameraType().isFirstPerson()) {
                    return;
                }
                GunItem gunItem = state.getGunItem();
                ItemDisplayContext itemDisplayContext = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                this.inertiaController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, renderTickTime);
                if (gunItem.getScopeOverlay() != null && state.isAiming() && state.isFiring()) {
                    this.scopeInertiaController.setDynamicModifier(0.01f);
                } else {
                    this.scopeInertiaController.setDynamicModifier(1.0f);
                }
                this.scopeInertiaController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, renderTickTime);
                this.jumpController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, renderTickTime);
                postPassEffectController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, renderTickTime);
                this.sharedViewShakeController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, renderTickTime);
            }
        } else if (event.getPhase() == TickEvent.Phase.END && mainLoopLock.isHeldByCurrentThread()) {
            mainLoopLock.unlock();
        }
    }

    public static PostPassEffectController getPostPassEffectController() {
        return postPassEffectController;
    }

    private boolean autoReloadEnabled(Player player) {
        Config.AutoReload autoReload = Config.autoReload;
        return autoReload == Config.AutoReload.ENABLED || autoReload == Config.AutoReload.CREATIVE && player.isCreative() || autoReload == Config.AutoReload.SURVIVAL && !player.isCreative();
    }

    @SubscribeEvent2
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (event.getPhase() == TickEvent.Phase.START) {
            mainLoopLock.lock();
        } else if (event.getPhase() == TickEvent.Phase.END) {
            if (player != null) {
                GunClientState state;
                Enableable e;
                boolean isEnabled;
                boolean updatedSlotHasGun;
                this.playerDeltaX = player.getX() - this.previousPlayerPosX;
                this.playerDeltaY = player.getY() - this.previousPlayerPosY;
                this.playerDeltaZ = player.getZ() - this.previousPlayerPosZ;
                this.previousPlayerPosX = player.getX();
                this.previousPlayerPosY = player.getY();
                this.previousPlayerPosZ = player.getZ();
                this.playerDeltaXRot = player.getXRot() - this.previousPlayerXRot;
                this.playerDeltaYRot = player.getYRot() - this.previousPlayerYRot;
                this.previousPlayerXRot = player.getXRot();
                this.previousPlayerYRot = player.getYRot();
                ItemStack heldItem = player.getMainHandItem();
                int activeSlot = player.getInventory().selected;
                if (activeSlot != this.currentInventorySlot) {
                    this.inventorySlotChanged = true;
                    this.previousInventorySlot = this.currentInventorySlot;
                    this.currentInventorySlot = activeSlot;
                } else {
                    this.inventorySlotChanged = false;
                }
                boolean bl = updatedSlotHasGun = heldItem != null && heldItem.getItem() instanceof GunItem;
                if (updatedSlotHasGun != this.currentSlotHasGun) {
                    this.currentSlotHasGun = updatedSlotHasGun;
                    this.currentSlotHasGunChanged = true;
                } else {
                    this.currentSlotHasGunChanged = false;
                }
                Item item = heldItem.getItem();
                boolean bl2 = isEnabled = !(item instanceof Enableable) || (e = (Enableable)item).isEnabled();
                if (this.autoReloadEnabled((Player)player) && heldItem.getItem() instanceof GunItem && !this.inventorySlotChanged) {
                    Optional<Integer> optionalAmmo = GunItem.getClientSideAmmo((Player)player, heldItem, this.currentInventorySlot);
                    optionalAmmo.ifPresent(ammo -> {
                        if (ammo <= 0) {
                            ((GunItem)heldItem.getItem()).tryReload((Player)player, heldItem);
                        }
                    });
                }
                while (isEnabled && RELOAD_KEY.get().consumeClick() && !this.inventorySlotChanged) {
                    if (!(heldItem.getItem() instanceof GunItem)) continue;
                    ((GunItem)heldItem.getItem()).tryReload((Player)player, heldItem);
                }
                while (FIRE_MODE_KEY.get().consumeClick()) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryChangeFireMode((LivingEntity)player, player.getMainHandItem());
                }
                while (INSPECT_KEY.get().consumeClick() && !this.inventorySlotChanged) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryInspect((LivingEntity)player, player.getMainHandItem());
                }
                boolean settingsKeyTriggered = false;
                long windowHandle = mc.getWindow().getWindow();
                boolean altKeyDown = KeyModifierType.ALT.isDown();
                if (Platform.getInstance().supportsKeyModifiers()) {
                    if (Platform.getInstance().isKeyWithModifierDown(SETTINGS_KEY.get(), SETTINGS_KEY_MODIFIER)) {
                        settingsKeyTriggered = true;
                    }
                } else {
                    boolean isKeyUnbound = SETTINGS_KEY.get().isUnbound();
                    if (isKeyUnbound) {
                        if (altKeyDown && GLFW.glfwGetKey((long)windowHandle, (int)89) == 1) {
                            settingsKeyTriggered = true;
                        }
                    } else if (SETTINGS_KEY.get().isDown()) {
                        settingsKeyTriggered = true;
                    }
                }
                if (settingsKeyTriggered) {
                    if (!this.settingsKeyPressed) {
                        this.settingsKeyPressed = true;
                        this.openSettingsScreen();
                    }
                } else {
                    this.settingsKeyPressed = false;
                }
                while (!altKeyDown && ATTACHMENT_KEY.get().consumeClick()) {
                    if (heldItem == null || !(heldItem.getItem() instanceof AttachmentHost)) continue;
                    Attachments.tryAttachmentMode((Player)player, heldItem);
                }
                boolean leftMouseButtonDown = mc.options.keyAttack.isDown();
                if (leftMouseButtonDown && !this.leftMouseButtonDown) {
                    this.leftMouseDown();
                } else if (!leftMouseButtonDown && this.leftMouseButtonDown) {
                    this.leftMouseButtonRelease();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                boolean rightMouseButtonDown = mc.options.keyUse.isDown();
                if (rightMouseButtonDown && !this.rightMouseButtonDown) {
                    this.rightMouseButtonDown();
                } else if (!rightMouseButtonDown && this.rightMouseButtonDown) {
                    this.rightMouseButtonRelease();
                }
                GunClientState state2 = GunClientState.getMainHeldState();
                while (SCOPE_SWITCH_KEY.get().consumeClick()) {
                    if (heldItem == null || !(heldItem.getItem() instanceof GunItem) || state2 == null || !state2.isAiming()) continue;
                    Attachments.tryNextAttachment((Player)player, heldItem, AttachmentCategory.SCOPE, AimingFeature.class);
                }
                if (heldItem.getItem() instanceof LockableTarget.TargetLocker) {
                    this.lockableTarget.setLocker((LockableTarget.TargetLocker)heldItem.getItem());
                } else {
                    this.lockableTarget.setLocker(null);
                }
                if (state2 != null && state2.isAiming() && state2.isIdle() && this.lockableTarget.getLockTimeTicks() > 0L) {
                    HitResult hitResult = HitScan.getNearestObjectInCrosshair((LivingEntity)player, 0.0f, 400.0, b -> false, b -> false, new ArrayList<BlockPos>());
                    if (hitResult.getType() == HitResult.Type.ENTITY) {
                        Entity hitScanEntity = ((EntityHitResult)hitResult).getEntity();
                        if (MiscUtil.isProtected(hitScanEntity) || !this.lockableTarget.tryLock(hitScanEntity)) {
                            this.lockableTarget.unlock(hitScanEntity);
                        }
                    } else {
                        this.lockableTarget.unlock(null);
                    }
                } else {
                    this.lockableTarget.unlock(null);
                }
                if (this.inventorySlotChanged) {
                    Object previousState;
                    this.lockableTarget.unlock(null);
                    this.inertiaController.reset((Player)player);
                    this.scopeInertiaController.reset();
                    reticleInertiaController.reset();
                    if (this.previousInventorySlot >= 0) {
                        Item item2;
                        ItemStack previousStack = player.getInventory().getItem(this.previousInventorySlot);
                        if (previousStack != null && (item2 = previousStack.getItem()) instanceof GunItem) {
                            AnimationController<GeoAnimatable> walkingController;
                            GunItem previousGunItem = (GunItem)item2;
                            previousState = GunClientState.getState((Player)player, previousStack, this.previousInventorySlot, false);
                            if (previousState != null) {
                                ((GunClientState)previousState).tryDeactivate((LivingEntity)player, previousStack);
                            }
                            if ((walkingController = previousGunItem.getGeoAnimationController("walking", previousStack)) != null) {
                                walkingController.tryTriggerAnimation("animation.model.standing");
                            }
                        } else if (previousStack != null && previousStack.getItem() instanceof ThrowableItem && (previousState = ThrowableClientState.getState((Player)player, previousStack, this.previousInventorySlot, false)) != null) {
                            ((ThrowableClientState)previousState).tryDeactivate((LivingEntity)player, previousStack);
                        }
                    }
                    ItemStack mainHeldItem = player.getMainHandItem();
                    if (state2 != null) {
                        state2.tryDraw((LivingEntity)player, mainHeldItem);
                        if (heldItem.getItem() instanceof GunItem) {
                            this.firstPersonWalkingAnimationHandler.reset((Player)player, heldItem);
                        }
                    } else {
                        previousState = mainHeldItem.getItem();
                        if (previousState instanceof ThrowableItem) {
                            ThrowableItem throwableItem = (ThrowableItem)previousState;
                            ThrowableClientState throwableState = ThrowableClientState.getMainHeldState();
                            if (throwableState != null) {
                                throwableState.tryDraw((LivingEntity)player, mainHeldItem);
                            }
                        }
                    }
                }
                if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                    this.jumpController.reset();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                this.rightMouseButtonDown = rightMouseButtonDown;
            }
            if (mainLoopLock.isHeldByCurrentThread()) {
                mainLoopLock.unlock();
            }
        }
    }

    @SubscribeEvent2
    public void onRenderLivingEvent(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> e) {
        currentEntityLiving = e.getEntity();
        if (e.getEntity() instanceof Player) {
            Player player = (Player)e.getEntity();
            ItemStack itemStack = player.getMainHandItem();
            int activeSlot = player.getInventory().selected;
            if (itemStack != null && itemStack.getItem() instanceof GunItem && !PlayerAnimatorCompat.getInstance().isEnabled()) {
                LivingEntityRenderer r;
                EntityModel model;
                GunClientState gunClientState = GunClientState.getState(player, itemStack, activeSlot, false);
                if ((Config.thirdPersonArmPoseAlwaysOn || gunClientState != null && (gunClientState.isAiming() || gunClientState.isFiring())) && (model = (r = e.getRenderer()).getModel()) instanceof PlayerModel) {
                    ((PlayerModel)model).rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            }
            Minecraft mc = Minecraft.getInstance();
            this.handlePlayerFirstPersonMovement(player, itemStack);
            if (Config.thirdPersonAnimationsEnabled) {
                PlayerAnimatorCompat.getInstance().handlePlayerThirdPersonMovement(player, mc.getTimer().getGameTimeDeltaPartialTick(true));
            } else {
                PlayerAnimatorCompat.getInstance().clearAll(player);
            }
        }
    }

    public static LivingEntity getCurrentEntityLiving() {
        return currentEntityLiving;
    }

    @SubscribeEvent2
    public void onRenderGameOverlay(RenderGuiEventPost event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.screen instanceof AttachmentManagerScreen) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (stack != null && stack.getItem() instanceof GunItem) {
            GunItemOverlay.renderGunOverlay2(guiGraphics, stack);
        }
    }

    @SubscribeEvent2
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.player.getMainHandItem().isEmpty() || minecraft.options.getCameraType() != CameraType.FIRST_PERSON) {
            isPipFallbackZoomActive = false;
            return;
        }
        ItemStack itemStack = minecraft.player.getMainHandItem();
        if (!(itemStack.getItem() instanceof GunItem)) {
            isPipFallbackZoomActive = false;
            return;
        }
        int activeSlot = minecraft.player.getInventory().selected;
        GunClientState gunClientState = GunClientState.getState((Player)minecraft.player, itemStack, activeSlot, false);
        if (gunClientState != null) {
            boolean isFallbackActive = this.isPipFallbackActive(itemStack);
            float fullZoom = this.zoomValue.update(AimingFeature.getZoom(itemStack));
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
            float aimingProgress = (float)aimingController.getValue();
            float fullZoomAdj = fullZoom * aimingProgress;
            float baseZoom = AimingFeature.getBaseZoom(itemStack);
            float baseZoomAdj = baseZoom * aimingProgress;
            double baseFov = event.getFOV();
            double worldFov = baseFov - baseFov * (double)fullZoomAdj - (double)((float)this.sharedViewShakeController.getRoll());
            double handFov = baseFov - baseFov * (double)baseZoomAdj - (double)((float)this.sharedViewShakeController.getRoll());
            boolean bl = isPipFallbackZoomActive = isFallbackActive && fullZoomAdj > baseZoomAdj;
            if (!event.useFovSetting() && isPipFallbackZoomActive) {
                event.setFOV(handFov);
            } else {
                event.setFOV(worldFov);
            }
        } else {
            isPipFallbackZoomActive = false;
        }
    }

    private boolean isPipFallbackActive(ItemStack itemStack) {
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.getItem();
        if (item instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)item;
            PipFeature pipFeature = fp.getFeature(PipFeature.class);
            return pipFeature != null && pipFeature.isFallbackRequired();
        }
        return false;
    }

    public static boolean isPipFallbackZoomActive() {
        return isPipFallbackZoomActive;
    }

    @SubscribeEvent2
    public void onRenderHandEvent(RenderHandEvent event) {
        Item item;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == InteractionHand.MAIN_HAND && (item = heldItem.getItem()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            int slot = ClientUtil.getClientPlayer().getInventory().findSlotMatchingItem(heldItem);
            Minecraft minecraft = Minecraft.getInstance();
            GunClientState gunClientState = GunClientState.getState((Player)minecraft.player, heldItem, slot, false);
            if (gunClientState != null) {
                GunRecoilAnimationController recoilController;
                GunRandomizingAnimationController randomizerController;
                Player player;
                if (((Boolean)minecraft.options.bobView().get()).booleanValue() && minecraft.getCameraEntity() instanceof Player) {
                    player = (Player)minecraft.getCameraEntity();
                    PoseStack poseStack = event.getPoseStack();
                    float f = player.walkDist - player.walkDistO;
                    float partialTick = event.getPartialTick();
                    float walkDistance = -(player.walkDist + f * partialTick);
                    float bobbing = Mth.lerp((float)partialTick, (float)player.oBob, (float)player.bob);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-Math.abs(Mth.cos((float)(walkDistance * (float)Math.PI - 0.2f)) * bobbing) * 5.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-Mth.sin((float)(walkDistance * (float)Math.PI)) * bobbing * 3.0f));
                    poseStack.translate(-Mth.sin((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f, Math.abs(Mth.cos((float)(walkDistance * (float)Math.PI)) * bobbing), 0.0f);
                    if (!Config.firstPersonAnimationsEnabled) {
                        float targetYaw;
                        float randomPitch = 0.0f;
                        float randomYaw = 0.0f;
                        float targetBobbing = 1.0f;
                        if (player.isSprinting()) {
                            targetYaw = 10.0f;
                            targetBobbing = gunItem.getBobbing();
                        } else if (gunClientState.isAiming()) {
                            targetBobbing = gunItem.getBobbingOnAim();
                            float afc = AimingFeature.getViewBobbing(heldItem);
                            targetYaw = 5.0f * afc;
                            targetBobbing *= afc;
                        } else {
                            targetBobbing = gunItem.getBobbing();
                            targetYaw = 5.0f;
                        }
                        float bobbingRoll = (bobbing *= this.bobbingValue.update(targetBobbing)) * 10.0f * gunItem.getBobbingRollMultiplier();
                        float bobbingPitch = bobbing * 5.0f;
                        float bobbingYaw = bobbing * this.bobbingYawValue.update(targetYaw);
                        poseStack.translate((double)(-Mth.sin((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f), (double)Math.abs(Mth.cos((float)(walkDistance * (float)Math.PI)) * bobbing) * 0.35 + (double)(randomPitch * 0.01f), (double)(randomYaw * 0.0f));
                        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(walkDistance * (float)Math.PI)) * bobbingRoll));
                        poseStack.mulPose(Axis.XP.rotationDegrees(Math.abs(Mth.cos((float)(walkDistance * (float)Math.PI - 0.2f))) * bobbingPitch));
                        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(walkDistance * (float)Math.PI)) * bobbingYaw));
                    }
                }
                if (Config.firstPersonAnimationsEnabled) {
                    player = ClientUtil.getClientPlayer();
                    this.handlePlayerFirstPersonMovement(player, player.getMainHandItem());
                }
                if ((randomizerController = (GunRandomizingAnimationController)gunClientState.getAnimationController("randomizer")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        randomizerController.reset();
                    }
                    double posX = randomizerController.getPosX();
                    double posY = randomizerController.getPosY();
                    double posZ = randomizerController.getPosZ();
                    double roll = randomizerController.getRoll();
                    double yaw = randomizerController.getYaw();
                    double pitch = randomizerController.getPitch();
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.translate(posX, posY, posZ);
                    poseStack.mulPose(q);
                }
                if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        recoilController.reset();
                    }
                    double posX = recoilController.getPosX();
                    double posY = recoilController.getPosY();
                    double posZ = recoilController.getPosZ();
                    double roll = recoilController.getRoll();
                    double pitch = recoilController.getPitch();
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, 0.0, roll, 1.0);
                    poseStack.translate(posX, posY, posZ);
                    poseStack.mulPose(q);
                }
                if (this.jumpController != null) {
                    double jumpMultiplier = gunItem.getJumpMultiplier();
                    double posX = this.jumpController.getPosX() * jumpMultiplier;
                    double posY = this.jumpController.getPosY() * jumpMultiplier;
                    double posZ = this.jumpController.getPosZ() * jumpMultiplier;
                    double roll = this.jumpController.getRoll() * jumpMultiplier;
                    double pitch = this.jumpController.getPitch() * jumpMultiplier;
                    double yaw = this.jumpController.getYaw() * jumpMultiplier;
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.translate(posX, posY, posZ);
                    poseStack.mulPose(q);
                }
                if (this.inertiaController != null) {
                    double roll = this.inertiaController.getRoll();
                    double yaw = 0.0;
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(0.0, yaw, roll, 1.0);
                    poseStack.mulPose(q);
                }
            }
        }
    }

    private void handlePlayerFirstPersonMovement(Player player, ItemStack itemStack) {
        this.firstPersonWalkingAnimationHandler.handlePlayerFirstPersonMovement(player, itemStack);
    }

    @SubscribeEvent2
    public void onClickEvent(InputEvent.InteractionKeyMappingTriggered event) {
        Player player = event.getPlayer();
        if (player == null && Platform.getInstance().isClientThread()) {
            player = ClientUtil.getClientPlayer();
        }
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem() instanceof ItemExtra) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent2
    public void onPreRenderHandEvent(RenderHandsEvent.Pre event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        Item item;
        ItemStack itemStack = GunItem.getMainHeldGunItemStack((LivingEntity)ClientUtil.getClientPlayer());
        if (itemStack != null && (item = itemStack.getItem()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)item).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            PoseStack poseStack = event.getPoseStack();
            if (cameraBone.getRotY() != 0.0f) {
                poseStack.mulPose(Axis.YP.rotation(-cameraBone.getRotY()));
            }
            if (cameraBone.getRotX() != 0.0f) {
                poseStack.mulPose(Axis.XP.rotation(-cameraBone.getRotX()));
            }
            if (cameraBone.getRotZ() != 0.0f) {
                poseStack.mulPose(Axis.ZP.rotation(-cameraBone.getRotZ()));
            }
        }
    }

    @SubscribeEvent2
    public void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        ItemStack itemStack;
        Item roll2;
        Minecraft mc = Minecraft.getInstance();
        if (!mc.options.getCameraType().isFirstPerson()) {
            return;
        }
        GunClientState state = GunClientState.getMainHeldState();
        if (state != null) {
            TimerController reloadTimer;
            PryAnimationController shakeAnimationController = (PryAnimationController)state.getAnimationController("shake");
            if (shakeAnimationController != null) {
                float yawModifier = state.isAiming() ? 0.1f : 1.0f;
                float rollModifier = state.isAiming() ? 1.5f : 1.0f;
                event.setRoll(event.getRoll() + (float)shakeAnimationController.getRoll() * rollModifier);
                event.setYaw(event.getYaw() + (float)shakeAnimationController.getYaw() * yawModifier);
            }
            if ((reloadTimer = (TimerController)state.getAnimationController("reloadTimer")) != null && !reloadTimer.isDone()) {
                for (AbstractProceduralAnimationController activeHandler : reloadTimer.getActiveHandlers(ClientUtil.getClientPlayer(), state, ClientUtil.getClientPlayer().getMainHandItem())) {
                    event.setRoll(event.getRoll() + (float)activeHandler.getRoll());
                    event.setPitch(event.getPitch() + (float)activeHandler.getPitch());
                }
            }
            if (this.sharedViewShakeController != null) {
                event.setRoll(event.getRoll() + (float)this.sharedViewShakeController.getRoll() * 0.5f);
            }
            if (this.inertiaController != null) {
                double roll2 = this.inertiaController.getYaw();
                double yaw = this.inertiaController.getYaw();
                event.setRoll(event.getRoll() + (float)roll2 * 15.0f);
                event.setYaw(event.getYaw() + (float)yaw * 15.0f);
            }
        }
        if ((roll2 = (itemStack = ClientUtil.getClientPlayer().getMainHandItem()).getItem()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)roll2).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            event.setPitch(event.getPitch() - cameraBone.getRotX() * 57.295776f);
            event.setYaw(event.getYaw() - cameraBone.getRotY() * 57.295776f);
            event.setRoll(event.getRoll() - cameraBone.getRotZ() * 57.295776f);
        }
    }

    @SubscribeEvent2
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        ItemStack itemStack = minecraft.player.getMainHandItem();
        if (!(itemStack.getItem() instanceof GunItem)) {
            return;
        }
        if (event.isHotbarType() && minecraft.screen instanceof AttachmentManagerScreen) {
            event.setCanceled(true);
            return;
        }
        if (!minecraft.options.getCameraType().isFirstPerson()) {
            return;
        }
        int activeSlot = minecraft.player.getInventory().selected;
        GunClientState gunClientState = GunClientState.getState((Player)minecraft.player, itemStack, activeSlot, false);
        if (gunClientState == null) {
            return;
        }
        GunItem item = (GunItem)itemStack.getItem();
        if (event.isCrosshairType()) {
            if (Config.crosshairType == Config.CrosshairType.DEFAULT && !gunClientState.isAiming() && (gunClientState.isFiring() || gunClientState.isIdle())) {
                int height;
                double scaleFactor;
                float crossHairExpansionRate = this.getCrosshairExpansionRatio((Player)minecraft.player, gunClientState);
                double originalAspectRatio = 1.0;
                int width = event.getWindow().getGuiScaledWidth();
                int renderWidth = (int)((double)width * (scaleFactor = 3.3));
                int renderHeight = (int)((double)renderWidth / originalAspectRatio);
                if (renderHeight > (height = event.getWindow().getGuiScaledHeight())) {
                    renderHeight = (int)((double)height * scaleFactor);
                    renderWidth = (int)((double)renderHeight * originalAspectRatio);
                }
                renderWidth = 80;
                renderHeight = 80;
                float posX = (float)(width - renderWidth) / 2.0f;
                float posY = (float)(height - renderHeight) / 2.0f;
                CrosshairRenderer.renderCrosshairOverlay3(event.getGuiGraphics(), event.getPartialTick(), crossHairOverlay, crossHairExpansionRate - 1.0f, posX, posY, renderWidth, renderHeight);
            }
            if (Config.crosshairType == Config.CrosshairType.DEFAULT || Config.crosshairType == Config.CrosshairType.DISABLED) {
                event.setCanceled(true);
            }
        }
        ResourceLocation scopeOverlay = item.getScopeOverlay();
        if (gunClientState.isAiming()) {
            boolean pipZoomEnabled = MiscUtil.isGreaterThanZero(gunClientState.getGunItem().getPipScopeZoom());
            if (scopeOverlay != null && !pipZoomEnabled) {
                event.setCanceled(true);
            }
            if (!pipZoomEnabled || !Config.pipScopesEnabled) {
                BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
                double aimingProgress = aimingController.getValue();
                if (aimingController != null && scopeOverlay != null && !gunClientState.isReloading()) {
                    this.renderTextureOverlay(item, gunClientState, event.getGuiGraphics(), event.getPartialTick(), item.getScopeOverlay(), event.getWindow().getGuiScaledWidth(), event.getWindow().getGuiScaledHeight(), (float)aimingProgress);
                }
            }
        }
    }

    protected void renderTextureOverlay(GunItem gunItem, GunClientState gunClientState, GuiGraphics guiGraphics, float partialTick, ResourceLocation textureLocation, int width, int height, float alpha) {
        GunRecoilAnimationController recoilController;
        double scaleFactor = 3.3;
        int renderWidth = (int)((double)width * scaleFactor);
        double originalAspectRatio = 1.0;
        int renderHeight = (int)((double)renderWidth / originalAspectRatio);
        if (renderHeight > height) {
            renderHeight = (int)((double)height * scaleFactor);
            renderWidth = (int)((double)renderHeight * originalAspectRatio);
        }
        float posX = (float)(width - renderWidth) / 2.0f;
        float posY = (float)(height - renderHeight) / 2.0f;
        if (this.scopeInertiaController != null) {
            double yaw = this.scopeInertiaController.getYaw();
            double pitch = this.scopeInertiaController.getPitch();
            posX = (float)((double)posX - yaw * 5000.0);
            posY = (float)((double)posY - pitch * 5000.0);
        }
        if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
            if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                recoilController.reset();
            }
            double posZ1 = recoilController.getPosZ();
            posY = (float)((double)posY + posZ1 * 50.0);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        RenderUtil.blit(guiGraphics, textureLocation, posX, posY, -90, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
        ResourceLocation targetLockOverlay = gunItem.getTargetLockOverlay();
        if (targetLockOverlay != null) {
            this.renderTargetLockOverlay(guiGraphics, partialTick, targetLockOverlay, posX, posY, renderWidth, renderHeight);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTargetLockOverlay(GuiGraphics guiGraphics, float partialTick, ResourceLocation targetLockonOverlay, float posX, float posY, int renderWidth, int renderHeight) {
        UpDownCounter lockCounter = this.lockableTarget.getLockCounter();
        float targetLockCount = Mth.lerp((float)partialTick, (float)lockCounter.getPreviousValue(), (float)lockCounter.getCurrentValue()) / (float)lockCounter.getMaxValue();
        float lockProgress2 = 1.0f - targetLockCount;
        float lockRatio = 0.2f;
        int halfLockWidth = (int)((float)renderWidth * lockRatio * 0.5f);
        int halfLockHeight = (int)((float)renderHeight * lockRatio * 0.5f);
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = (float)halfLockWidth * 0.4f * lockProgress2;
        float yOffset = (float)halfLockHeight * 0.4f * lockProgress2;
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 0.5f;
        float maxV = 0.5f;
        float posXStart = centerX - (float)halfLockWidth - xOffset;
        float posXEnd = centerX - xOffset;
        float posYStart = centerY - (float)halfLockHeight - yOffset;
        float posYEnd = centerY - yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        float posXStart2 = centerX + xOffset;
        float posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        float posYStart2 = centerY - (float)halfLockHeight - yOffset;
        float posYEnd2 = centerY - yOffset;
        float minU2 = 0.5f;
        float minV2 = 0.0f;
        float maxU2 = 1.0f;
        float maxV2 = 0.5f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX + xOffset;
        posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.5f;
        minV2 = 0.5f;
        maxU2 = 1.0f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX - (float)halfLockWidth - xOffset;
        posXEnd2 = centerX - xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.0f;
        minV2 = 0.5f;
        maxU2 = 0.5f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
    }

    private void setTriggerOff(LocalPlayer player) {
        ItemStack heldItem = player.getMainHandItem();
        Item item = heldItem.getItem();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.isSprinting()) {
                player.setSprinting(false);
            } else {
                gunItem.setTriggerOff((Player)player, heldItem);
            }
        } else {
            item = heldItem.getItem();
            if (item instanceof ThrowableItem) {
                ThrowableItem throwableItem = (ThrowableItem)item;
                throwableItem.setTriggerOff((Player)player, heldItem);
            }
        }
    }

    private void leftMouseDown() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        this.tryFire(player);
    }

    private void rightMouseButtonDown() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.isSprinting()) {
            player.setSprinting(false);
        }
        MiscUtil.getMainHeldGun((LivingEntity)player).ifPresent(item -> {
            if (item.isAimingEnabled()) {
                this.toggleAiming(player, true);
            }
        });
    }

    private void rightMouseButtonRelease() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        this.toggleAiming(player, false);
    }

    private void leftMouseButtonRelease() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        this.setTriggerOff(player);
    }

    public void tickMainHeldGun() {
        GunClientState state;
        Player player = ClientUtil.getClientPlayer();
        if (player != null && (state = GunClientState.getMainHeldState()) != null) {
            state.stateTick((LivingEntity)player, player.getMainHandItem(), true);
            this.scopeInertiaController.onUpdateState((LivingEntity)player, state);
            reticleInertiaController.onUpdateState((LivingEntity)player, state);
            this.inertiaController.onUpdateState((LivingEntity)player, state);
        }
    }

    public static void runSyncTick(Runnable runnable) {
        mainLoopLock.lock();
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Client sync tick failed: {}", (Throwable)e);
        }
        finally {
            if (mainLoopLock.isHeldByCurrentThread()) {
                mainLoopLock.unlock();
            }
        }
    }

    public static <T> T runSyncCompute(Supplier<T> resultSupplier) {
        T result;
        mainLoopLock.lock();
        try {
            result = resultSupplier.get();
        }
        catch (Exception e) {
            LOGGER.error("Run sync compute failed: {}", (Throwable)e);
            throw e;
        }
        finally {
            if (mainLoopLock.isHeldByCurrentThread()) {
                mainLoopLock.unlock();
            }
        }
        return result;
    }

    private boolean toggleAiming(LocalPlayer player, boolean isAiming) {
        int activeSlot;
        GunClientState gunClientState;
        boolean toggled = false;
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack != null && itemStack.getItem() instanceof GunItem && (gunClientState = GunClientState.getState((Player)player, itemStack, activeSlot = player.getInventory().selected, false)) != null) {
            toggled = gunClientState.isAiming() != isAiming;
            gunClientState.setAiming(isAiming);
            if (toggled) {
                Platform.getInstance().getNetworkService().sendToServer(new AimingChangeRequestPacket(gunClientState.getId(), activeSlot, isAiming));
            }
        }
        return toggled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryFire(LocalPlayer player) {
        Item item;
        boolean result = false;
        ItemStack heldItemStack = player.getMainHandItem();
        if (heldItemStack != null && (item = heldItemStack.getItem()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.getOffhandItem() != heldItemStack && gunItem.isEnabled()) {
                long minTargetLockTime = gunItem.getTargetLockTimeTicks();
                if (minTargetLockTime == 0L) return gunItem.tryFire((Player)player, heldItemStack, this.lockableTarget.getTargetEntity());
                if (!this.lockableTarget.getLockCounter().isAtMax()) return result;
                return gunItem.tryFire((Player)player, heldItemStack, this.lockableTarget.getTargetEntity());
            }
        }
        if (heldItemStack == null) return result;
        item = heldItemStack.getItem();
        if (!(item instanceof ThrowableItem)) return result;
        ThrowableItem throwableItem = (ThrowableItem)item;
        if (player.getOffhandItem() == heldItemStack) return result;
        if (!throwableItem.isEnabled()) return result;
        return throwableItem.tryThrow((Player)player, heldItemStack, this.lockableTarget.getTargetEntity());
    }

    @SubscribeEvent2
    public void onJump(LivingEvent.LivingJumpEvent event) {
        Level level = MiscUtil.getLevel((Entity)event.getEntity());
        if (level.isClientSide && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            ItemStack heldItem = player.getMainHandItem();
            if (player == ClientUtil.getClientPlayer() && heldItem.getItem() instanceof GunItem) {
                GunClientState state = GunClientState.getState(player, heldItem, this.currentInventorySlot, false);
                if (state != null) {
                    state.jump((LivingEntity)player, heldItem);
                }
                if (this.jumpController != null) {
                    this.jumpController.onJumping((LivingEntity)player, state, heldItem);
                }
            }
        }
    }

    @SubscribeEvent2
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        ClientTooltipComponent component;
        ItemStack itemStack = event.getItemStack();
        if (itemStack == null || !(itemStack.getItem() instanceof AttachmentHost)) {
            return;
        }
        event.setCanceled(true);
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics guiGraphics = event.getGraphics();
        List<ClientTooltipComponent> tooltipComponents = event.getComponents();
        int i = 0;
        int j = tooltipComponents.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clienttooltipcomponent : tooltipComponents) {
            int k = clienttooltipcomponent.getWidth(event.getFont());
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.getHeight();
        }
        int i2 = i;
        int j2 = j;
        Vector2ic vector2ic = event.getTooltipPositioner().positionTooltip(guiGraphics.guiWidth(), guiGraphics.guiHeight(), event.getX(), event.getY(), i2, j2);
        int l = vector2ic.x();
        int i1 = vector2ic.y();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        guiGraphics.drawManaged(() -> {
            int background = 0x50101010;
            int borderStart = 1342218495;
            int borderEnd = 0x50005077;
            if (!(mc.screen instanceof AttachmentManagerScreen)) {
                background = -267382768;
            }
            RenderUtil.renderTooltipBackground(guiGraphics, l, i1, i2, j2, 400, background, background, borderStart, borderEnd);
        });
        poseStack.translate(0.0f, 0.0f, 400.0f);
        int k1 = i1;
        for (int l1 = 0; l1 < tooltipComponents.size(); ++l1) {
            component = tooltipComponents.get(l1);
            component.renderText(event.getFont(), l, k1, poseStack.last().pose(), guiGraphics.bufferSource());
            k1 += component.getHeight() + (l1 == 0 ? 2 : 0);
        }
        k1 = i1;
        for (int k2 = 0; k2 < tooltipComponents.size(); ++k2) {
            component = tooltipComponents.get(k2);
            component.renderImage(event.getFont(), l, k1, guiGraphics);
            k1 += component.getHeight() + (k2 == 0 ? 2 : 0);
        }
        poseStack.popPose();
    }

    @SubscribeEvent2
    public void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof FeatureProvider) {
            AttachmentHost attachmentHost;
            Collection<Attachment> collection;
            FeatureProvider featureProvider = (FeatureProvider)item;
            List<Either<FormattedText, TooltipComponent>> elements = event.getTooltipElements();
            ArrayList<Object> components = new ArrayList<Object>();
            components.addAll(featureProvider.getDescriptionTooltipLines());
            components.addAll(featureProvider.getFeatureTooltipLines());
            if (item instanceof AttachmentHost && !(collection = (attachmentHost = (AttachmentHost)item).getCompatibleAttachments()).isEmpty()) {
                if (Screen.hasShiftDown()) {
                    components.addAll(attachmentHost.getCompatibleAttachmentTooltipLines(itemStack));
                } else {
                    components.add(Component.empty());
                    components.add(Component.translatable((String)"message.pointblank.holdShiftForCompatibleAttachments").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.DARK_AQUA));
                }
            }
            for (Component component : components) {
                elements.add((Either<FormattedText, TooltipComponent>)Either.left((Object)component));
            }
        }
    }

    private float getCrosshairExpansionRatio(Player player, GunClientState gunClientState) {
        float inaccuracy = 2.0f;
        float baseExpansion = 1.0f;
        float speedMultiplier = 4.0f * inaccuracy;
        float rotationMultiplier = 0.05f * inaccuracy;
        float sprintMultiplier = 1.5f * inaccuracy;
        float jumpMultiplier = 1.2f * inaccuracy;
        float sneakMultiplier = 0.8f;
        float crouchMultiplier = 0.7f;
        float fireMultiplier = 2.0f * inaccuracy;
        double horizontalSpeed = Mth.sqrt((float)((float)(this.playerDeltaX * this.playerDeltaX + this.playerDeltaY * this.playerDeltaY + this.playerDeltaZ * this.playerDeltaZ)));
        float expansionRatio = baseExpansion + (float)horizontalSpeed * speedMultiplier;
        if (player.isSprinting()) {
            expansionRatio *= sprintMultiplier;
        }
        if (!player.onGround()) {
            expansionRatio *= jumpMultiplier;
        }
        if (player.isVisuallyCrawling()) {
            expansionRatio *= sneakMultiplier;
        }
        if (player.isCrouching()) {
            expansionRatio *= crouchMultiplier;
        }
        float yawChangeRate = Math.abs(this.playerDeltaYRot);
        float pitchChangeRate = Math.abs(this.playerDeltaXRot);
        expansionRatio += yawChangeRate * rotationMultiplier;
        expansionRatio += pitchChangeRate * rotationMultiplier;
        if (gunClientState.getTotalUninterruptedShots() > 0) {
            expansionRatio *= fireMultiplier;
        }
        return Mth.clamp((float)this.crossHairExp.update(expansionRatio), (float)1.0f, (float)7.0f);
    }

    @SubscribeEvent2
    public void onRenderLevel(RenderLevelEvent.Pre event) {
        ClientSystem.getInstance().setInverseCameraMatrix(event.getInverseCameraMatrix());
    }

    private void openSettingsScreen() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            mc.setScreen((Screen)new SettingsScreen());
        }
    }

    private PipFeature getActivePipFeature(ItemStack itemStack) {
        Item item;
        ItemStack selectedStack;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack itemStack2 = selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        if (selectedStack != null && (item = selectedStack.getItem()) instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)item;
            return fp.getFeature(PipFeature.class);
        }
        return null;
    }

    static {
        RELOAD_KEY = LazyOptional.of(() -> new KeyMapping("key.pointblack.reload", InputConstants.Type.KEYSYM, 82, "key.categories.pointblank"));
        FIRE_MODE_KEY = LazyOptional.of(() -> new KeyMapping("key.pointblack.firemode", InputConstants.Type.KEYSYM, 66, "key.categories.pointblank"));
        INSPECT_KEY = LazyOptional.of(() -> new KeyMapping("key.pointblack.inspect", InputConstants.Type.KEYSYM, 73, "key.categories.pointblank"));
        ATTACHMENT_KEY = LazyOptional.of(() -> new KeyMapping("key.pointblack.attachments", InputConstants.Type.KEYSYM, 89, "key.categories.pointblank"));
        SCOPE_SWITCH_KEY = LazyOptional.of(() -> new KeyMapping("key.pointblack.scope_switch", InputConstants.Type.KEYSYM, 86, "key.categories.pointblank"));
        SETTINGS_KEY = LazyOptional.of(() -> Platform.getInstance().createKeyMappingWithModifier("key.pointblack.settings", 89, "key.categories.pointblank", KeyModifierType.ALT));
        SETTINGS_KEY_MODIFIER = KeyModifierType.ALT;
        mainLoopLock = new ReentrantLock();
        reticleInertiaController = new InertiaController(0.005, 0.05, 1.0);
        isPipFallbackZoomActive = false;
        postPassEffectController = new PostPassEffectController(2000L);
        crossHairOverlay = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"textures/gui/crosshair.png");
    }
}

