/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.VariableTypeInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConsolidator {
    private static final Map<Class<?>, Map<VariableTypeInfo, TypeInfo>> MAPPINGS = new IdentityHashMap();
    private static final boolean DEBUG = false;

    private TypeConsolidator() {
    }

    @NotNull
    public static Map<VariableTypeInfo, TypeInfo> getMapping(Class<?> type) {
        Map<VariableTypeInfo, TypeInfo> got = TypeConsolidator.getImpl(type);
        return got == null ? Collections.emptyMap() : got;
    }

    @NotNull
    public static TypeInfo consolidateOrNone(VariableTypeInfo variable, Map<VariableTypeInfo, TypeInfo> mapping) {
        return mapping.getOrDefault(variable, TypeInfo.NONE);
    }

    @NotNull
    public static TypeInfo[] consolidateAll(@NotNull @NotNull TypeInfo @NotNull [] original, @NotNull Map<VariableTypeInfo, TypeInfo> mapping) {
        int len = original.length;
        if (len == 0) {
            return original;
        }
        if (len == 1) {
            TypeInfo[] typeInfoArray;
            TypeInfo consolidated = original[0].consolidate(mapping);
            if (consolidated != original[0]) {
                TypeInfo[] typeInfoArray2 = new TypeInfo[1];
                typeInfoArray = typeInfoArray2;
                typeInfoArray2[0] = consolidated;
            } else {
                typeInfoArray = original;
            }
            return typeInfoArray;
        }
        TypeInfo[] consolidatedAll = null;
        for (int i = 0; i < len; ++i) {
            TypeInfo type = original[i];
            TypeInfo consolidated = type.consolidate(mapping);
            if (consolidated != type) {
                if (consolidatedAll == null) {
                    consolidatedAll = new TypeInfo[len];
                    System.arraycopy(original, 0, consolidatedAll, 0, i);
                }
                consolidatedAll[i] = consolidated;
                continue;
            }
            if (consolidatedAll == null) continue;
            consolidatedAll[i] = consolidated;
        }
        return consolidatedAll == null ? original : consolidatedAll;
    }

    @NotNull
    public static @NotNull List<@NotNull TypeInfo> consolidateAll(@NotNull @NotNull List<@NotNull TypeInfo> original, @NotNull Map<VariableTypeInfo, TypeInfo> mapping) {
        int len = original.size();
        if (len == 0) {
            return original;
        }
        if (len == 1) {
            TypeInfo consolidated = original.getFirst().consolidate(mapping);
            return consolidated != original.getFirst() ? List.of(consolidated) : original;
        }
        ArrayList<@NotNull TypeInfo> consolidatedAll = null;
        for (int i = 0; i < len; ++i) {
            TypeInfo type = original.get(i);
            TypeInfo consolidated = type.consolidate(mapping);
            if (consolidated != type) {
                if (consolidatedAll == null) {
                    consolidatedAll = new ArrayList<TypeInfo>(len);
                    consolidatedAll.addAll(original.subList(0, i));
                }
                consolidatedAll.set(i, consolidated);
                continue;
            }
            if (consolidatedAll == null) continue;
            consolidatedAll.set(i, consolidated);
        }
        return consolidatedAll == null ? original : consolidatedAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<VariableTypeInfo, TypeInfo> getImpl(Class<?> type) {
        if (type == null || type.isPrimitive() || type == Object.class) {
            return null;
        }
        Map<Class<?>, Map<VariableTypeInfo, TypeInfo>> map = MAPPINGS;
        synchronized (map) {
            return MAPPINGS.computeIfAbsent(type, TypeConsolidator::collect);
        }
    }

    @NotNull
    private static Map<VariableTypeInfo, TypeInfo> collect(Class<?> type) {
        IdentityHashMap<VariableTypeInfo, TypeInfo> mapping = new IdentityHashMap<VariableTypeInfo, TypeInfo>();
        Class<?> parent = type.getSuperclass();
        TypeConsolidator.extractSuperMapping(type.getGenericSuperclass(), mapping);
        for (Type genericInterface : type.getGenericInterfaces()) {
            TypeConsolidator.extractSuperMapping(genericInterface, mapping);
        }
        Map<VariableTypeInfo, TypeInfo> superMapping = TypeConsolidator.getImpl(parent);
        if (superMapping == null || superMapping.isEmpty()) {
            return TypeConsolidator.postMapping(mapping);
        }
        IdentityHashMap<VariableTypeInfo, TypeInfo> merged = new IdentityHashMap<VariableTypeInfo, TypeInfo>(superMapping);
        for (Map.Entry<VariableTypeInfo, TypeInfo> entry : merged.entrySet()) {
            entry.setValue(entry.getValue().consolidate(mapping));
        }
        merged.putAll(mapping);
        return TypeConsolidator.postMapping(merged);
    }

    private static void extractSuperMapping(Type superType, IdentityHashMap<VariableTypeInfo, TypeInfo> pushTo) {
        ParameterizedType parameterized;
        Type type;
        if (superType instanceof ParameterizedType && (type = (parameterized = (ParameterizedType)superType).getRawType()) instanceof Class) {
            Class parent = (Class)type;
            TypeVariable<Class<T>>[] params = parent.getTypeParameters();
            Type[] args = parameterized.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                pushTo.put(TypeInfo.of(params[i]), TypeInfo.of(args[i]));
            }
        }
    }

    private static Map<VariableTypeInfo, TypeInfo> postMapping(Map<VariableTypeInfo, TypeInfo> mapping) {
        switch (mapping.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<VariableTypeInfo, TypeInfo> entry = mapping.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(mapping);
    }
}

