/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.Deletable;
import java.util.ArrayList;
import java.util.Map;

public class NativeJavaMap
extends NativeJavaObject {
    public final Map map;
    public final TypeInfo mapKeyType;
    public final TypeInfo mapValueType;

    public NativeJavaMap(Context cx, Scriptable scope, Object jo, Map map, TypeInfo type) {
        super(scope, jo, type, cx);
        this.map = map;
        this.mapKeyType = type.param(0);
        this.mapValueType = type.param(1);
    }

    @Override
    public String getClassName() {
        return "JavaMap";
    }

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        if (this.map.containsKey(name)) {
            return true;
        }
        return super.has(cx, name, start);
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        if (this.map.containsKey(index)) {
            return true;
        }
        return super.has(cx, index, start);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        if (this.map.containsKey(name)) {
            return cx.javaToJS(this.map.get(cx.jsToJava(name, this.mapKeyType)), start, this.mapValueType);
        }
        return super.get(cx, name, start);
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        if (this.map.containsKey(index)) {
            return cx.javaToJS(this.map.get(cx.jsToJava(index, this.mapKeyType)), start, this.mapValueType);
        }
        return super.get(cx, index, start);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        this.map.put(name, cx.jsToJava(value, this.mapValueType));
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        this.map.put(index, cx.jsToJava(value, this.mapValueType));
    }

    @Override
    public Object[] getIds(Context cx) {
        ArrayList<Object> ids = new ArrayList<Object>(this.map.size());
        for (Object key : this.map.keySet()) {
            if (key instanceof Integer) {
                ids.add(key);
                continue;
            }
            ids.add(ScriptRuntime.toString(cx, key));
        }
        return ids.toArray();
    }

    @Override
    public void delete(Context cx, String name) {
        Deletable.deleteObject(this.map.remove(name));
    }

    @Override
    public void delete(Context cx, int index) {
        Deletable.deleteObject(this.map.remove(index));
    }

    @Override
    protected void initMembers(Context cx, Scriptable scope) {
        super.initMembers(cx, scope);
        this.addCustomFunction("hasOwnProperty", TypeInfo.BOOLEAN, this::hasOwnProperty, TypeInfo.STRING);
    }

    private boolean hasOwnProperty(Context cx, Object[] args) {
        return this.map.containsKey(ScriptRuntime.toString(cx, args[0]));
    }
}

