/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.data.worldgen;

import com.simibubi.create.infrastructure.worldgen.ConfigPlacementFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.antarcticgardens.cna.data.worldgen.CNAConfiguredFeatures;

public class CNAPlacedFeatures {
    public static final ResourceKey<PlacedFeature> THORIUM_ORE = CNAPlacedFeatures.key("thorium_ore");
    public static final ResourceKey<PlacedFeature> MAGNETITE_BLOCK = CNAPlacedFeatures.key("magnetite_block");

    public static void bootstrap(BootstrapContext<PlacedFeature> ctx) {
        HolderGetter featureLookup = ctx.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference thoriumOre = featureLookup.getOrThrow(CNAConfiguredFeatures.THORIUM_ORE);
        Holder.Reference magnetiteBlock = featureLookup.getOrThrow(CNAConfiguredFeatures.MAGNETITE_BLOCK);
        PlacementUtils.register(ctx, THORIUM_ORE, (Holder)thoriumOre, CNAPlacedFeatures.placement((PlacementModifier)CountPlacement.of((int)2), 20, 120));
        PlacementUtils.register(ctx, MAGNETITE_BLOCK, (Holder)magnetiteBlock, CNAPlacedFeatures.placement((PlacementModifier)CountPlacement.of((int)15), -20, 60));
    }

    private static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_new_age", (String)name));
    }

    public static List<PlacementModifier> placement(PlacementModifier frequency, int minHeight, int maxHeight) {
        return List.of(frequency, InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), ConfigPlacementFilter.INSTANCE);
    }
}

