/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.data;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.cna.content.energising.EnergiserBlock;
import org.antarcticgardens.cna.content.heat.heater.HeaterBlock;
import org.antarcticgardens.cna.content.heat.pipe.HeatPipeBlock;
import org.antarcticgardens.cna.content.heat.pump.HeatPumpBlock;
import org.antarcticgardens.cna.content.heat.stirling.StirlingEngineBlock;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlock;
import org.joml.Vector3f;

public class CNABlockStateGen {
    public static <P extends EnergiserBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> energiser() {
        return (c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().withExistingParent(c.getName(), p.modLoc("block/energiser"))).texture("all", "block/" + c.getName()));
    }

    public static <P extends ElectricalConnectorBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> electricalConnector() {
        return (c, p) -> {
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)c.get());
            ModelFile.ExistingModelFile inert = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/inert"));
            ModelFile.ExistingModelFile pull = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/pull"));
            builder.forAllStates(state -> {
                Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                ElectricalConnectorMode mode = (ElectricalConnectorMode)((Object)((Object)((Object)state.getValue(ElectricalConnectorBlock.MODE))));
                ConfiguredModel.Builder builder = ConfiguredModel.builder();
                return builder.modelFile((ModelFile)(switch (mode) {
                    default -> throw new MatchException(null, null);
                    case ElectricalConnectorMode.INERT -> inert;
                    case ElectricalConnectorMode.PULL -> pull;
                })).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
            });
        };
    }

    public static <P extends HeatPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> heatPipe() {
        return (c, p) -> {
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            ModelFile.ExistingModelFile center = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/center"));
            ModelFile.ExistingModelFile side = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/side"));
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)center).addModel()).end();
            for (Direction dir : Direction.values()) {
                Vector3f euler = new Vector3f();
                dir.getRotation().getEulerAnglesXYZ(euler);
                if (dir.getAxis().isHorizontal()) {
                    dir = dir.getOpposite();
                }
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationX((int)Math.round(Math.toDegrees(euler.x))).rotationY((int)Math.round(Math.toDegrees(euler.z))).addModel()).condition((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir), (Comparable[])new Boolean[]{true}).end();
            }
        };
    }

    public static <P extends HeatPumpBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> heatPump() {
        return (c, p) -> {
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            ModelFile.ExistingModelFile center = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/center"));
            ModelFile.ExistingModelFile centerUp = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/center_up"));
            ModelFile.ExistingModelFile centerDown = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/center_down"));
            ModelFile.ExistingModelFile front = p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/front"));
            ModelFile.ExistingModelFile side = p.models().getExistingFile(p.modLoc("block/heat_pipe/side"));
            for (Direction dir : Direction.values()) {
                Vector3f euler = new Vector3f();
                dir.getRotation().getEulerAnglesXYZ(euler);
                if (dir.getAxis().isHorizontal()) {
                    dir = dir.getOpposite();
                }
                int rotX = (int)Math.round(Math.toDegrees(euler.x));
                int rotY = (int)Math.round(Math.toDegrees(euler.z));
                if (dir == Direction.UP) {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)centerUp).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
                } else if (dir == Direction.DOWN) {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)centerDown).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
                } else {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)center).rotationY(rotY).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
                }
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)front).rotationX(rotX).rotationY(rotY).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationX(rotX).rotationY(rotY).addModel()).condition((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir), (Comparable[])new Boolean[]{true}).end();
            }
        };
    }

    public static <P extends HeaterBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> heater() {
        return (c, p) -> {
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)c.get());
            for (BlazeBurnerBlock.HeatLevel level : BlazeBurnerBlock.HeatLevel.values()) {
                String id = "block/" + c.getName() + "_top_" + level.ordinal();
                ModelBuilder model = ((BlockModelBuilder)p.models().withExistingParent(id, p.modLoc("block/" + c.getName()))).texture("top", id);
                builder.addModels(builder.partialState().with((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)level), new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            }
        };
    }

    public static <P extends ReactorRodBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> reactorRod() {
        return (c, p) -> {
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)c.get());
            ModelBuilder off = ((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_off", p.modLoc("block/" + c.getName()))).texture("all", p.modLoc("block/" + c.getName() + "_off"));
            ModelBuilder on = ((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_on", p.modLoc("block/" + c.getName()))).texture("all", p.modLoc("block/" + c.getName() + "_on"));
            builder.forAllStates(state -> {
                Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
                boolean lit = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
                return ConfiguredModel.builder().modelFile((ModelFile)(lit ? on : off)).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 180 : 0)).build();
            });
        };
    }

    public static <P extends StirlingEngineBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> stirlingEngine() {
        return (c, p) -> {
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)c.get());
            ModelFile.ExistingModelFile model = p.models().getExistingFile(p.modLoc("block/" + c.getName()));
            builder.forAllStates(state -> {
                Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(axis == Direction.Axis.Y ? 90 : 0).rotationY(axis == Direction.Axis.Z ? 0 : (axis == Direction.Axis.X ? 90 : 0)).build();
            });
        };
    }
}

