/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.rod;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.config.CommonConfig;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.nuclear.NuclearUtil;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlock;
import org.jetbrains.annotations.Nullable;

public class ReactorRodBlockEntity
extends BlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    int twoSeconds = 0;
    private boolean working;
    public float heat = 0.0f;
    public int fuel = 0;

    public ReactorRodBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.working = (Boolean)blockState.getValue((Property)ReactorRodBlock.ACTIVE);
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        CommonConfig common = CNAConfig.getCommon();
        double multiplier = (Double)common.overheatingMultiplier.get();
        if (multiplier > 0.0 && (double)this.heat > 16000.0 * multiplier) {
            this.heat = (float)((double)this.heat - (Double)common.nuclearReactorRodHeatLoss.get());
            this.setChanged();
            HeatBlockEntity.handleOverheat(this, () -> world.setBlock(pos, CNABlocks.CORIUM.getDefaultState(), 3));
        }
        ++this.twoSeconds;
        if (this.twoSeconds > 40) {
            ReactorRodBlockEntity.transferAroundRodOnly(this);
            this.working = (Boolean)state.getValue((Property)ReactorRodBlock.ACTIVE);
            this.twoSeconds = 0;
            if (this.working) {
                NuclearUtil.createRadiation(8, world, pos);
            }
        }
        if (this.fuel > 0) {
            --this.fuel;
            if (!this.working) {
                world.setBlock(pos, (BlockState)state.setValue((Property)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                this.working = true;
            }
            this.heat = (float)((double)this.heat + (Double)common.nuclearReactorRodHeat.get());
            this.setChanged();
        } else if (this.working) {
            world.setBlock(pos, (BlockState)state.setValue((Property)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.working = false;
            this.setChanged();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        return true;
    }

    static <T extends BlockEntity> void transferAroundRodOnly(T self) {
        if (self.getLevel() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            ReactorRodBlockEntity hbe;
            Direction value = Direction.values()[i];
            BlockEntity entity = self.getLevel().getBlockEntity(self.getBlockPos().relative(value));
            if (!(entity instanceof ReactorRodBlockEntity) || !(hbe = (ReactorRodBlockEntity)entity).canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
    }

    @Override
    public float maxHeat() {
        return 26000.0f;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.heat = tag.getFloat("heat");
        this.fuel = tag.getInt("fuel");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("heat", this.heat);
        tag.putInt("fuel", this.fuel);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.setChanged();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.setChanged();
    }
}

