/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.ButtonEntry;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightSliderWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class MidnightConfigScreen
extends Screen {
    public MidnightConfig instance;
    public final String translationPrefix;
    public final String modid;
    public final Screen parent;
    public MidnightConfigListWidget list;
    public TabManager tabManager = new TabManager(a -> {}, a -> {});
    public Map<String, Tab> tabs = new LinkedHashMap<String, Tab>();
    public Tab prevTab;
    public TabNavigationBar tabNavigation;
    public Button done;
    public double scrollProgress = 0.0;

    public MidnightConfigScreen(Screen parent, String modid) {
        super((Component)Component.translatable((String)(modid + ".midnightconfig.title")));
        this.parent = parent;
        this.modid = modid;
        this.translationPrefix = modid + ".midnightconfig.";
        this.instance = MidnightConfig.configInstances.get(modid);
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            if (Objects.equals(info.modid, modid)) {
                String tabId = info.entry != null ? info.entry.category() : info.comment.category();
                String name = this.translationPrefix + "category." + tabId;
                if (!I18n.exists((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    info.tab = new GridLayoutTab((Component)Component.translatable((String)name));
                    this.tabs.put(name, info.tab);
                } else {
                    info.tab = this.tabs.get(name);
                }
            }
        });
        this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(this.tabs.values().toArray(new Tab[0])).build();
        this.tabNavigation.selectTab(0, false);
        this.tabNavigation.arrangeElements();
        this.prevTab = this.tabManager.getCurrentTab();
    }

    public void tick() {
        super.tick();
        if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
            this.prevTab = this.tabManager.getCurrentTab();
            this.updateList();
            this.list.setScrollAmount(0.0);
        }
        this.scrollProgress = this.list.getScrollAmount();
        for (EntryInfo info : MidnightConfig.entries.values()) {
            if (!Objects.equals(this.modid, info.modid)) continue;
            info.updateFieldValue();
        }
        this.updateButtons();
        if (this.instance.reloadScreen) {
            this.updateList();
            this.instance.reloadScreen = false;
        }
    }

    public void updateButtons() {
        if (this.list == null) {
            return;
        }
        for (ButtonEntry entry : this.list.children()) {
            if (entry.buttons == null || entry.buttons.size() <= 1 || entry.info.field == null) continue;
            Optional.ofNullable(entry.buttons.get(0)).ifPresent(widget -> {
                if (widget.isFocused() || widget.isHovered()) {
                    widget.setTooltip(entry.info.getTooltip(true));
                }
            });
            AbstractWidget abstractWidget = entry.buttons.get(1);
            if (!(abstractWidget instanceof Button)) continue;
            Button button = (Button)abstractWidget;
            button.active = !Objects.equals(String.valueOf(entry.info.value), String.valueOf(entry.info.defaultValue)) && entry.info.conditionsMet;
        }
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        return this.tabNavigation.keyPressed(key) || super.keyPressed(key, scanCode, modifiers);
    }

    public void onClose() {
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            info.error = null;
            info.value = null;
            info.tempValue = null;
            info.actionButton = null;
            info.listIndex = 0;
            info.tab = null;
            info.inLimits = true;
        });
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void init() {
        super.init();
        this.tabNavigation.setWidth(this.width);
        this.tabNavigation.arrangeElements();
        if (this.tabs.size() > 1) {
            this.addRenderableWidget((GuiEventListener)this.tabNavigation);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
        this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            for (EntryInfo info : MidnightConfig.entries.values()) {
                if (!info.modid.equals(this.modid)) continue;
                info.updateFieldValue();
            }
            MidnightConfig.write(this.modid);
            this.onClose();
        }).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
        this.list = new MidnightConfigListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
        this.addWidget((GuiEventListener)this.list);
        this.updateList();
        if (this.tabs.size() > 1) {
            this.list.renderHeaderSeparator = false;
        }
    }

    public void updateList() {
        String string;
        this.list.clear();
        ComponentContents componentContents = this.prevTab.getTabTitle().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            string = translatable.getKey().substring(translatable.getKey().lastIndexOf(46) + 1);
        } else {
            string = this.prevTab.getTabTitle().toString();
        }
        this.instance.onTabInit(string, this.list, this);
        for (EntryInfo info : MidnightConfig.entries.values()) {
            info.updateConditions();
            if (!info.conditionsMet) {
                boolean visibleButLocked = false;
                for (MidnightConfig.Condition condition : info.conditions) {
                    visibleButLocked |= condition.visibleButLocked();
                }
                if (!visibleButLocked) continue;
            }
            if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.getCurrentTab())) {
                SpriteIconButton resetButton = SpriteIconButton.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                    info.value = info.defaultValue;
                    info.listIndex = 0;
                    info.tempValue = info.toTemporaryValue();
                    this.updateList();
                }, (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/reset"), 12, 12).size(20, 20).build();
                resetButton.setPosition(this.width - 205 + 150 + 25, 0);
                if (info.function != null) {
                    Object widget;
                    MidnightConfig.Entry e = info.entry;
                    if (info.function instanceof Map.Entry) {
                        Map.Entry values = (Map.Entry)info.function;
                        if (info.dataType.isEnum()) {
                            values.setValue(value -> this.instance.getEnumTranslatableText(value, info));
                        }
                        widget = Button.builder((Component)((Component)((Function)values.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)values.getKey())).bounds(this.width - 185, 0, 150, 20).tooltip(info.getTooltip(true)).build();
                    } else {
                        widget = e.isSlider() ? new MidnightSliderWidget(this.width - 185, 0, 150, 20, Component.nullToEmpty((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.font, this.width - 185, 0, 150, 20, (Component)Component.empty());
                    }
                    if (widget instanceof EditBox) {
                        EditBox textField = widget;
                        textField.setMaxLength(e.width());
                        textField.setValue(info.tempValue);
                        Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                        textField.setFilter(processor);
                    }
                    widget.setTooltip(info.getTooltip(true));
                    Button cycleButton = null;
                    if (info.field.getType() == List.class) {
                        cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.listIndex)).withStyle(ChatFormatting.GOLD), button -> {
                            List values = (List)info.value;
                            values.remove("");
                            info.listIndex = info.listIndex != values.size() ? info.listIndex + 1 : 0;
                            info.tempValue = info.listIndex != values.size() ? info.toTemporaryValue() : "";
                            this.updateList();
                        }).bounds(this.width - 185, 0, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"midnightconfig.action.list_index", (Object[])new Object[]{info.listIndex}))).build();
                    }
                    if (e.isColor()) {
                        Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> new Thread(() -> {
                            Color newColor = JColorChooser.showDialog(null, Component.translatable((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                            if (newColor != null) {
                                info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                this.updateList();
                            }
                        }).start()).bounds(this.width - 185, 0, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"midnightconfig.action.color_chooser"))).build();
                        try {
                            colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        info.actionButton = colorButton;
                    } else if (e.selectionMode() > -1) {
                        SpriteIconButton explorerButton = SpriteIconButton.builder((Component)Component.empty(), button -> new Thread(() -> {
                            JFileChooser fileChooser = new JFileChooser(info.tempValue);
                            fileChooser.setFileSelectionMode(e.selectionMode());
                            fileChooser.setDialogType(e.fileChooserType());
                            fileChooser.setDialogTitle(Component.translatable((String)(this.translationPrefix + info.fieldName + ".fileChooser")).getString());
                            if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                fileChooser.setFileFilter(new FileNameExtensionFilter(Component.translatable((String)(this.translationPrefix + info.fieldName + ".fileFilter")).getString(), e.fileExtensions()));
                            }
                            if (fileChooser.showDialog(null, null) == 0) {
                                info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                this.updateList();
                            }
                        }).start(), (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/explorer"), 12, 12).size(20, 20).build();
                        explorerButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"midnightconfig.action.file_chooser")));
                        explorerButton.setPosition(this.width - 185, 0);
                        info.actionButton = explorerButton;
                    }
                    ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{widget, resetButton});
                    if (info.actionButton != null) {
                        if (Util.getPlatform() == Util.OS.OSX) {
                            info.actionButton.active = false;
                        }
                        widget.setWidth(widget.getWidth() - 22);
                        widget.setX(widget.getX() + 22);
                        widgets.add(info.actionButton);
                    }
                    if (cycleButton != null) {
                        if (info.actionButton != null) {
                            info.actionButton.setX(info.actionButton.getX() + 22);
                        }
                        widget.setWidth(widget.getWidth() - 22);
                        widget.setX(widget.getX() + 22);
                        widgets.add(cycleButton);
                    }
                    if (!info.conditionsMet) {
                        widgets.forEach(w -> {
                            w.active = false;
                        });
                    }
                    this.list.addButton(widgets, (Component)Component.translatable((String)info.translationKey), info);
                } else {
                    this.list.addButton(List.of(), (Component)Component.translatable((String)info.translationKey), info);
                }
            }
            this.list.setScrollAmount(this.scrollProgress);
            this.updateButtons();
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.list.render(context, mouseX, mouseY, delta);
        if (this.tabs.size() < 2) {
            context.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
        }
    }
}

