/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.register;

import com.oierbravo.createsifter.ModConstants;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeSerializer;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"createsifter");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"createsifter");
    public static final Supplier<RecipeType<SiftingRecipe>> SIFTING_TYPE = RECIPE_TYPES.register("sifting_type", () -> RecipeType.simple((ResourceLocation)ModConstants.asResource("sifting_type")));
    public static final Supplier<SiftingRecipeSerializer> SIFTING_SERIALIZER = SERIALIZERS.register("sifting", () -> SiftingRecipeSerializer.INSTANCE);

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
        RECIPE_TYPES.register(eventBus);
    }

    public static interface ISiftingRecipeCacheKey {
        public String toString();

        public Ingredient getInput();

        public ItemStack getMesh();

        public boolean getWaterlogged();

        public boolean getAdvancedSifter();

        public List<IRecipeRequirement> getRecipeRequirements();
    }

    public record SiftingRecipeJEICacheKey(ItemStack mesh, Ingredient input, boolean waterlogged, boolean advancedSifter, List<IRecipeRequirement> recipeRequirements) implements ISiftingRecipeCacheKey
    {
        public SiftingRecipeJEICacheKey(SiftingRecipe recipe) {
            this(recipe.getMesh(), recipe.getInput(), recipe.isWaterlogged(), recipe.advancedSifter(), recipe.getRecipeRequirements());
        }

        @Override
        public String toString() {
            String name = this.input.toString() + "_" + String.valueOf(this.mesh.getItem());
            if (this.waterlogged) {
                name = name + "_waterlogged";
            }
            if (this.advancedSifter) {
                name = name + "_advanced";
            }
            return name.replace(":", "_");
        }

        @Override
        public Ingredient getInput() {
            return this.input;
        }

        @Override
        public ItemStack getMesh() {
            return this.mesh;
        }

        @Override
        public boolean getWaterlogged() {
            return this.waterlogged;
        }

        @Override
        public boolean getAdvancedSifter() {
            return this.advancedSifter;
        }

        @Override
        public List<IRecipeRequirement> getRecipeRequirements() {
            return this.recipeRequirements;
        }
    }
}

