/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.recipe;

import com.google.common.collect.ArrayListMultimap;
import com.oierbravo.createsifter.ModConstants;
import com.oierbravo.createsifter.content.contraptions.components.sifter.AbstractSifterBlockEntity;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeInput;
import com.oierbravo.createsifter.register.ModRecipes;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.utility.MechanicalItemStackUtils;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SiftingRecipeManager {
    public static Optional<SiftingRecipe> getRecipeForSifter(AbstractSifterBlockEntity sifter) {
        List<RecipeHolder<SiftingRecipe>> ingredientMatchingRecipes = SiftingRecipeManager.getRecipesMatchingIngredients(SiftingRecipeInput.fromSifter(sifter), sifter.getLevel());
        List<RecipeHolder> matchingRecipes = ingredientMatchingRecipes.stream().filter(siftingRecipeRecipeHolder -> ((SiftingRecipe)siftingRecipeRecipeHolder.value()).isWaterlogged() == sifter.isWaterlogged()).toList();
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SiftingRecipeManager.mergeRecipes(matchingRecipes.stream().map(RecipeHolder::value).toList()));
    }

    public static Optional<SiftingRecipe> getRecipeForHandSifting(Level level, SiftingRecipeInput input, boolean waterlogged) {
        List<RecipeHolder<SiftingRecipe>> ingredientMatchingRecipes = SiftingRecipeManager.getRecipesMatchingIngredients(input, level);
        List<RecipeHolder> matchingRecipes = ingredientMatchingRecipes.stream().filter(siftingRecipeRecipeHolder -> ((SiftingRecipe)siftingRecipeRecipeHolder.value()).isWaterlogged() == waterlogged).toList();
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SiftingRecipeManager.mergeRecipes(matchingRecipes.stream().map(RecipeHolder::value).toList()));
    }

    public static List<RecipeHolder<SiftingRecipe>> getRecipesMatchingIngredients(SiftingRecipeInput input, Level level) {
        assert (level != null);
        return level.getRecipeManager().getRecipesFor((RecipeType)SiftingRecipe.Type.INSTANCE, (RecipeInput)input, level);
    }

    public static SiftingRecipe mergeRecipes(List<SiftingRecipe> siftingRecipes) {
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder();
        for (SiftingRecipe siftingRecipeHolder : siftingRecipes) {
            builder.require(siftingRecipeHolder.getInput()).requiredMesh(siftingRecipeHolder.getMesh()).output((List<ProcessingOutput>)siftingRecipeHolder.getResults()).processingTime(siftingRecipeHolder.getProcessingTime()).waterlogged(siftingRecipeHolder.isWaterlogged()).requiresAdvancedSifter(siftingRecipeHolder.advancedSifter());
            for (IRecipeRequirement recipeRequirement : siftingRecipeHolder.getRecipeRequirements()) {
                if (builder.hasRequirement(recipeRequirement.getType())) continue;
                builder.withRequirement(recipeRequirement);
            }
        }
        return builder.build();
    }

    public static List<RecipeHolder<SiftingRecipe>> getAllHolders() {
        return Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager().getAllRecipesFor((RecipeType)SiftingRecipe.Type.INSTANCE);
    }

    public static ArrayListMultimap<Ingredient, SiftingRecipe> getRecipesGroupedByIngredient() {
        ArrayListMultimap groupedRecipes = ArrayListMultimap.create();
        SiftingRecipeManager.getAllHolders().stream().map(RecipeHolder::value).forEach(siftingRecipe -> {
            ModRecipes.SiftingRecipeJEICacheKey key = new ModRecipes.SiftingRecipeJEICacheKey((SiftingRecipe)((Object)siftingRecipe));
            groupedRecipes.put((Object)siftingRecipe.getInput(), (Object)siftingRecipe);
        });
        return groupedRecipes;
    }

    public static List<RecipeHolder<SiftingRecipe>> getRecipesMerged() {
        ArrayListMultimap<Ingredient, SiftingRecipe> groupedRecipes = SiftingRecipeManager.getRecipesGroupedByIngredient();
        ArrayList<RecipeHolder<SiftingRecipe>> mergedRecipes = new ArrayList<RecipeHolder<SiftingRecipe>>(List.of());
        for (Ingredient key : groupedRecipes.keySet()) {
            ArrayListMultimap groupedMeshes = ArrayListMultimap.create();
            List recipes = groupedRecipes.get((Object)key);
            recipes.forEach(siftingRecipe -> groupedMeshes.put((Object)siftingRecipe.getMesh().getItem(), (Object)siftingRecipe));
            for (Item mesh : groupedMeshes.keySet()) {
                List<SiftingRecipe> waterloggedRecipes;
                List meshRecipes = groupedMeshes.get((Object)mesh);
                List<SiftingRecipe> baseRecipes = meshRecipes.stream().filter(SiftingRecipe::isNotWaterlogged).toList();
                if (!baseRecipes.isEmpty()) {
                    mergedRecipes.add(SiftingRecipeManager.mergeJEIRecipes("merged", baseRecipes));
                }
                if ((waterloggedRecipes = meshRecipes.stream().filter(SiftingRecipe::isWaterlogged).toList()).isEmpty()) continue;
                mergedRecipes.add(SiftingRecipeManager.mergeJEIRecipes("merged_waterlogged", waterloggedRecipes));
            }
        }
        return mergedRecipes;
    }

    public static RecipeHolder<SiftingRecipe> mergeJEIRecipes(String id, List<SiftingRecipe> recipes) {
        if (recipes.isEmpty()) {
            return null;
        }
        SiftingRecipeManager.mergeRecipes(recipes);
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder();
        recipes.forEach(siftingRecipe -> {
            builder.output((List<ProcessingOutput>)siftingRecipe.getResults()).requiresAdvancedSifter(siftingRecipe.advancedSifter()).waterlogged(siftingRecipe.isWaterlogged()).requiredMesh(siftingRecipe.getMesh()).require(siftingRecipe.getInput());
            if (!siftingRecipe.getJeiRecipeRequirements().isEmpty()) {
                builder.withRequirements(siftingRecipe.getRecipeRequirements());
            }
        });
        SiftingRecipe resultRecipe = builder.build();
        return new RecipeHolder(SiftingRecipeManager.generateResourceLocation(resultRecipe, id), (Recipe)resultRecipe);
    }

    private static ResourceLocation generateResourceLocation(SiftingRecipe siftingRecipe, String suffix) {
        String meshPath = MechanicalItemStackUtils.getResorceLocation((ItemStack)siftingRecipe.getMesh()).getPath();
        String inputPath = MechanicalItemStackUtils.getResorceLocation((Ingredient)siftingRecipe.getInput()).getPath();
        return ModConstants.asResource().withPath(meshPath + "_" + inputPath + "_" + suffix);
    }
}

