/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.jei.category.animations;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.material.Fluids;

public abstract class AbstractAnimatedSifter<SIFTER extends KineticBlock>
extends AnimatedKinetics {
    private boolean isWaterlogged = false;

    public AbstractAnimatedSifter<SIFTER> waterlogged(boolean value) {
        this.isWaterlogged = value;
        return this;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 0.0f);
        AllGuiTextures.JEI_SHADOW.render(guiGraphics, -16, 13);
        matrixStack.translate(-2.0f, 18.0f, 0.0f);
        int scale = 22;
        this.blockElement(this.getCogModel()).atLocal(0.0, 0.1, 0.0).rotateBlock(22.5, (double)(AbstractAnimatedSifter.getCurrentAngle() * 2.0f), 0.0).scale((double)scale).render(guiGraphics);
        this.blockElement(this.getSifterBlock().getDefaultState()).atLocal(0.0, 0.1, 0.0).rotateBlock(22.5, 22.5, 0.0).scale((double)scale).render(guiGraphics);
        this.blockElement(this.getMeshModel()).atLocal(0.0, -1.0, 0.0).rotateBlock(22.5, 22.5, 0.0).scale((double)scale).render(guiGraphics);
        if (this.isWaterlogged) {
            this.renderWaterlogged(guiGraphics);
        }
        matrixStack.popPose();
    }

    private void renderWaterlogged(GuiGraphics guiGraphics) {
        AnimatedKinetics.DEFAULT_LIGHTING.applyLighting();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        UIRenderHelper.flipForGuiRender((PoseStack)matrixStack);
        matrixStack.scale(22.0f, 18.0f, 22.0f);
        matrixStack.translate(-0.3, -0.1, 0.0);
        float from = 0.0625f;
        float to = 1.125f;
        matrixStack.mulPose(Axis.XP.rotationDegrees(22.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        float xMin = 0.125f;
        float xMax = 0.125f;
        float yMin = 0.125f;
        float yMax = 0.875f;
        float zMin = 0.125f;
        float zMax = 0.875f;
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox(Fluids.WATER.defaultFluidState(), from, from, from, to, to, to, (MultiBufferSource)guiGraphics.bufferSource(), matrixStack, 0xF000F0, false, true);
        guiGraphics.flush();
        Lighting.setupFor3DItems();
        matrixStack.popPose();
    }

    abstract PartialModel getMeshModel();

    abstract PartialModel getCogModel();

    abstract BlockEntry<SIFTER> getSifterBlock();
}

