/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.infrastructure.worldgen;

import com.simibubi.create.infrastructure.worldgen.ConfigPlacementFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.infrastructure.worldgen.CNConfiguredFeatures;

public class CNPlacedFeatures {
    public static final ResourceKey<PlacedFeature> URANIUM_ORE = CNPlacedFeatures.key("uranium_ore");
    public static final ResourceKey<PlacedFeature> LEAD_ORE = CNPlacedFeatures.key("lead_ore");
    public static final ResourceKey<PlacedFeature> STRIATED_ORES_OVERWORLD = CNPlacedFeatures.key("striated_ores_overworld");

    private static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)CreateNuclear.asResource(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> ctx) {
        HolderGetter featureLookup = ctx.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference uraniumOre = featureLookup.getOrThrow(CNConfiguredFeatures.URANIUM_ORE);
        Holder.Reference leadOre = featureLookup.getOrThrow(CNConfiguredFeatures.LEAD_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.getOrThrow(CNConfiguredFeatures.STRIATED_ORES_OVERWORLD);
        PlacementUtils.register(ctx, URANIUM_ORE, (Holder)uraniumOre, CNPlacedFeatures.placementOres((PlacementModifier)CountPlacement.of((int)6), -64, 64));
        PlacementUtils.register(ctx, LEAD_ORE, (Holder)leadOre, CNPlacedFeatures.placementOres((PlacementModifier)CountPlacement.of((int)6), -64, 64));
        PlacementUtils.register(ctx, STRIATED_ORES_OVERWORLD, (Holder)striatedOresOverworld, CNPlacedFeatures.placement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)18), -30, 70));
    }

    private static List<PlacementModifier> placementOres(PlacementModifier frequency, int minHeight, int maxHeight) {
        return List.of(frequency, InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), ConfigPlacementFilter.INSTANCE);
    }

    private static List<PlacementModifier> placement(PlacementModifier frequency, int minHeight, int maxHeight) {
        return List.of(frequency, InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), ConfigPlacementFilter.INSTANCE);
    }
}

