/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.events.overlay;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.foundation.events.overlay.HudOverlay;
import net.nuclearteam.createnuclear.foundation.events.overlay.RadiationOverlay;
import net.nuclearteam.createnuclear.foundation.utility.RenderHelper;

public class HelmetOverlay
implements HudOverlay {
    private static final ResourceLocation[] HELMET_TEXTURES = new ResourceLocation[]{CreateNuclear.asResource("textures/misc/helmet_vision/helmet_new.png"), CreateNuclear.asResource("textures/misc/helmet_vision/helmet_minor_damage.png"), CreateNuclear.asResource("textures/misc/helmet_vision/helmet_crack1.png"), CreateNuclear.asResource("textures/misc/helmet_vision/helmet_crack2.png"), CreateNuclear.asResource("textures/misc/helmet_vision/helmet_almost_broken.png")};
    private static final float[] COVERAGE_FACTORS = new float[]{0.5f, 1.0f, 1.05f, 1.45f, 1.98f};
    private static final int BASE_PRIORITY = 50;

    @Override
    public ResourceLocation getAfterOverlay() {
        return VanillaGuiLayers.CAMERA_OVERLAYS;
    }

    @Override
    public ResourceLocation getOverlayId() {
        return ResourceLocation.parse((String)"helmet_overlay");
    }

    @Override
    public boolean isActive() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        ItemStack helmet = player.getInventory().getArmor(EquipmentSlot.HEAD.getIndex());
        return !helmet.isEmpty() && helmet.is(CNTags.CNItemTags.ANTI_RADIATION_HELMET_FULL_DYE.tag);
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.isActive()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.getInventory().getArmor(EquipmentSlot.HEAD.getIndex());
        if (helmet.isEmpty()) {
            return;
        }
        float durabilityRatio = (float)(helmet.getMaxDamage() - helmet.getDamageValue()) / (float)helmet.getMaxDamage();
        int index = durabilityRatio >= 0.95f ? 0 : (durabilityRatio >= 0.8f ? 1 : (durabilityRatio >= 0.6f ? 2 : (durabilityRatio >= 0.25f ? 3 : 4)));
        RadiationOverlay.setCoverage(COVERAGE_FACTORS[index]);
        RenderHelper.renderFirstPersonOverlay(guiGraphics, HELMET_TEXTURES[index], 1.0f, 1.0f);
    }

    @Override
    public int getPriority() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 50;
        }
        ItemStack helmet = player.getInventory().getArmor(EquipmentSlot.HEAD.getIndex());
        if (helmet.isEmpty()) {
            return 50;
        }
        float durabilityRatio = (float)(helmet.getMaxDamage() - helmet.getDamageValue()) / (float)helmet.getMaxDamage();
        return 50 + (int)((1.0f - durabilityRatio) * 100.0f);
    }

    @Override
    public LayeredDraw.Layer getOverlay() {
        return this::render;
    }
}

