/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.events.overlay;

import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.foundation.events.overlay.HudOverlay;

public class EventTextOverlay
implements HudOverlay {
    private static int timer = 0;

    public static void triggerEvent(int displayDuration) {
        timer = displayDuration;
    }

    @Override
    public ResourceLocation getAfterOverlay() {
        return VanillaGuiLayers.CAMERA_OVERLAYS;
    }

    @Override
    public ResourceLocation getOverlayId() {
        return ResourceLocation.parse((String)"event_text_overlay");
    }

    @Override
    public boolean isActive() {
        if (timer > 0) {
            // empty if block
        }
        return false;
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.isActive()) {
            return;
        }
        if (timer-- <= 0) {
            return;
        }
        CreateNuclear.LOGGER.warn("hum EventTextOverlay: {}", (Object)timer);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        MutableComponent text = Component.translatable((String)"overlay.event_message", (Object[])new Object[]{timer}).withStyle(ChatFormatting.RED);
        int widths = guiGraphics.guiWidth();
        int x = (widths - Minecraft.getInstance().font.width((FormattedText)text)) / 2;
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)text, x, 10, 0xFFFFFF);
    }

    @Override
    public int getPriority() {
        return 300;
    }

    @Override
    public LayeredDraw.Layer getOverlay() {
        return this::render;
    }
}

