/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.advancement;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNFluids;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.foundation.advancement.CreateNuclearAdvancement;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CNAdvancement
implements DataProvider {
    public static final List<CreateNuclearAdvancement> ENTRIES = new ArrayList<CreateNuclearAdvancement>();
    public static final CreateNuclearAdvancement START = null;
    public static final CreateNuclearAdvancement ROOT = CNAdvancement.create("root", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.URANIUM_POWDER).title("Starting The Nuclear Journey").description("Unlock the basics of nuclear energy and get your first uranium powder").awardedForFree().special(CreateNuclearAdvancement.TaskType.SILENT));
    public static final CreateNuclearAdvancement RAW_URANIUM = CNAdvancement.create("raw_uranium", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.RAW_URANIUM).title("The Raw Power").description("Mine uranium ore to obtain raw uranium for further processing").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_POWDER = CNAdvancement.create("uranium_powder", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.URANIUM_POWDER).title("Powdered Uranium").description("Crush raw uranium into powder to prepare for further refining").after(RAW_URANIUM).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_LIQUID = CNAdvancement.create("uranium_liquid", b -> b.icon((ItemLike)CNFluids.URANIUM.getBucket().get()).title("Turning Solid To Liquid").description("Obtain some uranium liquid by mixing uranium powder").after(URANIUM_POWDER).whenIconCollected());
    public static final CreateNuclearAdvancement YELLOWCAKE = CNAdvancement.create("yellowcake", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.YELLOWCAKE).title("The Yellowcake Process").description("Compact uranium liquid to create yellowcake").after(URANIUM_LIQUID).whenIconCollected());
    public static final CreateNuclearAdvancement ENRICHED_YELLOWCAKE = CNAdvancement.create("enriched_yellowcake", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.ENRICHED_YELLOWCAKE).title("Enhancing Yellowcake").description("Use a fan to enrich yellowcake and make it more powerful").after(YELLOWCAKE).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_ROD = CNAdvancement.create("uranium_rod", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.URANIUM_ROD).title("The Power Of The Atom").description("Create your first uranium rod using enriched yellowcake in a mechanical crafter").after(ENRICHED_YELLOWCAKE).whenIconCollected());
    public static final CreateNuclearAdvancement COAL_DUST = CNAdvancement.create("coal_dust", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.COAL_DUST).title("Coal Dust").description("Crush coal or charcoal to obtain coal dust, a key crafting material").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement STEEL_INGOT = CNAdvancement.create("steel_ingot", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.STEEL_INGOT).title("Steel Ingot").description("Combine coal dust and iron ingots to create steel ingots").after(COAL_DUST).whenIconCollected());
    public static final CreateNuclearAdvancement GRAPHENE = CNAdvancement.create("graphene", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.GRAPHENE).title("Graphene").description("Press coal dust to create graphene").after(COAL_DUST).whenIconCollected());
    public static final CreateNuclearAdvancement GRAPHITE_ROD = CNAdvancement.create("graphite_rod", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.GRAPHITE_ROD).title("Don't Forget Those Ones").description("Combine graphene and steel ingots in a mechanical crafter to make graphite rods").after(GRAPHENE).whenIconCollected());
    public static final CreateNuclearAdvancement RAW_LEAD = CNAdvancement.create("raw_lead", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.RAW_LEAD).title("Raw Lead").description("Obtain some raw lead by mining lead ore").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement LEAD_INGOT = CNAdvancement.create("lead_ingot", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.LEAD_INGOT).title("Lead ingot").description("Smelt a raw lead to obtain a lead ingot").after(RAW_LEAD).whenIconCollected());
    public static final CreateNuclearAdvancement REINFORCED_GLASS = CNAdvancement.create("reinforced_glass", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REINFORCED_GLASS).title("Reinforced Glass").description("Craft some reinforced glass for the first time").after(LEAD_INGOT).whenIconCollected());
    public static final CreateNuclearAdvancement ANTI_RADIATION_ARMOR = CNAdvancement.create("anti_radiation_armor", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.ANTI_RADIATION_HELMETS.get(DyeColor.WHITE)).title("Anti radiation Armor").description("Craft your first anti-radiation armor piece to protect yourself from radiation").after(LEAD_INGOT).whenItemCollected(CNTags.CNItemTags.ALL_ANTI_RADIATION_ARMORS.tag));
    public static final CreateNuclearAdvancement FULL_ANTI_RADIATION_ARMOR = CNAdvancement.create("full_anti_radiation_armor", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.ANTI_RADIATION_CHESTPLATES.get(DyeColor.WHITE)).title("Fully Protected").description("Wear a full set of anti-radiation armor to fully protect yourself from radiation").after(ANTI_RADIATION_ARMOR));
    public static final CreateNuclearAdvancement DYE_ANTI_RADIATION_ARMOR = CNAdvancement.create("dye_anti_radiation_armor", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.ANTI_RADIATION_HELMETS.get(DyeColor.RED)).title("Pimp My Armor").description("Dye your anti radiation armor to any color").whenItemCollected(CNTags.CNItemTags.ANTI_RADIATION_HELMET_DYE.tag).whenItemCollected(CNTags.CNItemTags.ANTI_RADIATION_CHESTPLATE_DYE.tag).whenItemCollected(CNTags.CNItemTags.ANTI_RADIATION_LEGGINGS_DYE.tag).after(ANTI_RADIATION_ARMOR));
    public static final CreateNuclearAdvancement AUTOMATIC_URANIUM = CNAdvancement.create("automatic_uranium", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.URANIUM_POWDER).title("Automating Uranium").description("Obtain some uranium powder using the automatic uranium processing").after(ROOT).special(CreateNuclearAdvancement.TaskType.SECRET));
    public static final CreateNuclearAdvancement REACTOR_CASING = CNAdvancement.create("reactor_casing", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_CASING).title("The Power Of The Reactor").description("Craft a reactor casing to begin building your nuclear reactor").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_CONTROLLER = CNAdvancement.create("reactor_controller", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_CONTROLLER).title("Controller Of The Core").description("Craft a reactor controller to manage and regulate your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_BLUEPRINT = CNAdvancement.create("reactor_blueprint", b -> b.icon((ItemProviderEntry<?, ?>)CNItems.REACTOR_BLUEPRINT).title("Blueprint For Power").description("Craft a reactor blueprint to design the layout of rods in your reactor").after(REACTOR_CONTROLLER).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_COOLER = CNAdvancement.create("reactor_cooler", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_COOLER).title("Cooling The Reactor").description("Craft a reactor cooler to cool your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_FRAME = CNAdvancement.create("reactor_frame", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_FRAME).title("Reactor Frame").description("Craft a reactor frame to build your nuclear reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_INPUT = CNAdvancement.create("reactor_input", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_INPUT).title("Fueling The Reactor").description("Craft a reactor input to feed uranium and graphite rods into your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_OUTPUT = CNAdvancement.create("reactor_output", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_OUTPUT).title("Power Output").description("Craft a reactor output to transfer the energy produced by your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_CORE = CNAdvancement.create("reactor_core", b -> b.icon((ItemProviderEntry<?, ?>)CNBlocks.REACTOR_CORE).title("Core of Power").description("Craft the reactor core to harness the full energy of your nuclear reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement END = null;
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static CreateNuclearAdvancement create(String id, UnaryOperator<CreateNuclearAdvancement.Builder> b) {
        return new CreateNuclearAdvancement(id, b);
    }

    public CNAdvancement(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (CreateNuclearAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, (HolderLookup.Provider)provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "CreateNuclear's Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CreateNuclearAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

