/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.input;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.nuclearteam.createnuclear.CNMenus;
import net.nuclearteam.createnuclear.content.multiblock.input.ReactorInputEntity;

public class ReactorInputMenu
extends MenuBase<ReactorInputEntity> {
    public ReactorInputMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public ReactorInputMenu(MenuType<?> type, int id, Inventory inv, ReactorInputEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static ReactorInputMenu create(int id, Inventory inv, ReactorInputEntity contentHolder) {
        return new ReactorInputMenu((MenuType)CNMenus.SLOT_ITEM_STORAGE.get(), id, inv, contentHolder);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        if (index < 2) {
            this.moveItemStackTo(stack, 2, this.slots.size(), false);
        } else {
            this.moveItemStackTo(stack, 0, 2, false);
        }
        return ItemStack.EMPTY;
    }

    protected ReactorInputEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof ReactorInputEntity) {
            ReactorInputEntity reactorInput = (ReactorInputEntity)blockEntity;
            reactorInput.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return reactorInput;
        }
        return null;
    }

    protected void initAndReadInventory(ReactorInputEntity contentHolder) {
    }

    protected void addSlots() {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.addSlot(new Slot((Container)this.player.getInventory(), hotbarSlot, -31 + hotbarSlot * 18, 155));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)this.player.getInventory(), col + row * 9 + 9, -31 + col * 18, 97 + row * 18));
            }
        }
        SlotItemHandler slot1 = new SlotItemHandler((IItemHandler)((ReactorInputEntity)((Object)this.contentHolder)).inventory, 0, 24, 29);
        SlotItemHandler slot2 = new SlotItemHandler((IItemHandler)((ReactorInputEntity)((Object)this.contentHolder)).inventory, 1, 57, 29);
        this.addSlot((Slot)slot1);
        this.addSlot((Slot)slot2);
    }

    protected void saveData(ReactorInputEntity contentHolder) {
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (clickType == ClickType.THROW) {
            int[] targetSlotIds;
            for (int id : targetSlotIds = new int[]{9, 18, 27, 0, 1, 28, 19, 10, 16, 17, 26, 25, 34, 35, 8, 7}) {
                if (slotId != id) continue;
                clickType = ClickType.PICKUP;
                super.clicked(slotId, button, clickType, player);
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }
}

