/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.controller;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import java.util.List;
import lib.multiblock.SimpleMultiBlockAislePatternBuilder;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNDataComponents;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.multiblock.IHeat;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.PatternData;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintData;
import net.nuclearteam.createnuclear.content.multiblock.controller.EventTriggerPacket;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerInventory;
import net.nuclearteam.createnuclear.content.multiblock.input.ReactorInputEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutputEntity;

public class ReactorControllerBlockEntity
extends SmartBlockEntity
implements IInteractionChecker,
IHaveGoggleInformation {
    public boolean destroyed = false;
    public boolean created = false;
    public boolean test = true;
    public int speed = 16;
    public boolean sendUpdate;
    public ReactorControllerBlock controller;
    public ReactorControllerInventory inventory;
    public State powered = State.OFF;
    public float reactorPower;
    public float lastReactorPower;
    int overFlowHeatTimer = 0;
    int overFlowLimiter = 30;
    double overHeat = 0.0;
    public int baseUraniumHeat = 25;
    public int baseGraphiteHeat = -10;
    public int proximityUraniumHeat = 5;
    public int proximityGraphiteHeat = -5;
    public int maxUraniumPerGraphite = 3;
    public int graphiteTimer = 3600;
    public int uraniumTimer = 3600;
    public int tmpGraphiteTimer = this.graphiteTimer;
    public int tmpUraniumTimer = this.uraniumTimer;
    public int countUraniumRod;
    public int countGraphiteRod;
    public int heat;
    public double total;
    private boolean isTotal = false;
    public CompoundTag screen_pattern = new CompoundTag();
    public ItemStack configuredPattern;
    private ItemStack fuelItem;
    private ItemStack coolerItem;
    private final int[][] formattedPattern = new int[][]{{99, 99, 99, 0, 1, 2, 99, 99, 99}, {99, 99, 3, 4, 5, 6, 7, 99, 99}, {99, 8, 9, 10, 11, 12, 13, 14, 99}, {15, 16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31, 32}, {33, 34, 35, 36, 37, 38, 39, 40, 41}, {99, 42, 43, 44, 45, 46, 47, 48, 99}, {99, 99, 49, 50, 51, 52, 53, 99, 99}, {99, 99, 99, 54, 55, 56, 99, 99, 99}};
    private final int[][] offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

    public ReactorControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ReactorControllerInventory(this);
        this.configuredPattern = ItemStack.EMPTY;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean getAssembled() {
        BlockState state = this.getBlockState();
        return (Boolean)state.getValue((Property)ReactorControllerBlock.ASSEMBLED);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.configuredPattern.isEmpty()) {
            CreateLang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            IHeat.HeatLevel.getName("reactor_controller").style(ChatFormatting.GRAY).forGoggles(tooltip);
            IHeat.HeatLevel.getFormattedHeatText(this.heat).forGoggles(tooltip);
            if (this.fuelItem.isEmpty()) {
                IHeat.HeatLevel.getFormattedItemText(new ItemStack((ItemLike)CNItems.URANIUM_ROD.asItem(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.fuelItem, false).forGoggles(tooltip);
            }
            if (this.fuelItem.isEmpty()) {
                IHeat.HeatLevel.getFormattedItemText(new ItemStack((ItemLike)CNItems.GRAPHITE_ROD.asItem(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.coolerItem, false).forGoggles(tooltip);
            }
        }
        return true;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        }
        this.configuredPattern = ItemStack.EMPTY;
        if (tag.contains("configuredPattern")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("configuredPattern")).ifPresent(i -> {
                this.configuredPattern = i;
            });
        }
        this.coolerItem = ItemStack.EMPTY;
        if (tag.contains("coolerItem")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("coolerItem")).ifPresent(i -> {
                this.coolerItem = i;
            });
        }
        this.fuelItem = ItemStack.EMPTY;
        if (tag.contains("fuelItem")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("fuelItem")).ifPresent(i -> {
                this.fuelItem = i;
            });
        }
        this.total = tag.getDouble("total");
        this.heat = tag.getInt("heat");
        super.read(tag, registries, clientPacket);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (!clientPacket) {
            compound.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        }
        if (this.configuredPattern != null) {
            compound.put("configuredPattern", this.configuredPattern.saveOptional(registries));
        }
        if (this.coolerItem != null) {
            compound.put("coolerItem", this.coolerItem.saveOptional(registries));
        }
        if (this.fuelItem != null) {
            compound.put("fuelItem", this.fuelItem.saveOptional(registries));
        }
        compound.putDouble("total", Double.isNaN(this.total) ? this.total : this.calculateProgress());
        compound.putInt("heat", this.heat);
        super.write(compound, registries, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.isEmptyConfiguredPattern()) {
            BlockEntity blockEntity;
            ReactorBluePrintData data = this.getReactorBluePrintData();
            this.countGraphiteRod = data.countGraphiteRod();
            this.countUraniumRod = data.countUraniumRod();
            if (!this.isTotal) {
                this.total = this.calculateProgress();
                this.isTotal = true;
            }
            if ((blockEntity = this.level.getBlockEntity(this.getBlockPosForReactor('I'))) instanceof ReactorInputEntity) {
                ReactorInputEntity be = (ReactorInputEntity)blockEntity;
                this.fuelItem = be.inventory.getStackInSlot(0);
                this.coolerItem = be.inventory.getStackInSlot(1);
                IItemHandler capability = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)Direction.NORTH.getOpposite());
                if (capability == null) {
                    capability = EmptyItemHandler.INSTANCE;
                }
                if (this.tmpUraniumTimer >= 0) {
                    this.tmpUraniumTimer -= 1 * this.countUraniumRod;
                } else {
                    ItemStack extractItem1 = capability.extractItem(0, 1, false);
                    this.tmpUraniumTimer = this.uraniumTimer;
                }
                if (this.tmpGraphiteTimer >= 0) {
                    this.tmpGraphiteTimer -= 1 * this.countGraphiteRod;
                } else {
                    ItemStack extractItem2 = capability.extractItem(1, 1, false);
                    this.tmpGraphiteTimer = this.graphiteTimer;
                }
                if (!this.fuelItem.isEmpty() && !this.coolerItem.isEmpty()) {
                    this.heat = (int)this.calculateHeat(this.inventory.getItem(0));
                    if (this.updateTimers()) {
                        if (IHeat.HeatLevel.of(this.heat) == IHeat.HeatLevel.SAFETY || IHeat.HeatLevel.of(this.heat) == IHeat.HeatLevel.CAUTION || IHeat.HeatLevel.of(this.heat) == IHeat.HeatLevel.WARNING) {
                            this.rotate(this.getBlockState(), new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + ReactorControllerBlockEntity.FindController('O').getY(), this.getBlockPos().getZ()), this.getLevel(), this.heat / 4, true);
                            return;
                        }
                        EventTriggerPacket packet = new EventTriggerPacket(600);
                        CreateNuclear.LOGGER.warn("hum EventTriggerBlock ? {}", (Object)packet);
                        CatnipServices.NETWORK.sendToClientsAround((ServerLevel)this.level, (Vec3i)this.getBlockPos(), 32.0, (CustomPacketPayload)packet);
                        this.rotate(this.getBlockState(), new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + ReactorControllerBlockEntity.FindController('O').getY(), this.getBlockPos().getZ()), this.getLevel(), 0, false);
                        this.isTotal = false;
                        return;
                    }
                    this.rotate(this.getBlockState(), new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + ReactorControllerBlockEntity.FindController('O').getY(), this.getBlockPos().getZ()), this.getLevel(), 0, false);
                    this.isTotal = false;
                    return;
                }
                this.notifyUpdate();
            }
        }
    }

    private boolean isEmptyConfiguredPattern() {
        return !this.configuredPattern.isEmpty();
    }

    private boolean updateTimers() {
        this.total -= 1.0;
        return this.total >= 0.0;
    }

    private ReactorBluePrintData getDefaultReactorBluePrintData() {
        return new ReactorBluePrintData(0, 0, 0, 0, new PatternData[0], new PatternData[0]);
    }

    private ReactorBluePrintData getReactorBluePrintData() {
        return (ReactorBluePrintData)this.configuredPattern.getOrDefault(CNDataComponents.REACTOR_BLUE_PRINT_DATA, (Object)this.getDefaultReactorBluePrintData());
    }

    private double calculateProgress() {
        ReactorBluePrintData data = this.getReactorBluePrintData();
        this.countGraphiteRod = data.countGraphiteRod();
        this.countUraniumRod = data.countUraniumRod();
        this.graphiteTimer = data.graphiteTime();
        this.uraniumTimer = data.uraniumTime();
        double progressGraphite = this.countGraphiteRod > 0 ? (double)this.graphiteTimer / (double)this.countGraphiteRod : 0.0;
        double progressUranium = this.countUraniumRod > 0 ? (double)this.uraniumTimer / (double)this.countUraniumRod : 0.0;
        double tmp = progressGraphite + progressUranium;
        return progressGraphite + progressUranium;
    }

    private double calculateHeat(ItemStack input) {
        PatternData[] patternDataAll;
        ReactorBluePrintData data = (ReactorBluePrintData)input.getOrDefault(CNDataComponents.REACTOR_BLUE_PRINT_DATA, (Object)this.getDefaultReactorBluePrintData());
        this.countGraphiteRod = data.countGraphiteRod();
        this.countUraniumRod = data.countUraniumRod();
        this.heat = 0;
        if (this.countUraniumRod > this.countGraphiteRod * this.maxUraniumPerGraphite) {
            ++this.overFlowHeatTimer;
            if (this.overFlowHeatTimer >= this.overFlowLimiter) {
                this.overHeat += 1.0;
                this.overFlowHeatTimer = 0;
                if (this.overFlowLimiter > 2) {
                    --this.overFlowLimiter;
                }
            }
        } else {
            this.overFlowHeatTimer = 0;
            this.overFlowLimiter = 30;
            this.overHeat = Math.max(0.0, this.overHeat - 2.0);
        }
        block0: for (PatternData pd : patternDataAll = data.patternAll()) {
            int currentRod = 0;
            ItemStack stack = pd.stack();
            if (stack.is(CNItems.URANIUM_ROD)) {
                this.heat += this.baseUraniumHeat;
                currentRod = 117;
            } else if (stack.is(CNItems.GRAPHITE_ROD)) {
                this.heat += this.baseGraphiteHeat;
                currentRod = 103;
            }
            if (currentRod == 0) continue;
            for (int i = 0; i < this.formattedPattern.length; ++i) {
                for (int j = 0; j < this.formattedPattern[i].length; ++j) {
                    if (this.formattedPattern[i][j] != pd.slot()) continue;
                    block3: for (int[] offset : this.offsets) {
                        int ni = i + offset[0];
                        int nj = j + offset[1];
                        if (ni < 0 || ni >= this.formattedPattern.length || nj < 0 || nj >= this.formattedPattern[i].length) continue;
                        int neighborSlot = this.formattedPattern[ni][nj];
                        for (PatternData pd2 : patternDataAll) {
                            if (pd2.slot() != neighborSlot) continue;
                            ItemStack stack2 = pd.stack();
                            if (currentRod != 117) continue block3;
                            this.heat += stack2.is(CNItems.URANIUM_ROD) ? this.proximityUraniumHeat : this.proximityGraphiteHeat;
                            continue block3;
                        }
                    }
                    continue block0;
                }
            }
        }
        return (double)this.heat + this.overHeat;
    }

    private BlockPos getBlockPosForReactor(char character) {
        int[][] directions;
        BlockPos pos = ReactorControllerBlockEntity.FindController(character);
        BlockPos posController = this.getBlockPos();
        BlockPos posInput = new BlockPos(posController.getX(), posController.getY(), posController.getZ());
        for (int[] direction : directions = new int[][]{{0, 0, pos.getX()}, {0, 0, -pos.getX()}, {-pos.getX(), 0, 0}, {pos.getX(), 0, 0}}) {
            BlockPos newPos = posController.offset(direction[0], direction[1], direction[2]);
            if (!this.level.getBlockState(newPos).is((Block)CNBlocks.REACTOR_INPUT.get())) continue;
            posInput = newPos;
            break;
        }
        return posInput;
    }

    private CompoundTag convertePattern(CompoundTag compoundTag) {
        ListTag pattern = compoundTag.getList("Items", 10);
        int[][] list = new int[][]{{99, 99, 99, 0, 1, 2, 99, 99, 99}, {99, 99, 3, 4, 5, 6, 7, 99, 99}, {99, 8, 9, 10, 11, 12, 13, 14, 99}, {15, 16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31, 32}, {33, 34, 35, 36, 37, 38, 39, 40, 41}, {99, 42, 43, 44, 45, 46, 47, 48, 99}, {99, 99, 49, 50, 51, 52, 53, 99, 99}, {99, 99, 99, 54, 55, 56, 99, 99, 99}};
        return null;
    }

    private static BlockPos FindController(char character) {
        return SimpleMultiBlockAislePatternBuilder.start().aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAAAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAIAA", "ADADA", "BACAB", "ADADA", "AA*AA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAOAA").where('A', a -> a.getState().is((Block)CNBlocks.REACTOR_CASING.get())).where('B', a -> a.getState().is((Block)CNBlocks.REACTOR_FRAME.get())).where('C', a -> a.getState().is((Block)CNBlocks.REACTOR_CORE.get())).where('D', a -> a.getState().is((Block)CNBlocks.REACTOR_COOLER.get())).where('*', a -> a.getState().is((Block)CNBlocks.REACTOR_CONTROLLER.get())).where('O', a -> a.getState().is((Block)CNBlocks.REACTOR_OUTPUT.get())).where('I', a -> a.getState().is((Block)CNBlocks.REACTOR_INPUT.get())).getDistanceController(character);
    }

    public void rotate(BlockState state, BlockPos pos, Level level, int rotation, boolean isActif) {
        int n = rotation = rotation > 0 ? rotation : this.heat / 4;
        if (level.getBlockState(pos).is((Block)CNBlocks.REACTOR_OUTPUT.get()) && rotation > 0 && isActif) {
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof ReactorOutput) {
                ReactorOutput block2 = (ReactorOutput)block;
                ReactorOutputEntity entity = (ReactorOutputEntity)block2.getBlockEntityType().getBlockEntity((BlockGetter)level, pos);
                if (((Boolean)state.getValue((Property)ReactorControllerBlock.ASSEMBLED)).booleanValue()) {
                    entity.speed = rotation;
                    entity.heat = rotation;
                } else {
                    entity.speed = 0;
                    entity.heat = 0.0f;
                }
                entity.updateSpeed = true;
                entity.updateGeneratedRotation();
                entity.setSpeed(rotation);
            }
        } else {
            Object entity = level.getBlockState(pos).getBlock();
            if (entity instanceof ReactorOutput) {
                ReactorOutput block = (ReactorOutput)((Object)entity);
                entity = (ReactorOutputEntity)block.getBlockEntityType().getBlockEntity((BlockGetter)level, pos);
                ((ReactorOutputEntity)((Object)entity)).setSpeed(0);
                ((ReactorOutputEntity)((Object)entity)).heat = 0.0f;
                ((ReactorOutputEntity)((Object)entity)).updateSpeed = true;
                entity.updateGeneratedRotation();
            }
        }
    }

    public static enum State {
        ON,
        OFF;

    }
}

