/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ItemStack;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;

public interface IHeat
extends IWrenchable {

    public static enum HeatLevel {
        NONE(ChatFormatting.DARK_GRAY, 0),
        SAFETY(ChatFormatting.GREEN, 6867971),
        CAUTION(ChatFormatting.YELLOW, 13224963),
        WARNING(ChatFormatting.GOLD, 16738816),
        DANGER(ChatFormatting.RED, 16738816);

        private final ChatFormatting color;
        private final Integer intColor;
        private final int colorCode;

        private HeatLevel(ChatFormatting textColor, int colorCode) {
            this.color = textColor;
            this.intColor = null;
            this.colorCode = colorCode;
        }

        private HeatLevel(int intColor, int colorCode) {
            this.color = null;
            this.intColor = intColor;
            this.colorCode = colorCode;
        }

        public ChatFormatting getTextColor() {
            return this.color;
        }

        public int getColorCode() {
            return this.colorCode;
        }

        public int getHeatValue() {
            return switch (this.ordinal()) {
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                default -> 0;
            };
        }

        public static HeatLevel of(int heat) {
            if (heat < 0) {
                return NONE;
            }
            if ((heat = Math.abs(heat)) > 0 && heat < 500) {
                return SAFETY;
            }
            if (heat >= 501 && heat <= 800) {
                return CAUTION;
            }
            if (heat >= 801 && heat <= 1000) {
                return WARNING;
            }
            if (heat >= 1001) {
                return DANGER;
            }
            return NONE;
        }

        public static LangBuilder getFormattedHeatText(int heat) {
            HeatLevel heatLevel = HeatLevel.of(heat);
            LangBuilder builder = CreateLang.builder((String)"createnuclear").text(TooltipHelper.makeProgressBar((int)5, (int)(heatLevel.ordinal() + 1)));
            builder.translate("tooltip.heatLevel." + Lang.asId((String)heatLevel.name()), new Object[0]).space().text("(").add(CreateNuclearLang.number(Math.abs(heat))).space().translate("generic.unit.heat", new Object[0]).text(")").space();
            if (heatLevel == DANGER) {
                builder.style(DANGER.getTextColor()).style(ChatFormatting.STRIKETHROUGH);
            } else {
                builder.style(heatLevel.getTextColor());
            }
            return builder;
        }

        public static LangBuilder getFormattedItemText(ItemStack itemRod, Boolean IsEmpty) {
            LangBuilder builder = Lang.builder((String)"createnuclear");
            String tooltip = "unknown";
            if (itemRod.is(CNTags.CNItemTags.FUEL.tag)) {
                tooltip = "uranium";
            }
            if (itemRod.is(CNTags.CNItemTags.COOLER.tag)) {
                tooltip = "graphene";
            }
            builder.translate("tooltip.item." + tooltip + ".rod", new Object[0]).add(CreateNuclearLang.number(Math.abs(IsEmpty != false ? itemRod.getCount() - 1 : itemRod.getCount()))).style(ChatFormatting.BLUE);
            return builder;
        }

        public static LangBuilder getName(String name) {
            LangBuilder builder = CreateNuclearLang.builder((String)"createnuclear");
            builder.translate("gui." + name + ".info_header.title", new Object[0]);
            return builder;
        }
    }
}

