/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.power.RunefusedGemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class ImbuedPower
extends RunefusedGemPower {
    public ImbuedPower(boolean isGreater) {
        super(isGreater);
    }

    @Override
    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int hitChance = Config.gemPowers.imbued.chance;
        int damage = (this.isGreater() ? 10 : 6) - stack.getDamageValue() / stack.getMaxDamage() * 100 / 20;
        if (attacker.getRandom().nextInt(100) <= hitChance) {
            target.invulnerableTime = 0;
            target.hurt(attacker.damageSources().magic(), (float)damage);
            attacker.level().playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.getSoundSource(), 0.2f, 1.8f);
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (isRunic) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.imbuedsworditem.tooltip1").setStyle(Styles.RUNIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.runefused_power.imbued").setStyle(Styles.RUNIC));
        }
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.imbuedsworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.imbuedsworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }

    public static class Settings
    extends TooltipSettings {
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance = 15;

        public Settings() {
            super((Supplier<? extends TooltipProvider>)GemPowerRegistry.IMBUED);
        }
    }
}

