/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib;

import de.maxhenkel.corpse.corelib.config.ConfigBase;
import de.maxhenkel.corpse.corelib.config.DynamicConfig;
import de.maxhenkel.corpse.corelib.net.Message;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class CommonRegistry {
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    private static final Path DEFAULT_CONFIG_PATH = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());

    public static <T extends Message<T>> void registerMessage(PayloadRegistrar registrar, final Class<T> message) {
        block4: {
            try {
                Message dummy = (Message)message.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                StreamCodec codec = new StreamCodec<RegistryFriendlyByteBuf, T>(){

                    public void encode(RegistryFriendlyByteBuf buf, T packet) {
                        packet.toBytes(buf);
                    }

                    public T decode(RegistryFriendlyByteBuf buf) {
                        try {
                            Message packet = (Message)message.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            packet.fromBytes(buf);
                            return packet;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                IPayloadHandler handler = (payload, context) -> {
                    if (!payload.getExecutingSide().equals((Object)context.flow())) {
                        return;
                    }
                    if (PacketFlow.CLIENTBOUND.equals((Object)context.flow())) {
                        context.enqueueWork(() -> payload.executeClientSide(context));
                    } else {
                        context.enqueueWork(() -> payload.executeServerSide(context));
                    }
                };
                if (dummy.getExecutingSide().equals((Object)PacketFlow.CLIENTBOUND)) {
                    registrar.playToClient(dummy.type(), codec, handler);
                    break block4;
                }
                if (dummy.getExecutingSide().equals((Object)PacketFlow.SERVERBOUND)) {
                    registrar.playToServer(dummy.type(), codec, handler);
                    break block4;
                }
                throw new RuntimeException("Unknown packet flow: %s".formatted(dummy.getExecutingSide()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T extends Entity> EntityType<T> registerEntity(String modId, String name, MobCategory classification, Class<? extends Entity> entityClass, Consumer<EntityType.Builder<T>> builderConsumer) {
        EntityType.Builder builder = EntityType.Builder.of((type, world) -> {
            try {
                try {
                    return (Entity)entityClass.getConstructor(EntityType.class, Level.class).newInstance(type, world);
                }
                catch (NoSuchMethodException e) {
                    return (Entity)entityClass.getConstructor(Level.class).newInstance(world);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, (MobCategory)classification);
        builderConsumer.accept(builder);
        EntityType type2 = builder.build(modId + ":" + name);
        return type2;
    }

    public static <T extends ConfigBase> T registerConfig(String modId, ModConfig.Type type, Class<T> configClass, boolean registerListener) {
        ConfigBase config;
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        try {
            config = (ConfigBase)configClass.getConstructor(ModConfigSpec.Builder.class).newInstance(builder);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ModConfigSpec spec = builder.build();
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new RuntimeException("Could not find mod %s".formatted(modId)));
        modContainer.registerConfig(type, (IConfigSpec)spec);
        config.setConfigSpec(spec);
        if (registerListener) {
            Consumer<ModConfigEvent.Loading> load = evt -> {
                if (evt.getConfig().getType() == type) {
                    config.onLoad((ModConfigEvent.Loading)evt);
                }
            };
            ModLoadingContext.get().getActiveContainer().getEventBus().addListener(load);
            Consumer<ModConfigEvent.Reloading> reload = evt -> {
                if (evt.getConfig().getType() == type) {
                    config.onReload((ModConfigEvent.Reloading)evt);
                }
            };
            ModLoadingContext.get().getActiveContainer().getEventBus().addListener(reload);
        }
        return (T)config;
    }

    public static <T extends ConfigBase> T registerConfig(String modId, ModConfig.Type type, Class<T> configClass) {
        return CommonRegistry.registerConfig(modId, type, configClass, false);
    }

    public static <T extends DynamicConfig> T registerDynamicConfig(DynamicConfig.DynamicConfigType type, String folderName, String configName, Class<T> configClass) {
        try {
            DynamicConfig config = (DynamicConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String configFileName = configName + ".toml";
            if (type.equals((Object)DynamicConfig.DynamicConfigType.SERVER)) {
                Consumer<ServerAboutToStartEvent> consumer = event -> {
                    Path serverConfig = event.getServer().getWorldPath(SERVERCONFIG).resolve(folderName);
                    serverConfig.toFile().mkdirs();
                    Path configPath = serverConfig.resolve(configFileName);
                    Path defaultPath = DEFAULT_CONFIG_PATH.resolve(folderName).resolve(configFileName);
                    config.init(configPath, defaultPath);
                };
                NeoForge.EVENT_BUS.addListener(consumer);
            } else {
                Path commonConfig = FMLPaths.CONFIGDIR.get().resolve(folderName);
                commonConfig.toFile().mkdirs();
                Path configPath = commonConfig.resolve(configFileName);
                config.init(configPath);
            }
            return (T)config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

