/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;

public class Codecs {
    public static final Codec<Double> POSITIVE_DOUBLE = Codec.DOUBLE.validate(f -> f > 0.0 ? DataResult.success((Object)f) : DataResult.error(() -> "Value must be positive: " + f));

    public static Codec<int[]> intArrayCodec(final int minSize, final int maxSize) {
        return new Codec<int[]>(){

            public <T> DataResult<T> encode(int[] input, DynamicOps<T> ops, T prefix) {
                if (input.length < minSize || input.length > maxSize) {
                    return DataResult.error(() -> "Array size must be between " + minSize + " and " + maxSize + ", got: " + input.length);
                }
                ListBuilder builder = ops.listBuilder();
                for (int inp : input) {
                    builder.add(ops.createInt(inp));
                }
                return builder.build(prefix);
            }

            public <T> DataResult<Pair<int[], T>> decode(DynamicOps<T> ops, T input) {
                return ops.getIntStream(input).flatMap(stream -> {
                    int[] array = stream.toArray();
                    if (array.length < minSize || array.length > maxSize) {
                        return DataResult.error(() -> "Array size must be between " + minSize + " and " + maxSize + ", got: " + array.length);
                    }
                    return DataResult.success((Object)Pair.of((Object)array, (Object)input));
                });
            }
        };
    }

    public static Codec<byte[]> byteArrayCodec(final int minSize, final int maxSize) {
        return new Codec<byte[]>(){

            public <T> DataResult<T> encode(byte[] input, DynamicOps<T> ops, T prefix) {
                if (input.length < minSize || input.length > maxSize) {
                    return DataResult.error(() -> "Array size must be between " + minSize + " and " + maxSize + ", got: " + input.length);
                }
                ListBuilder builder = ops.listBuilder();
                for (byte inp : input) {
                    builder.add(ops.createByte(inp));
                }
                return builder.build(prefix);
            }

            public <T> DataResult<Pair<byte[], T>> decode(DynamicOps<T> ops, T input) {
                return ops.getByteBuffer(input).flatMap(stream -> {
                    byte[] array = stream.array();
                    if (array.length < minSize || array.length > maxSize) {
                        return DataResult.error(() -> "Array size must be between " + minSize + " and " + maxSize + ", got: " + array.length);
                    }
                    return DataResult.success((Object)Pair.of((Object)array, (Object)input));
                });
            }
        };
    }

    public static Codec<Float> floatRange(float minInclusive, float maxInclusive) {
        return Codec.FLOAT.validate(f -> f.compareTo(Float.valueOf(minInclusive)) >= 0 && f.compareTo(Float.valueOf(maxInclusive)) <= 0 ? DataResult.success((Object)f) : DataResult.error(() -> "Value must be between %s and %s: %s".formatted(Float.valueOf(minInclusive), Float.valueOf(maxInclusive), f)));
    }
}

