/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.MouseHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    @Inject(method={"onScroll(JDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z")}, cancellable=true)
    private void onScroll(long windowPointer, double xOffset, double yOffset, CallbackInfo ci, @Local(ordinal=4) double yScroll) {
        if (yScroll != 0.0 && io.github.mortuusars.exposure.client.input.MouseHandler.scrolled(yScroll)) {
            ci.cancel();
        }
    }

    @Inject(method={"onPress(JIII)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getOverlay()Lnet/minecraft/client/gui/screens/Overlay;", ordinal=0)}, cancellable=true)
    private void onPress(long windowPointer, int button, int action, int modifiers, CallbackInfo ci) {
        if (io.github.mortuusars.exposure.client.input.MouseHandler.buttonPressed(button, action, modifiers)) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"turnPlayer(D)V"}, at=@At(value="STORE"), ordinal=3)
    private double modifySensitivity(double sensitivity) {
        return io.github.mortuusars.exposure.client.input.MouseHandler.modifySensitivity(sensitivity);
    }
}

