/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.task.file;

import com.google.common.io.Files;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.capture.task.file.BufferedImageFileLoader;
import io.github.mortuusars.exposure.client.capture.task.file.NativeImagePngFileLoader;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import java.io.File;

public interface ImageFileLoader {
    public Result<Image> load(File var1);

    public static ImageFileLoader chooseFitting(File file) {
        return !Files.getFileExtension((String)file.toString()).equals("png") ? new BufferedImageFileLoader() : ImageFileLoader.fallback(new NativeImagePngFileLoader(), new BufferedImageFileLoader());
    }

    public static ImageFileLoader fallback(ImageFileLoader main, ImageFileLoader fallback) {
        return file -> {
            Result<Image> result = main.load(file);
            if (result.isError()) {
                Exposure.LOGGER.info("Loading image with main loader failed. Using fallback...");
                return fallback.load(file);
            }
            return result;
        };
    }
}

