/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import fr.iglee42.createcasing.blocks.ConfigurableGearboxBlock;
import fr.iglee42.createcasing.casings.CasingSet;
import fr.iglee42.createcasing.casings.CasingSets;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.transmissions.TransmissionSet;
import fr.iglee42.createcasing.transmissions.TransmissionSets;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="createcasing")
public class ItemChangeBlockManager {
    @SubscribeEvent
    public static <T extends Comparable<T>> void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        TransmissionSet transmissionSet;
        Level level = event.getEntity().level();
        if (event.getItemStack().isEmpty()) {
            return;
        }
        if (level.getBlockState(event.getPos()).isAir()) {
            return;
        }
        BlockState state = level.getBlockState(event.getPos());
        CasingSet casingSet = ItemChangeBlockManager.getSetForCasing(event.getItemStack().getItem());
        if (casingSet != null && ((Boolean)ModConfigs.common().kinetics.casingBlockSwappable.get()).booleanValue()) {
            if (casingSet.isInSet(state.getBlock())) {
                return;
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getGearbox) && casingSet.getGearbox() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getGearbox().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getMixer) && casingSet.getMixer() != null) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getMixer().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getPress) && casingSet.getPress() != null) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getPress().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getDepot) && event.getFace() != Direction.UP && casingSet.getDepot() != null) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getDepot().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getChainDrive) && casingSet.getChainDrive() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getChainDrive().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getChainGearshift) && casingSet.getChainGearshift() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getChainGearshift().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getConfigurableGearbox) && casingSet.getConfigurableGearbox() != null) {
                BlockState newState = casingSet.getConfigurableGearbox().defaultBlockState();
                for (Direction dir : Iterate.directions) {
                    BooleanProperty property = ConfigurableGearboxBlock.getPropertyByDirection(dir);
                    newState = (BlockState)newState.setValue((Property)property, (Comparable)((Boolean)state.getValue((Property)property)));
                }
                ItemChangeBlockManager.changeBlock(event, state, level, newState);
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getChainConveyor) && casingSet.getChainConveyor() != null) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getChainConveyor().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getGearshift) && casingSet.getGearshift() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getGearshift().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getClutch) && casingSet.getClutch() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getClutch().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getDeployer) && casingSet.getDeployer() != null) {
                ItemChangeBlockManager.changeFacingBlock(event, state, level, casingSet.getDeployer().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getStorageInterface) && casingSet.getStorageInterface() != null) {
                ItemChangeBlockManager.changeFacingBlock(event, state, level, casingSet.getStorageInterface().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getEncasedFan) && casingSet.getEncasedFan() != null) {
                ItemChangeBlockManager.changeFacingBlock(event, state, level, casingSet.getEncasedFan().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getHarvester) && casingSet.getHarvester() != null) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getHarvester().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getSaw) && casingSet.getSaw() != null) {
                BlockState bs = casingSet.getSaw().defaultBlockState();
                bs = (BlockState)((BlockState)bs.setValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)))).setValue((Property)SawBlock.FLIPPED, (Comparable)((Boolean)state.getValue((Property)SawBlock.FLIPPED)));
                ItemChangeBlockManager.changeFacingBlock(event, state, level, bs);
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getDrill) && casingSet.getDrill() != null) {
                ItemChangeBlockManager.changeFacingBlock(event, state, level, casingSet.getDrill().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getPlough) && casingSet.getPlough() != null) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getPlough().defaultBlockState());
            }
            if (ItemChangeBlockManager.isElementInSet(state, CasingSet::getRoller) && casingSet.getRoller() != null) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getRoller().defaultBlockState());
            }
        }
        if ((transmissionSet = ItemChangeBlockManager.getSetForItem(event.getItemStack().getItem())) != null && ((Boolean)ModConfigs.common().kinetics.shaftCogwheelsSwappable.get()).booleanValue()) {
            if (transmissionSet.isInSet(state.getBlock())) {
                return;
            }
            if (ItemChangeBlockManager.isShaft(state) && transmissionSet.getShaft() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, transmissionSet.getShaft().defaultBlockState());
            }
            if (ItemChangeBlockManager.isCogwheel(state) && transmissionSet.getCogwheel() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, transmissionSet.getCogwheel().defaultBlockState());
            }
            if (ItemChangeBlockManager.isLargeCogwheel(state) && transmissionSet.getLargeCogwheel() != null) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, transmissionSet.getLargeCogwheel().defaultBlockState());
            }
        }
    }

    private static void changeBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        level.setBlockAndUpdate(event.getPos(), newBlock);
        level.levelEvent(2001, event.getPos(), Block.getId((BlockState)newBlock));
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void changeHorizontalDirectionBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
    }

    private static void changeAxisBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!(state.getBlock() instanceof RotatedPillarKineticBlock)) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
    }

    private static void changeFacingBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!state.hasProperty((Property)BlockStateProperties.FACING)) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
    }

    private static CasingSet getSetForCasing(Item casing) {
        return CasingSets.getSets().stream().filter(set -> set.getCasing() != null).filter(set -> set.getCasing().asItem().equals(casing)).findFirst().orElse(null);
    }

    private static TransmissionSet getSetForItem(Item item) {
        return TransmissionSets.getSets().stream().filter(set -> set.getItem() != null).filter(set -> set.getItem().equals(item)).findFirst().orElse(null);
    }

    public static boolean isElementInSet(BlockState state, Function<CasingSet, Block> function) {
        return CasingSets.getSets().stream().filter(set -> function.apply((CasingSet)set) != null).anyMatch(set -> state.getBlock().equals(function.apply((CasingSet)set)));
    }

    public static boolean isShaft(BlockState state) {
        return TransmissionSets.getSets().stream().filter(set -> set.getShaft() != null).anyMatch(set -> state.getBlock().equals(set.getShaft()));
    }

    public static boolean isCogwheel(BlockState state) {
        return TransmissionSets.getSets().stream().filter(set -> set.getCogwheel() != null).anyMatch(set -> state.getBlock().equals(set.getCogwheel()));
    }

    public static boolean isLargeCogwheel(BlockState state) {
        return TransmissionSets.getSets().stream().filter(set -> set.getLargeCogwheel() != null).anyMatch(set -> state.getBlock().equals(set.getLargeCogwheel()));
    }
}

