/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.transmissions;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import fr.iglee42.createcasing.blocks.cogwheels.WoodenCogwheelBlock;
import fr.iglee42.createcasing.blocks.shafts.BrassShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.GlassShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.WoodenShaftBlock;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import fr.iglee42.createcasing.transmissions.TransmissionSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class TransmissionSets {
    private static final List<TransmissionSet> sets = new ArrayList<TransmissionSet>();
    private static final Map<WoodType, TransmissionSet> woodSets = new HashMap<WoodType, TransmissionSet>();
    public static final TransmissionSet ANDESITE = TransmissionSets.register("andesite", new TransmissionSet.Options().item(() -> (Item)AllItems.ANDESITE_ALLOY.get()).existingShaft((BlockEntry<? extends ShaftBlock>)AllBlocks.SHAFT));
    public static final TransmissionSet BRASS = TransmissionSets.register("brass", new TransmissionSet.Options().item(() -> (Item)AllItems.BRASS_INGOT.get()).shaft().notEncasable().shaftConstructor(() -> BrassShaftBlock::new).shaftBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.BRASS_SHAFT.get()));
    public static final TransmissionSet MLDEG = TransmissionSets.register("mldeg", new TransmissionSet.Options().item(() -> Items.BLACKSTONE).shaft());
    public static final TransmissionSet GLASS = TransmissionSets.register("glass", new TransmissionSet.Options().item(() -> Items.GLASS).shaftBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.GLASS_SHAFT.get()).shaftConstructor(() -> GlassShaftBlock::new).shaft());

    public static TransmissionSet register(String id, TransmissionSet.Options options) {
        String name = id.toLowerCase(Locale.ROOT);
        if (sets.stream().anyMatch(set -> set.getName().equalsIgnoreCase(name))) {
            throw new IllegalArgumentException("A transmission set with name `" + name + "` already exists !");
        }
        TransmissionSet set2 = new TransmissionSet(name, options);
        sets.add(set2);
        return set2;
    }

    public static List<TransmissionSet> getSets() {
        return ImmutableList.copyOf(sets);
    }

    public static List<TransmissionSet> getWoodSets() {
        return ImmutableList.copyOf(woodSets.values());
    }

    public static TransmissionSet getWoodSet(WoodType woodType) {
        return woodSets.get(woodType);
    }

    public static WoodType getWoodTypeForSet(TransmissionSet set) {
        if (!woodSets.containsValue(set)) {
            return null;
        }
        return woodSets.entrySet().stream().filter(e -> ((TransmissionSet)e.getValue()).equals(set)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    static {
        for (WoodType woodType : new WoodType[]{WoodType.ACACIA, WoodType.BIRCH, WoodType.BAMBOO, WoodType.CHERRY, WoodType.CRIMSON, WoodType.DARK_OAK, WoodType.OAK, WoodType.JUNGLE, WoodType.MANGROVE, WoodType.WARPED}) {
            TransmissionSet set = TransmissionSets.register(woodType.name().toLowerCase(Locale.ROOT), new TransmissionSet.Options().shaftConstructor(() -> WoodenShaftBlock::new).cogwheelConstructor(() -> (props, bool) -> bool != false ? WoodenCogwheelBlock.large(props) : WoodenCogwheelBlock.small(props)).shaftBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.WOODEN_SHAFT.get()).cogwheelBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.WOODEN_COGWHEELS.get()).largeCogwheelBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.WOODEN_COGWHEELS.get()).everything(() -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(woodType.name().toLowerCase(Locale.ROOT) + "_planks")))));
            woodSets.put(woodType, set);
        }
        TransmissionSet spruceSet = TransmissionSets.register("spruce", new TransmissionSet.Options().item(() -> Items.SPRUCE_PLANKS).shaft().shaftConstructor(() -> WoodenShaftBlock::new).shaftBlockEntityType(() -> (BlockEntityType)EncasedBlockEntities.WOODEN_SHAFT.get()).existingCogwheel((BlockEntry<? extends CogWheelBlock>)AllBlocks.COGWHEEL).existingLargeCogwheel((BlockEntry<? extends CogWheelBlock>)AllBlocks.LARGE_COGWHEEL));
        woodSets.put(WoodType.SPRUCE, spruceSet);
    }
}

