/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.google.common.base.Function;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.actors.plough.PloughBlock;
import com.simibubi.create.content.contraptions.actors.plough.PloughMovementBehaviour;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlockItem;
import com.simibubi.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.CasingConnectivity;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.deployer.DeployerMovementBehaviour;
import com.simibubi.create.content.kinetics.deployer.DeployerMovingInteraction;
import com.simibubi.create.content.kinetics.drill.DrillMovementBehaviour;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.saw.SawMovementBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.simibubi.create.content.logistics.depot.MountedDepotInteractionBehaviour;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import fr.iglee42.createcasing.CreateCasing;
import fr.iglee42.createcasing.blocks.ConfigurableGearboxBlock;
import fr.iglee42.createcasing.blocks.CreativeCogwheelBlock;
import fr.iglee42.createcasing.blocks.cogwheels.CustomCogwheelBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainDriveBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainGearshiftBlock;
import fr.iglee42.createcasing.blocks.customs.CustomClutchBlock;
import fr.iglee42.createcasing.blocks.customs.CustomDeployerBlock;
import fr.iglee42.createcasing.blocks.customs.CustomDepotBlock;
import fr.iglee42.createcasing.blocks.customs.CustomDrillBlock;
import fr.iglee42.createcasing.blocks.customs.CustomEncasedFanBlock;
import fr.iglee42.createcasing.blocks.customs.CustomGearboxBlock;
import fr.iglee42.createcasing.blocks.customs.CustomGearshiftBlock;
import fr.iglee42.createcasing.blocks.customs.CustomHarvesterBlock;
import fr.iglee42.createcasing.blocks.customs.CustomMixerBlock;
import fr.iglee42.createcasing.blocks.customs.CustomPressBlock;
import fr.iglee42.createcasing.blocks.customs.CustomRollerBlock;
import fr.iglee42.createcasing.blocks.customs.CustomSawBlock;
import fr.iglee42.createcasing.blocks.customs.EncasedCustomCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicChainConveyorBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedPipeBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.CustomShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.EncasedCustomShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.WoodenShaftBlock;
import fr.iglee42.createcasing.casings.CasingSet;
import fr.iglee42.createcasing.casings.CasingSets;
import fr.iglee42.createcasing.config.CCStress;
import fr.iglee42.createcasing.items.WoodenCogwheelBlockItem;
import fr.iglee42.createcasing.registries.EncasedBlockStateGens;
import fr.iglee42.createcasing.registries.EncasedCreativeModeTabs;
import fr.iglee42.createcasing.registries.generators.CustomSawGenerator;
import fr.iglee42.createcasing.transmissions.TransmissionSet;
import fr.iglee42.createcasing.transmissions.TransmissionSets;
import fr.iglee42.createcasing.utils.CasingBuilderTransformers;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class EncasedBlocks {
    public static final BlockEntry<CreativeCogwheelBlock> CREATIVE_COGWHEEL;

    public static BlockEntry<CasingBlock> createCasing(String name, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_casing", CasingBlock::new).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.casing(() -> connectedTexturesSprite))).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeAll(c.getName(), Create.asResource((String)("block/" + c.getId().getPath()))))).simpleItem().register();
    }

    private static BlockEntry<PublicEncasedShaftBlock> createEncasedShaft(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return EncasedBlocks.createEncasedShaft(AllBlocks.SHAFT, name, casing, sprite, PublicEncasedShaftBlock::new);
    }

    private static <E extends ShaftBlock, T extends EncasedShaftBlock> BlockEntry<T> createEncasedShaft(BlockEntry<E> shaft, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = shaft.getId().getPath().replace("_shaft", "");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(shaft.equals((Object)AllBlocks.SHAFT) ? "" : "_" + s) + "_shaft", p -> (EncasedShaftBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedShaft(shaft, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(shaft))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createEncasedCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, CTSpriteShiftEntry sideSprite, CTSpriteShiftEntry otherSideSprite) {
        return EncasedBlocks.createEncasedCogwheel(AllBlocks.COGWHEEL, name, casing, sprite, sideSprite, otherSideSprite, (p, c) -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, (Supplier<Block>)c));
    }

    private static <E extends Block, T extends EncasedCogwheelBlock> BlockEntry<T> createEncasedCogwheel(BlockEntry<E> cogwheel, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, CTSpriteShiftEntry sideSprite, CTSpriteShiftEntry otherSideSprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = cogwheel.getId().getPath().replace("_cogwheel", "");
        BlockBuilder builder = (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(cogwheel.equals((Object)AllBlocks.COGWHEEL) ? "" : "_" + s) + "_cogwheel", p -> (EncasedCogwheelBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedCogwheel(cogwheel, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheel))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem);
        if (sprite != null) {
            builder = (BlockBuilder)builder.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(sprite, Couple.create((Object)sideSprite, (Object)otherSideSprite))));
        }
        return builder.register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createEncasedLargeCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return EncasedBlocks.createEncasedLargeCogwheel(AllBlocks.LARGE_COGWHEEL, name, casing, sprite, (p, c) -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, (Supplier<Block>)c));
    }

    private static <E extends CogWheelBlock, T extends EncasedCogwheelBlock> BlockEntry<T> createEncasedLargeCogwheel(BlockEntry<E> cogwheel, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = cogwheel.getId().getPath().replace("_large_cogwheel", "");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(cogwheel.equals((Object)AllBlocks.LARGE_COGWHEEL) ? "" : "_" + s) + "_large_cogwheel", p -> (EncasedCogwheelBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedLargeCogwheel(cogwheel, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheel))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedPipeBlock> createEncasedPipe(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        BlockBuilder<PublicEncasedPipeBlock, CreateRegistrate> builder = (BlockBuilder<PublicEncasedPipeBlock, CreateRegistrate>)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, casing)).initialProperties(SharedProperties::copperMetal).properties(p -> p.mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.encasedPipe(name)).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::withAO))).loot((p, b) -> p.dropOther((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem);
        builder = EncasedBlocks.connectedTexture(builder, sprite, (block, cc) -> cc.make((Block)block, sprite, (s, f) -> (Boolean)s.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false));
        return builder.register();
    }

    private static BlockEntry<CustomGearboxBlock> createGearbox(String name, CTSpriteShiftEntry sprite, Supplier<BlockItem> item) {
        BlockBuilder<CustomGearboxBlock, CreateRegistrate> entry = ((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_gearbox", p -> new CustomGearboxBlock((BlockBehaviour.Properties)p, item)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.gearbox(name));
        entry = EncasedBlocks.connectedTexture(entry, sprite, (block, cc) -> cc.make((Block)block, sprite, (s, f) -> f.getAxis() == s.getValue((Property)GearboxBlock.AXIS)));
        return ((BlockBuilder)entry.item().model((ctx, prov) -> ((ItemModelBuilder)prov.getBuilder(ctx.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.gearboxModel((RegistrateProvider)prov, name, "item")))).build()).register();
    }

    private static BlockEntry<CustomMixerBlock> createMixer(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mixer", CustomMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.STONE)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.mixer(name)).addLayer(() -> RenderType::cutoutMipped).transform(CCStress.setImpact(4.0))).item(AssemblyOperatorBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.mixerModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static BlockEntry<CustomPressBlock> createPress(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_press", CustomPressBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.press(name)).transform(CCStress.setImpact(8.0))).item(AssemblyOperatorBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.pressModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static BlockEntry<? extends ShaftBlock> createShaft(String name, java.util.function.Function<BlockBehaviour.Properties, ? extends ShaftBlock> factory) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_shaft", p -> factory != null ? (ShaftBlock)factory.apply((BlockBehaviour.Properties)p) : new CustomShaftBlock((BlockBehaviour.Properties)p)).initialProperties(SharedProperties::wooden).properties(p -> p.mapColor(MapColor.METAL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOnly())).blockstate(EncasedBlockStateGens.shaft(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.shaftModel((RegistrateProvider)p, name)))).build()).register();
    }

    private static BlockEntry<? extends CogWheelBlock> createCogwheel(String name, BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock> factory) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_cogwheel", p -> factory != null ? (CogWheelBlock)factory.apply((BlockBehaviour.Properties)p, false) : CustomCogwheelBlock.small(p)).initialProperties(SharedProperties::stone).properties(p -> p.sound(SoundType.WOOD).mapColor(MapColor.DIRT)).transform(CCStress.setNoImpact())).transform(TagGen.axeOnly())).blockstate(EncasedBlockStateGens.cogwheel(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(WoodenCogwheelBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.cogwheelModel((RegistrateProvider)p, name, true)))).build()).register();
    }

    private static BlockEntry<? extends CogWheelBlock> createLargeCogwheel(String name, BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock> factory) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_large_cogwheel", p -> factory != null ? (CogWheelBlock)factory.apply((BlockBehaviour.Properties)p, true) : CustomCogwheelBlock.large(p)).initialProperties(SharedProperties::stone).properties(p -> p.sound(SoundType.WOOD).mapColor(MapColor.DIRT)).transform(TagGen.axeOnly())).transform(CCStress.setNoImpact())).blockstate(EncasedBlockStateGens.largeCogwheel(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(WoodenCogwheelBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.largeCogwheelModel((RegistrateProvider)p, name, true)))).build()).register();
    }

    public static BlockEntry<CustomDepotBlock> createDepot(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_depot", CustomDepotBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_GRAY)).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.depot(name)).transform((NonNullFunction)DisplaySource.displaySource((RegistryEntry)AllDisplaySources.ITEM_NAMES))).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new MountedDepotInteractionBehaviour()))).transform((NonNullFunction)MountedItemStorageType.mountedItemStorage((RegistryEntry)AllMountedStorageTypes.DEPOT))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.depotModel((RegistrateProvider)p, name)))).build()).register();
    }

    public static BlockEntry<CustomChainDriveBlock> createChainDrive(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_chain_drive", p -> new CustomChainDriveBlock((BlockBehaviour.Properties)p, name)).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.encasedChainDrive(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.createChainDriveModel((RegistrateProvider)p, name, true, "item")))).build()).register();
    }

    public static BlockEntry<CustomChainGearshiftBlock> createChainGearshift(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_adjustable_chain_gearshift", p -> new CustomChainGearshiftBlock((BlockBehaviour.Properties)p, name)).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.NETHER)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.adjustableChainGearshift(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.createAdjustableChainGearshiftModel((RegistrateProvider)p, name, true, "item", false)))).build()).register();
    }

    public static BlockEntry<ConfigurableGearboxBlock> createConfigurableGearbox(String name, CTSpriteShiftEntry ct) {
        BlockBuilder entry = (BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_configurable_gearbox", ConfigurableGearboxBlock::new).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.configurableGearbox(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.createConfigurableGearboxItemModel(p, name))).build();
        if (ct != null) {
            entry = (BlockBuilder)((BlockBuilder)entry.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ct)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ct, (s, f) -> (Boolean)s.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(f)) == false)));
        }
        return entry.register();
    }

    public static BlockEntry<PublicChainConveyorBlock> createChainConveyor(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_chain_conveyor", PublicChainConveyorBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).transform(CCStress.setImpact(1.0))).blockstate(EncasedBlockStateGens.chainConveyor(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.createConveyorModel((RegistrateProvider)p, name, true))).build()).register();
    }

    public static BlockEntry<CustomGearshiftBlock> createGearshift(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_gearshift", CustomGearshiftBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).addLayer(() -> RenderType::cutoutMipped).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> EncasedBlockStateGens.axisBlock(c, p, EncasedBlockStateGens.gearshiftModel((RegistrateProvider)p, name), false)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.gearshiftItemModel((RegistrateProvider)p, name))).build()).register();
    }

    public static BlockEntry<CustomClutchBlock> createClutch(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_clutch", CustomClutchBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).addLayer(() -> RenderType::cutoutMipped).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> EncasedBlockStateGens.axisBlock(c, p, EncasedBlockStateGens.clutchModel((RegistrateProvider)p, name), false)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.clutchItemModel((RegistrateProvider)p, name))).build()).register();
    }

    public static BlockEntry<CustomDeployerBlock> createDeployer(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_deployer", CustomDeployerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> EncasedBlockStateGens.directionalAxisBlock(c, p, EncasedBlockStateGens.deployerModel((RegistrateProvider)p, name))).transform(CCStress.setImpact(4.0))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new DeployerMovementBehaviour()))).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new DeployerMovingInteraction()))).item(AssemblyOperatorBlockItem::new).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.deployerItemModel((RegistrateProvider)p, name))).build()).register();
    }

    public static BlockEntry<PortableStorageInterfaceBlock> createPortableStorageInterface(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_portable_storage_interface", PortableStorageInterfaceBlock::forItems).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.directionalBlock((Block)c.get(), EncasedBlockStateGens.storageInterfaceModel((RegistrateProvider)p, name, false))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new PortableStorageInterfaceMovement()))).item().tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.storageInterfaceModel((RegistrateProvider)p, name, true))).build()).register();
    }

    public static BlockEntry<CustomEncasedFanBlock> createEncasedFan(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_fan", CustomEncasedFanBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).blockstate((c, p) -> p.directionalBlock((Block)c.get(), EncasedBlockStateGens.fanModel((RegistrateProvider)p, name))).addLayer(() -> RenderType::cutoutMipped).transform(TagGen.axeOrPickaxe())).transform(CCStress.setImpact(2.0))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.fanItemModel((RegistrateProvider)p, name))).build()).register();
    }

    public static BlockEntry<CustomHarvesterBlock> createHarvester(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mechanical_harvester", CustomHarvesterBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.METAL).forceSolidOn()).transform(TagGen.axeOrPickaxe())).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new HarvesterMovementBehaviour()))).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), EncasedBlockStateGens.harvesterModel((RegistrateProvider)p, name, false))).addLayer(() -> RenderType::cutoutMipped).item().tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.harvesterModel((RegistrateProvider)p, name, true))).build()).register();
    }

    public static BlockEntry<PloughBlock> createPlough(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mechanical_plough", PloughBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_GRAY).forceSolidOn()).transform(TagGen.axeOrPickaxe())).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new PloughMovementBehaviour()))).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), EncasedBlockStateGens.ploughModel((RegistrateProvider)p, name))).item().tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)new ModelFile.ExistingModelFile(CreateCasing.asResource("block/mechanical_plough/" + name), p.existingFileHelper))).build()).register();
    }

    public static BlockEntry<CustomRollerBlock> createRoller(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mechanical_roller", CustomRollerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_GRAY).noOcclusion()).transform(TagGen.axeOrPickaxe())).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new RollerMovementBehaviour()))).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), EncasedBlockStateGens.rollerModel((RegistrateProvider)p, name, false))).addLayer(() -> RenderType::cutoutMipped).item(RollerBlockItem::new).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.rollerModel((RegistrateProvider)p, name, true))).build()).register();
    }

    public static BlockEntry<CustomSawBlock> createSaw(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mechanical_saw", CustomSawBlock::new).initialProperties(SharedProperties::stone).addLayer(() -> RenderType::cutoutMipped).properties(p -> p.mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).blockstate((arg_0, arg_1) -> ((CustomSawGenerator)new CustomSawGenerator(name)).generate(arg_0, arg_1)).transform(CCStress.setImpact(4.0))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new SawMovementBehaviour()))).addLayer(() -> RenderType::cutoutMipped).item().tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.sawItemModel((RegistrateProvider)p, name))).build()).register();
    }

    public static BlockEntry<CustomDrillBlock> createDrill(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mechanical_drill", CustomDrillBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.directionalBlock((Block)c.get(), EncasedBlockStateGens.drillModel((RegistrateProvider)p, name, false))).transform(CCStress.setImpact(4.0))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new DrillMovementBehaviour()))).item().tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.drillModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static <T extends Block> BlockBuilder<T, CreateRegistrate> connectedTexture(BlockBuilder<T, CreateRegistrate> entry, CTSpriteShiftEntry sprite, BiConsumer<T, CasingConnectivity> consumer) {
        if (sprite != null) {
            return (BlockBuilder)((BlockBuilder)entry.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(sprite)))).onRegister(CreateRegistrate.casingConnectivity(consumer));
        }
        return entry;
    }

    public static void register() {
        CreateCasing.KJS_HANDLER.dispatchRegisterEvent();
        CasingSets.getSets().forEach(set -> {
            if (set.doesGenerateCasing()) {
                set.setCasing((Supplier<? extends Block>)EncasedBlocks.createCasing(set.getName(), set.getConnectedTextureSprite()));
            }
            Supplier<Block> casing = set.getCasingSupplier();
            if (set.doesGenerateShaft()) {
                set.setShaft((Supplier<? extends Block>)EncasedBlocks.createEncasedShaft(set.getName(), casing, set.getConnectedTextureSprite()));
            }
            if (set.doesGenerateCogwheel()) {
                set.setCogwheel((Supplier<? extends Block>)EncasedBlocks.createEncasedCogwheel(set.getName(), casing, set.getConnectedTextureSprite(), set.getCogSideSprite(), set.getCogOtherSideSprite()));
            }
            if (set.doesGenerateLargeCogwheel()) {
                set.setLargeCogwheel((Supplier<? extends Block>)EncasedBlocks.createEncasedLargeCogwheel(set.getName(), casing, set.getConnectedTextureSprite()));
            }
            if (set.doesGenerateFluidPipe()) {
                set.setFluidPipe((Supplier<? extends Block>)EncasedBlocks.createEncasedPipe(set.getName(), casing, set.getConnectedTextureSprite()));
            }
            if (set.doesGenerateGearbox()) {
                set.setGearbox((Supplier<? extends Block>)EncasedBlocks.createGearbox(set.getName(), set.getConnectedTextureSprite(), () -> set.getVerticalGearboxItem()));
            }
            if (set.doesGeneratePress()) {
                set.setPress((Supplier<? extends Block>)EncasedBlocks.createPress(set.getName()));
            }
            if (set.doesGenerateMixer()) {
                set.setMixer((Supplier<? extends Block>)EncasedBlocks.createMixer(set.getName()));
            }
            if (set.doesGenerateDepot()) {
                set.setDepot((Supplier<? extends Block>)EncasedBlocks.createDepot(set.getName()));
            }
            if (set.doesGenerateChainDrive()) {
                set.setChainDrive((Supplier<? extends Block>)EncasedBlocks.createChainDrive(set.getName()));
            }
            if (set.doesGenerateChainGearshift()) {
                set.setChainGearshift((Supplier<? extends Block>)EncasedBlocks.createChainGearshift(set.getName()));
            }
            if (set.doesGenerateConfigurableGearbox()) {
                set.setConfigurableGearbox((Supplier<? extends Block>)EncasedBlocks.createConfigurableGearbox(set.getName(), set.getConnectedTextureSprite()));
            }
            if (set.doesGenerateChainConveyor()) {
                set.setChainConveyor((Supplier<? extends Block>)EncasedBlocks.createChainConveyor(set.getName()));
            }
            if (set.doesGenerateGearshift()) {
                set.setGearshift((Supplier<? extends Block>)EncasedBlocks.createGearshift(set.getName()));
            }
            if (set.doesGenerateClutch()) {
                set.setClutch((Supplier<? extends Block>)EncasedBlocks.createClutch(set.getName()));
            }
            if (set.doesGenerateDeployer()) {
                set.setDeployer((Supplier<? extends Block>)EncasedBlocks.createDeployer(set.getName()));
            }
            if (set.doesGenerateStorageInterface()) {
                set.setStorageInterface((Supplier<? extends Block>)EncasedBlocks.createPortableStorageInterface(set.getName()));
            }
            if (set.doesGenerateEncasedFan()) {
                set.setEncasedFan((Supplier<? extends Block>)EncasedBlocks.createEncasedFan(set.getName()));
            }
            if (set.doesGenerateHarvester()) {
                set.setHarvester((Supplier<? extends Block>)EncasedBlocks.createHarvester(set.getName()));
            }
            if (set.doesGenerateSaw()) {
                set.setSaw((Supplier<? extends Block>)EncasedBlocks.createSaw(set.getName()));
            }
            if (set.doesGenerateDrill()) {
                set.setDrill((Supplier<? extends Block>)EncasedBlocks.createDrill(set.getName()));
            }
            if (set.doesGeneratePlough()) {
                set.setPlough((Supplier<? extends Block>)EncasedBlocks.createPlough(set.getName()));
            }
            if (set.doesGenerateRoller()) {
                set.setRoller((Supplier<? extends Block>)EncasedBlocks.createRoller(set.getName()));
            }
        });
        TransmissionSets.getSets().forEach(set -> {
            if (set.doesGenerateShaft()) {
                set.setShaft(EncasedBlocks.createShaft(set.getName(), set.getShaftConstructor()));
            }
            if (set.doesGenerateCogwheel()) {
                set.setCogwheel(EncasedBlocks.createCogwheel(set.getName(), set.getCogwheelConstructor()));
            }
            if (set.doesGenerateLargeCogwheel()) {
                set.setLargeCogwheel(EncasedBlocks.createLargeCogwheel(set.getName(), set.getCogwheelConstructor()));
            }
        });
        CasingSets.getSets().stream().filter(CasingSet::doesGenerateEncasedWoodenShaft).forEach(set -> TransmissionSets.getSets().stream().filter(Predicate.not(TransmissionSet::isNotEncasable)).filter(TransmissionSet::doesGenerateShaft).forEach(tset -> {
            if (tset.getShaftSupplier() != null) {
                EncasedBlocks.createEncasedShaft(tset.getShaftSupplier(), set.getName(), () -> set.getCasing(), set.getConnectedTextureSprite(), (p, s) -> new EncasedCustomShaftBlock((BlockBehaviour.Properties)p, (Supplier<Block>)s, (Supplier<? extends Block>)tset.getShaftSupplier()));
            }
        }));
        CasingSets.getSets().stream().filter(CasingSet::doesGenerateEncasedWoodenCogwheel).forEach(set -> TransmissionSets.getSets().stream().filter(Predicate.not(TransmissionSet::isNotEncasable)).filter(TransmissionSet::doesGenerateCogwheel).forEach(tset -> {
            if (tset.getCogwheelSupplier() != null) {
                EncasedBlocks.createEncasedCogwheel(tset.getCogwheelSupplier(), set.getName(), () -> set.getCasing(), set.getConnectedTextureSprite(), set.getCogSideSprite(), set.getCogOtherSideSprite(), (p, s) -> new EncasedCustomCogwheelBlock((BlockBehaviour.Properties)p, false, (Supplier<Block>)s, (Supplier<? extends Block>)tset.getCogwheelSupplier()));
            }
        }));
        CasingSets.getSets().stream().filter(CasingSet::doesGenerateEncasedWoodenLargeCogwheel).forEach(set -> TransmissionSets.getSets().stream().filter(Predicate.not(TransmissionSet::isNotEncasable)).filter(TransmissionSet::doesGenerateLargeCogwheel).forEach(tset -> {
            if (tset.getLargeCogwheelSupplier() != null) {
                EncasedBlocks.createEncasedLargeCogwheel(tset.getLargeCogwheelSupplier(), set.getName(), () -> set.getCasing(), set.getConnectedTextureSprite(), (p, s) -> new EncasedCustomCogwheelBlock((BlockBehaviour.Properties)p, true, (Supplier<Block>)s, (Supplier<? extends Block>)tset.getLargeCogwheelSupplier()));
            }
        }));
    }

    public static boolean isWoodenShaftHasState(BlockState state) {
        return state.getBlock() instanceof WoodenShaftBlock;
    }

    public static void forEachShaft(Consumer<BlockEntry<? extends ShaftBlock>> action) {
        TransmissionSets.getSets().stream().filter(TransmissionSet::doesGenerateShaft).forEach(set -> action.accept(set.getShaftSupplier()));
    }

    public static void forEachCogwheel(Consumer<BlockEntry<? extends CogWheelBlock>> action) {
        TransmissionSets.getSets().stream().filter(TransmissionSet::doesGenerateCogwheel).forEach(set -> action.accept(set.getCogwheelSupplier()));
    }

    public static void forEachLargeCogwheel(Consumer<BlockEntry<? extends CogWheelBlock>> action) {
        TransmissionSets.getSets().stream().filter(TransmissionSet::doesGenerateLargeCogwheel).forEach(set -> action.accept(set.getLargeCogwheelSupplier()));
    }

    static {
        CreateCasing.REGISTRATE.setCreativeTab(EncasedCreativeModeTabs.MAIN_TAB);
        CREATIVE_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("creative_cogwheel", CreativeCogwheelBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_PURPLE)).properties(BlockBehaviour.Properties::noOcclusion).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> EncasedBlockStateGens.axisBlock(c, p, (Function<BlockState, ModelFile>)((Function)b -> new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/creative_cogwheel/block"))), false)).transform(CCStress.setCapacity(16384.0))).onRegister(BlockStressValues.setGeneratorSpeed((int)256, (boolean)true))).addLayer(() -> RenderType::cutoutMipped).item().properties(p -> p.rarity(Rarity.EPIC)).transform(ModelGen.customItemModel())).register();
    }
}

