/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.casings;

import com.google.common.base.Preconditions;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;

public class CasingSet {
    private final String name;
    private final Supplier<CTSpriteShiftEntry> ctSprite;
    @Nullable
    private final Supplier<CTSpriteShiftEntry> cogSideSprite;
    @Nullable
    private final Supplier<CTSpriteShiftEntry> cogOtherSideSprite;
    @Nullable
    private final Supplier<SpriteShiftEntry> beltSprite;
    @Nullable
    private BeltBlockEntity.CasingType beltCasingType;
    private Supplier<PartialModel> alongXBeltModel;
    private Supplier<PartialModel> alongZBeltModel;
    @Nullable
    private Supplier<? extends Block> casingBlock;
    @Nullable
    private Supplier<? extends Block> shaftBlock;
    @Nullable
    private Supplier<? extends Block> cogwheelBlock;
    @Nullable
    private Supplier<? extends Block> largeCogwheelBlock;
    @Nullable
    private Supplier<? extends Block> fluidPipeBlock;
    @Nullable
    private Supplier<? extends Block> gearboxBlock;
    @Nullable
    private Supplier<? extends BlockItem> verticalGearboxBlockItem;
    @Nullable
    private Supplier<? extends Block> pressBlock;
    @Nullable
    private Supplier<? extends Block> mixerBlock;
    @Nullable
    private Supplier<? extends Block> depotBlock;
    @Nullable
    private Supplier<? extends Block> chainDriveBlock;
    @Nullable
    private Supplier<? extends Block> chainGearshiftBlock;
    @Nullable
    private Supplier<? extends Block> configurableGearboxBlock;
    @Nullable
    private Supplier<? extends Block> chainConveyorBlock;
    @Nullable
    private Supplier<? extends Block> gearshiftBlock;
    @Nullable
    private Supplier<? extends Block> clutchBlock;
    @Nullable
    private Supplier<? extends Block> deployerBlock;
    @Nullable
    private Supplier<? extends Block> storageInterfaceBlock;
    @Nullable
    private Supplier<? extends Block> encasedFanBlock;
    @Nullable
    private Supplier<? extends Block> harvesterBlock;
    @Nullable
    private Supplier<? extends Block> sawBlock;
    @Nullable
    private Supplier<? extends Block> drillBlock;
    @Nullable
    private Supplier<? extends Block> ploughBlock;
    @Nullable
    private Supplier<? extends Block> rollerBlock;
    @Nullable
    private final Supplier<PartialModel> chainConveyorWheelModel;
    @Nullable
    private final Supplier<PartialModel> chainConveyorGuardModel;
    @Nullable
    private final Supplier<PartialModel> chainConveyorShaftModel;
    @Nullable
    private final Supplier<PartialModel> mixerHeadModel;
    @Nullable
    private final Supplier<PartialModel> drillHeadModel;
    @Nullable
    private final Supplier<PartialModel> rollerFrameModel;
    private final boolean casing;
    private final boolean shaft;
    private final boolean cogwheel;
    private final boolean largeCogwheel;
    private final boolean fluidPipe;
    private final boolean belt;
    private final boolean gearbox;
    private final boolean press;
    private final boolean mixer;
    private final boolean depot;
    private final boolean chainDrive;
    private final boolean chainGearshift;
    private final boolean configurableGearbox;
    private final boolean chainConveyor;
    private final boolean gearshift;
    private final boolean clutch;
    private final boolean deployer;
    private final boolean storageInterface;
    private final boolean encasedFan;
    private final boolean harvester;
    private final boolean saw;
    private final boolean drill;
    private final boolean plough;
    private final boolean roller;
    private final boolean encasedWoodenShaft;
    private final boolean encasedWoodenCogwheel;
    private final boolean encasedWoodenLargeCogwheel;
    private final boolean isKJSGenerated;

    protected CasingSet(String name, Options options) {
        this.name = name;
        Preconditions.checkNotNull(options.ctSprite, (Object)"Connected Texture Sprite Supplier can't be null");
        this.ctSprite = options.ctSprite;
        this.cogSideSprite = options.cogSideSprite;
        this.cogOtherSideSprite = options.cogOtherSideSprite;
        this.beltSprite = options.beltSprite;
        this.casingBlock = options.existingCasing;
        this.casing = options.casing;
        this.shaft = options.shaft;
        this.cogwheel = options.cogwheel;
        this.largeCogwheel = options.largeCogwheel;
        this.fluidPipe = options.fluidPipe;
        this.belt = options.belt;
        this.gearbox = options.gearbox;
        this.press = options.press;
        this.mixer = options.mixer;
        this.depot = options.depot;
        this.chainDrive = options.chainDrive;
        this.chainGearshift = options.chainGearshift;
        this.configurableGearbox = options.configurableGearbox;
        this.chainConveyor = options.chainConveyor;
        this.gearshift = options.gearshift;
        this.clutch = options.clutch;
        this.deployer = options.deployer;
        this.storageInterface = options.storageInterface;
        this.encasedFan = options.encasedFan;
        this.harvester = options.harvester;
        this.saw = options.saw;
        this.drill = options.drill;
        this.plough = options.plough;
        this.roller = options.roller;
        this.encasedWoodenShaft = options.encasedWoodenShaft;
        this.encasedWoodenCogwheel = options.encasedWoodenCogwheel;
        this.encasedWoodenLargeCogwheel = options.encasedWoodenLargeCogwheel;
        this.alongXBeltModel = options.alongXBeltModel;
        this.alongZBeltModel = options.alongZBeltModel;
        this.chainConveyorGuardModel = options.chainConveyorGuardModel;
        this.chainConveyorWheelModel = options.chainConveyorWheelModel;
        this.chainConveyorShaftModel = options.chainConveyorShaftModel;
        this.mixerHeadModel = options.mixerHeadModel;
        this.drillHeadModel = options.drillHeadModel;
        this.rollerFrameModel = options.rollerFrameModel;
        this.isKJSGenerated = options.kjsGenerated;
        if (options.existingShaft != null) {
            this.shaftBlock = options.existingShaft;
        }
        if (options.existingCogwheel != null) {
            this.cogwheelBlock = options.existingCogwheel;
        }
        if (options.existingLargeCogwheel != null) {
            this.largeCogwheelBlock = options.existingLargeCogwheel;
        }
        if (options.existingFluidPipe != null) {
            this.fluidPipeBlock = options.existingFluidPipe;
        }
        if (options.existingGearbox != null) {
            this.gearboxBlock = options.existingGearbox;
        }
        if (options.existingVerticalGearboxItem != null) {
            this.verticalGearboxBlockItem = options.existingVerticalGearboxItem;
        }
        if (options.existingPress != null) {
            this.pressBlock = options.existingPress;
        }
        if (options.existingMixer != null) {
            this.mixerBlock = options.existingMixer;
        }
        if (options.existingDepot != null) {
            this.depotBlock = options.existingDepot;
        }
        if (options.existingChainDrive != null) {
            this.chainDriveBlock = options.existingChainDrive;
        }
        if (options.existingChainGearshift != null) {
            this.chainGearshiftBlock = options.existingChainGearshift;
        }
        if (options.existingChainConveyor != null) {
            this.chainConveyorBlock = options.existingChainConveyor;
        }
        if (options.existingGearshift != null) {
            this.gearshiftBlock = options.existingGearshift;
        }
        if (options.existingClutch != null) {
            this.clutchBlock = options.existingClutch;
        }
        if (options.existingDeployer != null) {
            this.deployerBlock = options.existingDeployer;
        }
        if (options.existingStorageInterface != null) {
            this.storageInterfaceBlock = options.existingStorageInterface;
        }
        if (options.existingEncasedFan != null) {
            this.encasedFanBlock = options.existingEncasedFan;
        }
        if (options.existingHarvester != null) {
            this.harvesterBlock = options.existingHarvester;
        }
        if (options.existingSaw != null) {
            this.sawBlock = options.existingSaw;
        }
        if (options.existingDrill != null) {
            this.drillBlock = options.existingDrill;
        }
        if (options.existingPlough != null) {
            this.ploughBlock = options.existingPlough;
        }
        if (options.existingRoller != null) {
            this.rollerBlock = options.existingRoller;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean doesGenerateCasing() {
        return this.casing;
    }

    public boolean doesGenerateCogwheel() {
        return this.cogwheel;
    }

    public boolean doesGenerateShaft() {
        return this.shaft;
    }

    public boolean doesGenerateLargeCogwheel() {
        return this.largeCogwheel;
    }

    public boolean doesGenerateFluidPipe() {
        return this.fluidPipe;
    }

    public boolean doesGenerateBelt() {
        return this.belt;
    }

    public boolean doesGenerateGearbox() {
        return this.gearbox;
    }

    public boolean doesGeneratePress() {
        return this.press;
    }

    public boolean doesGenerateMixer() {
        return this.mixer;
    }

    public boolean doesGenerateDepot() {
        return this.depot;
    }

    public boolean doesGenerateChainDrive() {
        return this.chainDrive;
    }

    public boolean doesGenerateChainGearshift() {
        return this.chainGearshift;
    }

    public boolean doesGenerateConfigurableGearbox() {
        return this.configurableGearbox;
    }

    public boolean doesGenerateChainConveyor() {
        return this.chainConveyor;
    }

    public boolean doesGenerateGearshift() {
        return this.gearshift;
    }

    public boolean doesGenerateClutch() {
        return this.clutch;
    }

    public boolean doesGenerateDeployer() {
        return this.deployer;
    }

    public boolean doesGenerateStorageInterface() {
        return this.storageInterface;
    }

    public boolean doesGenerateEncasedFan() {
        return this.encasedFan;
    }

    public boolean doesGenerateHarvester() {
        return this.harvester;
    }

    public boolean doesGenerateSaw() {
        return this.saw;
    }

    public boolean doesGenerateDrill() {
        return this.drill;
    }

    public boolean doesGeneratePlough() {
        return this.plough;
    }

    public boolean doesGenerateRoller() {
        return this.roller;
    }

    public boolean doesGenerateEncasedWoodenShaft() {
        return this.encasedWoodenShaft;
    }

    public boolean doesGenerateEncasedWoodenCogwheel() {
        return this.encasedWoodenCogwheel;
    }

    public boolean doesGenerateEncasedWoodenLargeCogwheel() {
        return this.encasedWoodenLargeCogwheel;
    }

    @Nullable
    public Supplier<? extends Block> getCasingSupplier() {
        return this.casingBlock;
    }

    @Nullable
    public Block getCasing() {
        return this.casingBlock == null ? null : this.casingBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getShaftSupplier() {
        return this.shaftBlock;
    }

    @Nullable
    public Block getShaft() {
        return this.shaftBlock == null ? null : this.shaftBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getCogwheelSupplier() {
        return this.cogwheelBlock;
    }

    @Nullable
    public Block getCogwheel() {
        return this.cogwheelBlock == null ? null : this.cogwheelBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getLargeCogwheelSupplier() {
        return this.largeCogwheelBlock;
    }

    @Nullable
    public Block getLargeCogwheel() {
        return this.largeCogwheelBlock == null ? null : this.largeCogwheelBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getFluidPipeSupplier() {
        return this.fluidPipeBlock;
    }

    @Nullable
    public Block getFluidPipe() {
        return this.fluidPipeBlock == null ? null : this.fluidPipeBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getGearboxSupplier() {
        return this.gearboxBlock;
    }

    @Nullable
    public Block getGearbox() {
        return this.gearboxBlock == null ? null : this.gearboxBlock.get();
    }

    @Nullable
    public Supplier<? extends BlockItem> getVerticalGearboxItemSupplier() {
        return this.verticalGearboxBlockItem;
    }

    @Nullable
    public BlockItem getVerticalGearboxItem() {
        return this.verticalGearboxBlockItem == null ? null : this.verticalGearboxBlockItem.get();
    }

    @Nullable
    public Supplier<? extends Block> getPressSupplier() {
        return this.pressBlock;
    }

    @Nullable
    public Block getPress() {
        return this.pressBlock == null ? null : this.pressBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getMixerSupplier() {
        return this.mixerBlock;
    }

    @Nullable
    public Block getMixer() {
        return this.mixerBlock == null ? null : this.mixerBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getDepotSupplier() {
        return this.depotBlock;
    }

    @Nullable
    public Block getDepot() {
        return this.depotBlock == null ? null : this.depotBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getChainDriveSupplier() {
        return this.chainDriveBlock;
    }

    @Nullable
    public Block getChainDrive() {
        return this.chainDriveBlock == null ? null : this.chainDriveBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getChainGearshiftSupplier() {
        return this.chainGearshiftBlock;
    }

    @Nullable
    public Block getChainGearshift() {
        return this.chainGearshiftBlock == null ? null : this.chainGearshiftBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getConfigurableGearboxSupplier() {
        return this.configurableGearboxBlock;
    }

    @Nullable
    public Block getConfigurableGearbox() {
        return this.configurableGearboxBlock == null ? null : this.configurableGearboxBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getChainConveyorSupplier() {
        return this.chainConveyorBlock;
    }

    @Nullable
    public Block getChainConveyor() {
        return this.chainConveyorBlock == null ? null : this.chainConveyorBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getGearshiftSupplier() {
        return this.gearshiftBlock;
    }

    @Nullable
    public Block getGearshift() {
        return this.gearshiftBlock == null ? null : this.gearshiftBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getClutchSupplier() {
        return this.clutchBlock;
    }

    @Nullable
    public Block getClutch() {
        return this.clutchBlock == null ? null : this.clutchBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getDeployerSupplier() {
        return this.deployerBlock;
    }

    @Nullable
    public Block getDeployer() {
        return this.deployerBlock == null ? null : this.deployerBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getStorageInterfaceSupplier() {
        return this.storageInterfaceBlock;
    }

    @Nullable
    public Block getStorageInterface() {
        return this.storageInterfaceBlock == null ? null : this.storageInterfaceBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getEncasedFanSupplier() {
        return this.encasedFanBlock;
    }

    @Nullable
    public Block getEncasedFan() {
        return this.encasedFanBlock == null ? null : this.encasedFanBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getHarvesterSupplier() {
        return this.harvesterBlock;
    }

    @Nullable
    public Block getHarvester() {
        return this.harvesterBlock == null ? null : this.harvesterBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getSawSupplier() {
        return this.sawBlock;
    }

    @Nullable
    public Block getSaw() {
        return this.sawBlock == null ? null : this.sawBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getDrillSupplier() {
        return this.drillBlock;
    }

    @Nullable
    public Block getDrill() {
        return this.drillBlock == null ? null : this.drillBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getPloughSupplier() {
        return this.ploughBlock;
    }

    @Nullable
    public Block getPlough() {
        return this.ploughBlock == null ? null : this.ploughBlock.get();
    }

    @Nullable
    public Supplier<? extends Block> getRollerSupplier() {
        return this.rollerBlock;
    }

    @Nullable
    public Block getRoller() {
        return this.rollerBlock == null ? null : this.rollerBlock.get();
    }

    @Nullable
    public BeltBlockEntity.CasingType getBeltCasingType() {
        return this.beltCasingType;
    }

    public void setCasing(@Nonnull Supplier<? extends Block> casing) {
        if (this.getCasingSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a casing that has already been referenced");
        }
        this.casingBlock = casing;
    }

    public void setBeltCasingType(BeltBlockEntity.CasingType type) {
        if (this.getBeltCasingType() != null) {
            throw new UnsupportedOperationException("You cannot modify a belt casing type that has already been referenced");
        }
        this.beltCasingType = type;
    }

    public void setShaft(@Nonnull Supplier<? extends Block> shaft) {
        if (this.getShaftSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a shaft that has already been referenced");
        }
        this.shaftBlock = shaft;
    }

    public void setCogwheel(@Nonnull Supplier<? extends Block> cogwheel) {
        if (this.getCogwheelSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a cogwheel that has already been referenced");
        }
        this.cogwheelBlock = cogwheel;
    }

    public void setLargeCogwheel(@Nonnull Supplier<? extends Block> cogwheel) {
        if (this.getLargeCogwheelSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a large cogwheel that has already been referenced");
        }
        this.largeCogwheelBlock = cogwheel;
    }

    public void setFluidPipe(@Nonnull Supplier<? extends Block> pipe) {
        if (this.getFluidPipeSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a fluid pipe that has already been referenced");
        }
        this.fluidPipeBlock = pipe;
    }

    public void setGearbox(@Nonnull Supplier<? extends Block> gearbox) {
        if (this.getGearboxSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a gearbox that has already been referenced");
        }
        this.gearboxBlock = gearbox;
    }

    public void setVerticalGearboxItem(@Nonnull Supplier<? extends BlockItem> gearbox) {
        if (this.getVerticalGearboxItemSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a vertical gearbox item that has already been referenced");
        }
        this.verticalGearboxBlockItem = gearbox;
    }

    public void setPress(@Nonnull Supplier<? extends Block> press) {
        if (this.getPressSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a press that has already been referenced");
        }
        this.pressBlock = press;
    }

    public void setMixer(@Nonnull Supplier<? extends Block> mixer) {
        if (this.getMixerSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a mixer that has already been referenced");
        }
        this.mixerBlock = mixer;
    }

    public void setDepot(@Nonnull Supplier<? extends Block> depot) {
        if (this.getDepotSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a depot that has already been referenced");
        }
        this.depotBlock = depot;
    }

    public void setChainDrive(@Nonnull Supplier<? extends Block> chainDrive) {
        if (this.getChainDriveSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a chain drive that has already been referenced");
        }
        this.chainDriveBlock = chainDrive;
    }

    public void setChainGearshift(@Nonnull Supplier<? extends Block> chainGearshift) {
        if (this.getChainGearshift() != null) {
            throw new UnsupportedOperationException("You cannot modify a chain gearshift that has already been referenced");
        }
        this.chainGearshiftBlock = chainGearshift;
    }

    public void setConfigurableGearbox(@Nonnull Supplier<? extends Block> configurableGearbox) {
        if (this.getConfigurableGearboxSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a configurable gearbox that has already been referenced");
        }
        this.configurableGearboxBlock = configurableGearbox;
    }

    public void setChainConveyor(@Nonnull Supplier<? extends Block> chainConveyor) {
        if (this.getChainConveyorSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a chain conveyor that has already been referenced");
        }
        this.chainConveyorBlock = chainConveyor;
    }

    public void setGearshift(@Nonnull Supplier<? extends Block> gearshift) {
        if (this.getGearshiftSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a gearshift that has already been referenced");
        }
        this.gearshiftBlock = gearshift;
    }

    public void setClutch(@Nonnull Supplier<? extends Block> clutch) {
        if (this.getClutchSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a clutch that has already been referenced");
        }
        this.clutchBlock = clutch;
    }

    public void setDeployer(@Nonnull Supplier<? extends Block> deployer) {
        if (this.getDeployerSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a deployer that has already been referenced");
        }
        this.deployerBlock = deployer;
    }

    public void setStorageInterface(@Nonnull Supplier<? extends Block> storageInterface) {
        if (this.getStorageInterfaceSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a portable storage interface that has already been referenced");
        }
        this.storageInterfaceBlock = storageInterface;
    }

    public void setEncasedFan(@Nonnull Supplier<? extends Block> fan) {
        if (this.getEncasedFanSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify an encased fan that has already been referenced");
        }
        this.encasedFanBlock = fan;
    }

    public void setHarvester(@Nonnull Supplier<? extends Block> harvester) {
        if (this.getHarvesterSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a harvester that has already been referenced");
        }
        this.harvesterBlock = harvester;
    }

    public void setSaw(@Nonnull Supplier<? extends Block> saw) {
        if (this.getSawSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a saw that has already been referenced");
        }
        this.sawBlock = saw;
    }

    public void setDrill(@Nonnull Supplier<? extends Block> drill) {
        if (this.getDrillSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a drill that has already been referenced");
        }
        this.drillBlock = drill;
    }

    public void setPlough(@Nonnull Supplier<? extends Block> plough) {
        if (this.getPloughSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a plough that has already been referenced");
        }
        this.ploughBlock = plough;
    }

    public void setRoller(@Nonnull Supplier<? extends Block> roller) {
        if (this.getRollerSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a roller that has already been referenced");
        }
        this.rollerBlock = roller;
    }

    @Nullable
    public CTSpriteShiftEntry getConnectedTextureSprite() {
        return this.ctSprite.get();
    }

    @Nullable
    public CTSpriteShiftEntry getCogSideSprite() {
        return this.cogSideSprite != null ? this.cogSideSprite.get() : null;
    }

    @Nullable
    public CTSpriteShiftEntry getCogOtherSideSprite() {
        return this.cogOtherSideSprite != null ? this.cogOtherSideSprite.get() : null;
    }

    @Nullable
    public SpriteShiftEntry getBeltSprite() {
        return this.beltSprite != null ? this.beltSprite.get() : null;
    }

    public PartialModel getBeltPartialModel(boolean alongX) {
        return alongX ? this.alongXBeltModel.get() : this.alongZBeltModel.get();
    }

    @Nullable
    public PartialModel getChainConveyorGuardModel() {
        return this.chainConveyorGuardModel != null ? this.chainConveyorGuardModel.get() : null;
    }

    @Nullable
    public PartialModel getChainConveyorWheelModel() {
        return this.chainConveyorWheelModel != null ? this.chainConveyorWheelModel.get() : null;
    }

    @Nullable
    public PartialModel getChainConveyorShaftModel() {
        return this.chainConveyorShaftModel != null ? this.chainConveyorShaftModel.get() : null;
    }

    @Nullable
    public PartialModel getMixerHeadModel() {
        return this.mixerHeadModel != null ? this.mixerHeadModel.get() : null;
    }

    public PartialModel getDrillHeadModel() {
        return this.drillHeadModel != null ? this.drillHeadModel.get() : null;
    }

    public PartialModel getRollerFrameModel() {
        return this.rollerFrameModel != null ? this.rollerFrameModel.get() : null;
    }

    public boolean isInSet(Block block) {
        return block.equals(this.getCasing()) || block.equals(this.getShaft()) || block.equals(this.getCogwheel()) || block.equals(this.getLargeCogwheel()) || block.equals(this.getFluidPipe()) || block.equals(this.getGearbox()) || block.equals(this.getPress()) || block.equals(this.getMixer()) || block.equals(this.getDepot()) || block.equals(this.getChainDrive()) || block.equals(this.getChainGearshift()) || block.equals(this.getConfigurableGearbox()) || block.equals(this.getChainConveyor()) || block.equals(this.getGearshift()) || block.equals(this.getClutch()) || block.equals(this.getDeployer()) || block.equals(this.getStorageInterface()) || block.equals(this.getEncasedFan()) || block.equals(this.getHarvester()) || block.equals(this.getSaw()) || block.equals(this.getDrill()) || block.equals(this.getPlough()) || block.equals(this.getRoller());
    }

    public boolean isKJSGenerated() {
        return this.isKJSGenerated;
    }

    public static class Options {
        @Nullable
        private Supplier<CTSpriteShiftEntry> ctSprite = null;
        @Nullable
        private Supplier<CTSpriteShiftEntry> cogSideSprite = null;
        @Nullable
        private Supplier<CTSpriteShiftEntry> cogOtherSideSprite = null;
        @Nullable
        private Supplier<SpriteShiftEntry> beltSprite = null;
        @Nullable
        private Supplier<? extends Block> existingCasing = null;
        private boolean casing = false;
        private boolean shaft = false;
        private boolean cogwheel = false;
        private boolean largeCogwheel = false;
        private boolean fluidPipe = false;
        private boolean belt = false;
        private boolean gearbox = false;
        private boolean press;
        private boolean mixer;
        private boolean depot;
        private boolean chainDrive;
        private boolean chainGearshift;
        private boolean configurableGearbox;
        private boolean chainConveyor;
        private boolean gearshift;
        private boolean clutch;
        private boolean deployer;
        private boolean storageInterface;
        private boolean encasedFan;
        private boolean harvester;
        private boolean saw;
        private boolean drill;
        private boolean plough;
        private boolean roller;
        private boolean kjsGenerated = false;
        private boolean encasedWoodenShaft;
        private boolean encasedWoodenCogwheel;
        private boolean encasedWoodenLargeCogwheel;
        private Supplier<PartialModel> alongXBeltModel = () -> null;
        private Supplier<PartialModel> alongZBeltModel = () -> null;
        private Supplier<PartialModel> chainConveyorWheelModel;
        private Supplier<PartialModel> chainConveyorGuardModel;
        private Supplier<PartialModel> chainConveyorShaftModel;
        private Supplier<PartialModel> mixerHeadModel;
        private Supplier<PartialModel> drillHeadModel;
        private Supplier<PartialModel> rollerFrameModel;
        @Nullable
        private Supplier<? extends Block> existingShaft;
        @Nullable
        private Supplier<? extends Block> existingCogwheel;
        @Nullable
        private Supplier<? extends Block> existingLargeCogwheel;
        @Nullable
        private Supplier<? extends Block> existingFluidPipe;
        @Nullable
        private Supplier<? extends Block> existingGearbox;
        @Nullable
        private Supplier<? extends BlockItem> existingVerticalGearboxItem;
        @Nullable
        private Supplier<? extends Block> existingPress;
        @Nullable
        private Supplier<? extends Block> existingMixer;
        @Nullable
        private Supplier<? extends Block> existingDepot;
        @Nullable
        private Supplier<? extends Block> existingChainDrive;
        @Nullable
        private Supplier<? extends Block> existingChainGearshift;
        @Nullable
        private Supplier<? extends Block> existingChainConveyor;
        @Nullable
        private Supplier<? extends Block> existingGearshift;
        @Nullable
        private Supplier<? extends Block> existingClutch;
        @Nullable
        private Supplier<? extends Block> existingDeployer;
        @Nullable
        private Supplier<? extends Block> existingStorageInterface;
        @Nullable
        private Supplier<? extends Block> existingEncasedFan;
        @Nullable
        private Supplier<? extends Block> existingHarvester;
        @Nullable
        private Supplier<? extends Block> existingSaw;
        @Nullable
        private Supplier<? extends Block> existingDrill;
        @Nullable
        private Supplier<? extends Block> existingPlough;
        @Nullable
        private Supplier<? extends Block> existingRoller;

        public Options ctSprite(Supplier<CTSpriteShiftEntry> ctSprite) {
            Preconditions.checkNotNull(ctSprite, (Object)"Connected Texture Sprite Supplier can't be null");
            this.ctSprite = ctSprite;
            return this;
        }

        public Options existingCasing(Supplier<? extends Block> casing) {
            this.existingCasing = casing;
            this.casing = false;
            return this;
        }

        public Options casing() {
            Preconditions.checkState((this.existingCasing == null ? 1 : 0) != 0, (Object)"Cannot create a casing if an existing casing was already set");
            this.casing = true;
            return this;
        }

        public Options shaft() {
            this.shaft = true;
            return this;
        }

        public Options cogwheel(@Nullable Supplier<CTSpriteShiftEntry> sideSprite, @Nullable Supplier<CTSpriteShiftEntry> otherSideSprite) {
            this.cogwheel = true;
            if (sideSprite != null && this.cogSideSprite == null) {
                this.cogSideSprite = sideSprite;
            }
            if (otherSideSprite != null && this.cogOtherSideSprite == null) {
                this.cogOtherSideSprite = otherSideSprite;
            }
            return this;
        }

        public Options largeCogwheel() {
            this.largeCogwheel = true;
            return this;
        }

        public Options fluidPipe() {
            this.fluidPipe = true;
            return this;
        }

        public Options belt(@Nonnull Supplier<SpriteShiftEntry> sprite, Supplier<PartialModel> alongXBeltModel, Supplier<PartialModel> alongZBeltModel) {
            this.belt = true;
            this.beltSprite = sprite;
            this.alongXBeltModel = alongXBeltModel;
            this.alongZBeltModel = alongZBeltModel;
            return this;
        }

        public Options gearbox() {
            this.gearbox = true;
            return this;
        }

        public Options press() {
            this.press = true;
            return this;
        }

        public Options mixer(Supplier<PartialModel> headModel) {
            this.mixer = true;
            this.mixerHeadModel = headModel;
            return this;
        }

        public Options depot() {
            this.depot = true;
            return this;
        }

        public Options deployer() {
            this.deployer = true;
            return this;
        }

        public Options portableStorageInterface() {
            this.storageInterface = true;
            return this;
        }

        public Options chainDrive() {
            this.chainDrive = true;
            return this;
        }

        public Options chainGearshift() {
            this.chainGearshift = true;
            return this;
        }

        public Options configurableGearbox() {
            this.configurableGearbox = true;
            return this;
        }

        public Options gearshift() {
            this.gearshift = true;
            return this;
        }

        public Options clutch() {
            this.clutch = true;
            return this;
        }

        public Options encasedFan() {
            this.encasedFan = true;
            return this;
        }

        public Options harvester() {
            this.harvester = true;
            return this;
        }

        public Options saw() {
            this.saw = true;
            return this;
        }

        public Options drill(Supplier<PartialModel> headModel) {
            this.drill = true;
            this.drillHeadModel = headModel;
            return this;
        }

        public Options plough() {
            this.plough = true;
            return this;
        }

        public Options roller(Supplier<PartialModel> frameModel) {
            this.roller = true;
            this.rollerFrameModel = frameModel;
            return this;
        }

        public Options encasedWoodenShaft() {
            this.encasedWoodenShaft = true;
            return this;
        }

        public Options encasedWoodenCogwheel() {
            this.encasedWoodenCogwheel = true;
            return this;
        }

        public Options encasedWoodenLargeCogwheel() {
            this.encasedWoodenLargeCogwheel = true;
            return this;
        }

        public Options chainConveyor(Supplier<PartialModel> guard, Supplier<PartialModel> wheel, Supplier<PartialModel> shaft) {
            this.chainConveyor = true;
            this.chainConveyorGuardModel = guard;
            this.chainConveyorWheelModel = wheel;
            this.chainConveyorShaftModel = shaft;
            return this;
        }

        public Options processingBlocks(Supplier<PartialModel> mixerHeadModel) {
            return this.press().mixer(mixerHeadModel).depot().deployer().encasedFan();
        }

        public Options complexTransmissionBlocks(Supplier<PartialModel> conveyorGuard, Supplier<PartialModel> conveyorWheel, Supplier<PartialModel> conveyorShaft) {
            return this.gearbox().chainDrive().chainGearshift().configurableGearbox().chainConveyor(conveyorGuard, conveyorWheel, conveyorShaft).gearshift().clutch();
        }

        public Options simpleTransmissions(@Nullable Supplier<CTSpriteShiftEntry> cogwheelSideSprite, @Nullable Supplier<CTSpriteShiftEntry> cogwheelOtherSideSprite) {
            return this.shaft().cogwheel(cogwheelSideSprite, cogwheelOtherSideSprite).largeCogwheel();
        }

        public Options encasedCustomTransmissionBlocks() {
            return this.encasedWoodenShaft().encasedWoodenCogwheel().encasedWoodenLargeCogwheel();
        }

        public Options contraptionBlocks(Supplier<PartialModel> headModel, Supplier<PartialModel> rollerFrameModel) {
            return this.portableStorageInterface().harvester().saw().drill(headModel).plough().roller(rollerFrameModel);
        }

        public Options fluids() {
            return this.fluidPipe();
        }

        public Options everythingExceptCasing(Supplier<CTSpriteShiftEntry> ctSprite, @Nonnull Supplier<SpriteShiftEntry> beltSprite, Supplier<PartialModel> alongXBeltModel, Supplier<PartialModel> alongZBeltModel, @Nullable Supplier<CTSpriteShiftEntry> cogwheelSideSprite, @Nullable Supplier<CTSpriteShiftEntry> cogwheelOtherSideSprite, Supplier<PartialModel> conveyorGuard, Supplier<PartialModel> conveyorWheel, Supplier<PartialModel> conveyorShaft, Supplier<PartialModel> mixerHeadModel, Supplier<PartialModel> drillHeadModel, Supplier<PartialModel> rollerFrameModel) {
            return this.ctSprite(ctSprite).contraptionBlocks(drillHeadModel, rollerFrameModel).encasedCustomTransmissionBlocks().simpleTransmissions(cogwheelSideSprite, cogwheelOtherSideSprite).belt(beltSprite, alongXBeltModel, alongZBeltModel).processingBlocks(mixerHeadModel).complexTransmissionBlocks(conveyorGuard, conveyorWheel, conveyorShaft).fluids();
        }

        public Options everything(Supplier<CTSpriteShiftEntry> ctSprite, @Nonnull Supplier<SpriteShiftEntry> beltSprite, Supplier<PartialModel> alongXBeltModel, Supplier<PartialModel> alongZBeltModel, @Nullable Supplier<CTSpriteShiftEntry> cogwheelSideSprite, @Nullable Supplier<CTSpriteShiftEntry> cogwheelOtherSideSprite, Supplier<PartialModel> conveyorGuard, Supplier<PartialModel> conveyorWheel, Supplier<PartialModel> conveyorShaft, Supplier<PartialModel> mixerHeadModel, Supplier<PartialModel> drillHeadModel, Supplier<PartialModel> rollerFrameModel) {
            return this.casing().everythingExceptCasing(ctSprite, beltSprite, alongXBeltModel, alongZBeltModel, cogwheelSideSprite, cogwheelOtherSideSprite, conveyorGuard, conveyorWheel, conveyorShaft, mixerHeadModel, drillHeadModel, rollerFrameModel);
        }

        Options existingShaft(Supplier<? extends Block> shaft) {
            this.existingShaft = shaft;
            this.shaft = false;
            return this;
        }

        Options existingCogwheel(Supplier<? extends Block> cogwheel) {
            this.existingCogwheel = cogwheel;
            this.cogwheel = false;
            return this;
        }

        Options existingLargeCogwheel(Supplier<? extends Block> largeCogwheel) {
            this.existingLargeCogwheel = largeCogwheel;
            this.largeCogwheel = false;
            return this;
        }

        Options existingFluidPipe(Supplier<? extends Block> fluidPipe) {
            this.existingFluidPipe = fluidPipe;
            this.fluidPipe = false;
            return this;
        }

        Options existingGearbox(Supplier<? extends Block> gearbox, Supplier<? extends BlockItem> existingVerticalGearboxItem) {
            this.existingGearbox = gearbox;
            this.existingVerticalGearboxItem = existingVerticalGearboxItem;
            this.gearbox = false;
            return this;
        }

        Options existingPress(Supplier<? extends Block> press) {
            this.existingPress = press;
            this.press = false;
            return this;
        }

        Options existingMixer(Supplier<? extends Block> mixer) {
            this.existingMixer = mixer;
            this.mixer = false;
            return this;
        }

        Options existingDepot(Supplier<? extends Block> depot) {
            this.existingDepot = depot;
            this.depot = false;
            return this;
        }

        Options existingChainDrive(Supplier<? extends Block> chainDrive) {
            this.existingChainDrive = chainDrive;
            this.chainDrive = false;
            return this;
        }

        Options existingChainGearshift(Supplier<? extends Block> chainGearshift) {
            this.existingChainGearshift = chainGearshift;
            this.chainGearshift = false;
            return this;
        }

        Options existingChainConveyor(Supplier<? extends Block> chainConveyor) {
            this.existingChainConveyor = chainConveyor;
            this.chainConveyor = false;
            return this;
        }

        Options existingGearshift(Supplier<? extends Block> gearshift) {
            this.existingGearshift = gearshift;
            this.gearshift = false;
            return this;
        }

        Options existingClutch(Supplier<? extends Block> clutch) {
            this.existingClutch = clutch;
            this.clutch = false;
            return this;
        }

        Options existingDeployer(Supplier<? extends Block> deployer) {
            this.existingDeployer = deployer;
            this.deployer = false;
            return this;
        }

        Options existingPortableStorageInterface(Supplier<? extends Block> storageInterface) {
            this.existingStorageInterface = storageInterface;
            this.storageInterface = false;
            return this;
        }

        Options existingEncasedFan(Supplier<? extends Block> fan) {
            this.existingEncasedFan = fan;
            this.encasedFan = false;
            return this;
        }

        Options existingHarvester(Supplier<? extends Block> harvester) {
            this.existingHarvester = harvester;
            this.harvester = false;
            return this;
        }

        Options existingSaw(Supplier<? extends Block> saw) {
            this.existingSaw = saw;
            this.saw = false;
            return this;
        }

        Options existingDrill(Supplier<? extends Block> drill) {
            this.existingDrill = drill;
            this.drill = false;
            return this;
        }

        Options existingPlough(Supplier<? extends Block> plough) {
            this.existingPlough = plough;
            this.plough = false;
            return this;
        }

        Options existingRoller(Supplier<? extends Block> roller) {
            this.existingRoller = roller;
            this.roller = false;
            return this;
        }

        public Options kjsGenerated() {
            this.kjsGenerated = true;
            return this;
        }
    }
}

