/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;

public final class TooltipUtil {
    private TooltipUtil() {
    }

    public static void appendItemEffectTooltips(ItemStack itemStack, List<Component> tooltipLines) {
        SuspiciousStewEffects stewEffects;
        FoodProperties foodProperties;
        record EffectRow(MobEffectInstance instance, float probability, boolean showChance) {
        }
        ArrayList<EffectRow> collectedEffects = new ArrayList<EffectRow>();
        PotionContents potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            for (Object mobEffectInstance : potionContents.getAllEffects()) {
                collectedEffects.add(new EffectRow((MobEffectInstance)mobEffectInstance, 1.0f, false));
            }
        }
        if ((foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD)) != null) {
            for (FoodProperties.PossibleEffect possibleEffect : foodProperties.effects()) {
                collectedEffects.add(new EffectRow(possibleEffect.effect(), possibleEffect.probability(), true));
            }
        }
        if ((stewEffects = (SuspiciousStewEffects)itemStack.get(DataComponents.SUSPICIOUS_STEW_EFFECTS)) != null) {
            stewEffects.effects().forEach(stewEntry -> {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(stewEntry.effect(), stewEntry.duration(), 0);
                collectedEffects.add(new EffectRow(mobEffectInstance, 1.0f, false));
            });
        }
        if (collectedEffects.isEmpty()) {
            return;
        }
        collectedEffects.sort(Comparator.comparingInt(row -> ((MobEffect)row.instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL ? 1 : 0).thenComparingInt(row -> -row.instance.getAmplifier()).thenComparing(row -> ((MobEffect)row.instance.getEffect().value()).getDisplayName().getString()));
        for (EffectRow effectRow : collectedEffects) {
            tooltipLines.add(TooltipUtil.formatEffectLine(effectRow.instance));
        }
        tooltipLines.add((Component)Component.empty());
    }

    public static Component styledKeyFromMapping(KeyMapping keyMapping, boolean isActive) {
        return keyMapping.getTranslatedKeyMessage().copy().withStyle(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY);
    }

    public static Component styledKey(Component keyComponent, boolean isActive) {
        return keyComponent.copy().withStyle(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY);
    }

    private static Component formatEffectLine(MobEffectInstance mobEffectInstance) {
        MobEffect mobEffect = (MobEffect)mobEffectInstance.getEffect().value();
        Component effectDisplayName = mobEffect.getDisplayName();
        int amplifier = mobEffectInstance.getAmplifier();
        int totalTicks = mobEffectInstance.getDuration();
        MutableComponent effectLine = Component.literal((String)"").append(effectDisplayName);
        if (amplifier > 0) {
            effectLine.append((Component)Component.literal((String)(" " + TooltipUtil.toRomanNumeral(amplifier + 1))));
        }
        if (totalTicks > 0) {
            effectLine.append((Component)Component.literal((String)(" (" + TooltipUtil.formatDurationTicksToMMSS(totalTicks) + ")")));
        }
        ChatFormatting lineColor = switch (mobEffect.getCategory()) {
            case MobEffectCategory.BENEFICIAL -> ChatFormatting.BLUE;
            case MobEffectCategory.HARMFUL -> ChatFormatting.RED;
            default -> ChatFormatting.GRAY;
        };
        return effectLine.withStyle(lineColor);
    }

    private static String formatDurationTicksToMMSS(int durationTicks) {
        int totalSeconds = Math.max(0, durationTicks / 20);
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static String toRomanNumeral(int value) {
        int[] arabic = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] roman = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int remaining = Math.max(1, Math.min(3999, value));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < arabic.length; ++i) {
            while (remaining >= arabic[i]) {
                remaining -= arabic[i];
                result.append(roman[i]);
            }
        }
        return result.toString();
    }
}

