/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.utils;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.level.Level;

public final class SidedResultsUtil {
    private SidedResultsUtil() {
    }

    public static InteractionResult blockSidedSuccess(Level level) {
        return SidedResultsUtil.blockSidedSuccess(level.isClientSide);
    }

    public static InteractionResult blockSidedSuccess(boolean clientSide) {
        return clientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    public static ItemInteractionResult itemSidedSuccess(Level level) {
        return SidedResultsUtil.itemSidedSuccess(level.isClientSide);
    }

    public static ItemInteractionResult itemSidedSuccess(boolean clientSide) {
        return ItemInteractionResult.sidedSuccess((boolean)false);
    }

    public static ItemInteractionResult itemConsume(Level level) {
        return SidedResultsUtil.itemConsume(level.isClientSide);
    }

    public static ItemInteractionResult itemConsume(boolean clientSide) {
        return ItemInteractionResult.sidedSuccess((boolean)true);
    }

    public static InteractionResult pass() {
        return InteractionResult.PASS;
    }

    public static InteractionResult fail() {
        return InteractionResult.FAIL;
    }

    public static InteractionResult consume() {
        return InteractionResult.CONSUME;
    }

    public static InteractionResult success() {
        return InteractionResult.SUCCESS;
    }

    public static ItemInteractionResult passToDefault() {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

