/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import me.itzme1on.alcocraftplus.AlcoCraftPlus;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipes;
import me.itzme1on.alcocraftplus.core.utils.IdentifierUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipesRegistry {
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"alcocraftplus", (ResourceKey)Registries.RECIPE_SERIALIZER);
    public static final RegistrySupplier<RecipeSerializer<KegRecipes>> KEG_RECIPE_SERIALIZER = RecipesRegistry.create(KegRecipes.Serializer::new);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"alcocraftplus", (ResourceKey)Registries.RECIPE_TYPE);
    public static final RegistrySupplier<RecipeType<KegRecipes>> KEG_RECIPE_TYPE = RecipesRegistry.create();

    private RecipesRegistry() {
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register(IdentifierUtil.of("beer_brewing"), serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create() {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return "beer_brewing";
            }
        };
        return RECIPE_TYPES.register(IdentifierUtil.of("beer_brewing"), type);
    }

    public static void register() {
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
        AlcoCraftPlus.LOGGER.info("Initializing recipes for AlcoCraftPlus");
    }
}

