/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.items;

import java.util.List;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.SidedResultsUtil;
import me.itzme1on.alcocraftplus.core.utils.TooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MugItem
extends BlockItem {
    public MugItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipLines, TooltipFlag tooltipFlag) {
        boolean isShiftHeld = Screen.hasShiftDown();
        TooltipUtil.appendItemEffectTooltips(itemStack, tooltipLines);
        Component keyShiftBind = TooltipUtil.styledKeyFromMapping(Minecraft.getInstance().options.keyShift, isShiftHeld);
        Component keyUseBind = TooltipUtil.styledKeyFromMapping(Minecraft.getInstance().options.keyUse, isShiftHeld);
        MutableComponent keyShift = Component.translatable((String)"alcocraftplus.tooltip.key_shift").withStyle(ChatFormatting.GRAY);
        if (!isShiftHeld) {
            tooltipLines.add((Component)Component.translatable((String)"alcocraftplus.tooltip.mug.default", (Object[])new Object[]{keyShift}).withStyle(ChatFormatting.DARK_GRAY));
        } else {
            tooltipLines.add((Component)Component.translatable((String)"alcocraftplus.tooltip.mug.place.line1", (Object[])new Object[]{keyShiftBind}).withStyle(ChatFormatting.DARK_GRAY));
            tooltipLines.add((Component)Component.empty());
            tooltipLines.add((Component)Component.translatable((String)"alcocraftplus.tooltip.mug.place.line2", (Object[])new Object[]{keyUseBind}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && !player.isShiftKeyDown()) {
            return SidedResultsUtil.pass();
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        if (stack.is((Item)ItemsRegistry.MUG.get())) {
            return InteractionResultHolder.pass((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.finishUsingItem(stack, level, entity);
        ItemStack emptyMug = new ItemStack((ItemLike)ItemsRegistry.MUG.get());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                if (result.isEmpty()) {
                    return emptyMug;
                }
                if (!player.getInventory().add(emptyMug)) {
                    player.drop(emptyMug, false);
                }
            }
        }
        return result;
    }
}

