/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import java.util.Optional;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.helpers.ImplementedInventory;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipeInput;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipes;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KegEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
BlockEntityTicker<KegEntity> {
    public static final int MAX_BUCKETS = 4;
    public static final int MAX_MUGS = 8;
    public static final int MAX_WATER_LEVEL = 32;
    public static final int WATER_PER_BUCKET = 8;
    public static final int BEER_PER_MUG = 4;
    private static final int MAX_PROGRESS = 18000;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public int waterLevel = 0;
    public int beerLevel = 0;
    public int beerType = 0;
    private int progress = 0;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> KegEntity.this.progress;
                case 1 -> 18000;
                case 2 -> KegEntity.this.waterLevel;
                case 3 -> KegEntity.this.beerLevel;
                case 4 -> KegEntity.this.beerType;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    KegEntity.this.progress = value;
                    break;
                }
                case 2: {
                    KegEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    KegEntity.this.beerLevel = value;
                    break;
                }
                case 4: {
                    KegEntity.this.beerType = value;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public KegEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.KEG_ENTITY.get(), pos, state);
    }

    private static Optional<RecipeHolder<KegRecipes>> findMatchingRecipe(KegEntity entity) {
        if (entity.level == null || entity.level.getServer() == null) {
            return Optional.empty();
        }
        KegRecipeInput input = new KegRecipeInput(entity.inventory);
        return entity.level.getServer().getRecipeManager().getRecipeFor((RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get(), (RecipeInput)input, entity.level);
    }

    private static Optional<RecipeHolder<KegRecipes>> canBrewRecipe(KegEntity entity) {
        Optional<RecipeHolder<KegRecipes>> match = KegEntity.findMatchingRecipe(entity);
        if (match.isPresent() && !KegEntity.hasBeer(entity) && KegEntity.hasWater(entity)) {
            return match;
        }
        return Optional.empty();
    }

    private static boolean hasWater(KegEntity entity) {
        return entity.waterLevel > 0;
    }

    private static boolean hasBeer(KegEntity entity) {
        return entity.beerLevel > 0;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.alcocraftplus.keg");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new KegGuiHandler(id, inventory, (Container)this, this.propertyDelegate);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.progress = nbt.getInt("progress");
        this.waterLevel = nbt.getInt("waterLevel");
        this.beerLevel = nbt.getInt("beerLevel");
        this.beerType = nbt.getInt("beerType");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        nbt.putInt("progress", this.progress);
        nbt.putInt("waterLevel", this.waterLevel);
        nbt.putInt("beerLevel", this.beerLevel);
        nbt.putInt("beerType", this.beerType);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index >= 0 && index < this.inventory.size();
    }

    public void tick(Level level, BlockPos pos, BlockState state, KegEntity entity) {
        if (!level.isClientSide()) {
            RandomSource random = level.random;
            Optional<RecipeHolder<KegRecipes>> match = KegEntity.canBrewRecipe(entity);
            if (match.isPresent()) {
                ++entity.progress;
                if (random.nextFloat() < 0.005f) {
                    level.playSound(null, pos, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.1f, 0.5f);
                }
                if (entity.progress >= 18000) {
                    this.brew(level, pos, state, entity, match.get());
                }
            } else {
                entity.resetProgress();
            }
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return this.level != null && this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    private void brew(Level level, BlockPos pos, BlockState state, KegEntity entity, RecipeHolder<KegRecipes> holder) {
        for (int i = 0; i < entity.inventory.size(); ++i) {
            if (((ItemStack)entity.inventory.get(i)).isEmpty()) continue;
            ((ItemStack)entity.inventory.get(i)).shrink(1);
        }
        entity.beerType = BeerTypeMapperUtil.getBeerType(((KegRecipes)holder.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
        int fullMugs = entity.waterLevel / 4;
        entity.beerLevel = fullMugs * 4;
        entity.waterLevel = 0;
        entity.resetProgress();
        KegEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

