/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.hop;

import me.itzme1on.alcocraftplus.core.registries.BlocksRegistry;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.SidedResultsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class Hop
extends CaveVinesBlock {
    public Hop(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (random.nextDouble() < 0.1) {
            this.performBonemeal(level, random, pos, state);
        }
    }

    @NotNull
    protected Block getBodyBlock() {
        return (Block)BlocksRegistry.HOP_PLANT.get();
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ItemsRegistry.HOP.get());
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistry.HOP.get(), 1));
            float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.FALSE), 2);
            return SidedResultsUtil.blockSidedSuccess(level);
        }
        return SidedResultsUtil.pass();
    }
}

