/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmsvcc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.api.IClientAPI;
import com.tom.cpm.shared.MinecraftClientAccess;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPMSVCC {
    public static final String MOD_ID = "cpmsvcc";
    public static final Logger LOGGER = LogManager.getLogger((String)"CPM-SVC Compat");
    private static final LoadingCache<UUID, Float> voiceLevelsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build(CacheLoader.from(() -> Float.valueOf(0.0f)));
    public static final Set<UUID> muted = new HashSet<UUID>();
    public static IClientAPI.MessageSender mutedSender;

    public static float get(UUID uuid) {
        try {
            return ((Float)voiceLevelsCache.get((Object)uuid)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static void handle(short[] data) {
        CPMSVCC.handle(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID(), data);
    }

    public static void handle(UUID uuid, short[] data) {
        voiceLevelsCache.put((Object)uuid, (Object)Float.valueOf(data == null ? 0.0f : CPMSVCC.calcVoiceLevel(data)));
    }

    private static float calcVoiceLevel(short[] data) {
        return (float)CPMSVCC.dbToPerc(CPMSVCC.getHighestAudioLevel(data));
    }

    public static void setMuted(boolean muted) {
        if (mutedSender != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setBoolean("muted", muted);
            mutedSender.sendMessage(tag);
        }
        if (muted) {
            CPMSVCC.muted.add(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID());
        } else {
            CPMSVCC.muted.remove(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID());
        }
    }

    public static boolean isMuted(UUID uuid) {
        return muted.contains(uuid);
    }

    private static double calculateAudioLevel(short[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; ++i) {
            double sample = (double)samples[i] / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    private static double getHighestAudioLevel(short[] samples) {
        double highest = -127.0;
        for (int i = 0; i < samples.length; i += 100) {
            double level = CPMSVCC.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level > highest)) continue;
            highest = level;
        }
        return highest;
    }

    private static double dbToPerc(double db) {
        return (db + 127.0) / 127.0;
    }
}

