/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.models;

import ca.fxco.moreculling.api.model.BakedOpacity;
import ca.fxco.moreculling.api.quad.QuadOpacity;
import ca.fxco.moreculling.platform.Services;
import ca.fxco.moreculling.utils.BitUtils;
import ca.fxco.moreculling.utils.CullingUtils;
import ca.fxco.moreculling.utils.DirectionUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WeightedBakedModel.class}, priority=1010)
public abstract class WeightedBakedModel_cacheMixin
implements BakedOpacity {
    @Unique
    private byte solidFaces = 0;

    @Override
    public boolean moreculling$hasTextureTranslucency(@Nullable BlockState blockState, @Nullable Direction direction) {
        if (direction == null) {
            return this.solidFaces != 63;
        }
        return !BitUtils.get(this.solidFaces, direction.ordinal());
    }

    @Override
    public void moreculling$resetTranslucencyCache(BlockState state) {
        this.solidFaces = 0;
        block0: for (Direction face : DirectionUtils.DIRECTIONS) {
            List<BakedQuad> quads = Services.PLATFORM.getQuads((BakedModel)this, state, face, CullingUtils.RANDOM, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
            if (quads.isEmpty()) {
                this.solidFaces = BitUtils.unset(this.solidFaces, face.ordinal());
                continue;
            }
            this.solidFaces = BitUtils.set(this.solidFaces, face.ordinal());
            for (BakedQuad quad : quads) {
                if (!((QuadOpacity)quad).moreculling$getTextureTranslucency()) continue;
                this.solidFaces = BitUtils.unset(this.solidFaces, face.ordinal());
                continue block0;
            }
        }
    }
}

